/*
 * Decompiled with CFR 0.152.
 */
package com.tetra_loopback.effects.curio;

import com.tetra_loopback.effects.gui.ModEffectStats;
import java.util.UUID;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import se.mickelus.tetra.items.modular.ModularItem;
import top.theillusivec4.curios.api.CuriosApi;

@Mod.EventBusSubscriber(modid="tetra_loopback")
public class EtherealGlowEffect {
    private static final UUID SPEED_UUID = UUID.fromString("d9aae8a1-1234-5678-9abc-def012345681");
    private static final int CHECK_INTERVAL = 20;
    private static final double RANGE = 12.0;

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase != TickEvent.Phase.END || event.player.m_9236_().f_46443_) {
            return;
        }
        Player player = event.player;
        boolean hasEffect = EtherealGlowEffect.hasEffect(player);
        EtherealGlowEffect.handleMovementSpeed(player, hasEffect);
        EtherealGlowEffect.handleNightVision(player, hasEffect);
        if (player.f_19797_ % 20 == 0 && hasEffect) {
            EtherealGlowEffect.applyGlowToMobs(player);
        }
    }

    private static void handleMovementSpeed(Player player, boolean active) {
        AttributeModifier modifier = new AttributeModifier(SPEED_UUID, "ethereal_glow_speed", 0.2, AttributeModifier.Operation.MULTIPLY_TOTAL);
        if (active) {
            if (!player.m_21051_(Attributes.f_22279_).m_22109_(modifier)) {
                player.m_21051_(Attributes.f_22279_).m_22118_(modifier);
            }
        } else {
            player.m_21051_(Attributes.f_22279_).m_22120_(SPEED_UUID);
        }
    }

    private static void handleNightVision(Player player, boolean active) {
        int DURATION = 400;
        int REFRESH_THRESHOLD = 200;
        if (active) {
            MobEffectInstance current = player.m_21124_(MobEffects.f_19611_);
            if (current == null || current.m_19557_() < 200 || !current.m_19576_().equals("effect.tetra_loopback.night_vision")) {
                player.m_7292_(new MobEffectInstance(MobEffects.f_19611_, 400, 0, false, false, true){

                    public String m_19576_() {
                        return "effect.tetra_loopback.night_vision";
                    }
                });
            }
        } else {
            MobEffectInstance effect = player.m_21124_(MobEffects.f_19611_);
            if (effect != null && effect.m_19576_().equals("effect.tetra_loopback.night_vision")) {
                player.m_21195_(MobEffects.f_19611_);
            }
        }
    }

    private static void applyGlowToMobs(Player player) {
        int duration = 60;
        player.m_9236_().m_45976_(LivingEntity.class, player.m_20191_().m_82400_(12.0)).stream().filter(entity -> entity instanceof Enemy).forEach(entity -> {
            entity.m_7292_(new MobEffectInstance(MobEffects.f_19619_, duration, 0, false, true, true));
            entity.m_20256_(entity.m_20184_());
        });
    }

    private static boolean hasEffect(Player player) {
        return CuriosApi.getCuriosInventory((LivingEntity)player).map(inv -> inv.findCurios(itemStack -> itemStack.m_41720_() instanceof ModularItem && ((ModularItem)itemStack.m_41720_()).getEffectLevel(itemStack, ModEffectStats.etherealGlowEffect) > 0)).map(list -> !list.isEmpty()).orElse(false);
    }
}

