/*
 * Decompiled with CFR 0.152.
 */
package com.tetra_loopback.effects.curio;

import com.tetra_loopback.effects.gui.ModEffectStats;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.joml.Vector3f;
import se.mickelus.tetra.items.modular.ModularItem;
import top.theillusivec4.curios.api.CuriosApi;

@Mod.EventBusSubscriber(modid="tetra_loopback")
public class CrimsonScourgeEffect {
    private static final int BASE_DURATION = 60;
    private static final int DAMAGE_INTERVAL = 20;
    private static final float BASE_DAMAGE = 0.01f;
    private static final float STACK_BONUS = 0.001f;
    private static final int MAX_STACKS = 10;
    private static final Vector3f PURPLE_COLOR = new Vector3f(0.5f, 0.0f, 0.5f);
    private static final Vector3f BLACK_COLOR = new Vector3f(0.1f, 0.1f, 0.1f);
    private static final DustParticleOptions PURPLE_PARTICLE = new DustParticleOptions(PURPLE_COLOR, 0.8f);
    private static final DustParticleOptions BLACK_PARTICLE = new DustParticleOptions(BLACK_COLOR, 1.5f);
    private static final DustParticleOptions RED_PARTICLE = new DustParticleOptions(new Vector3f(0.9f, 0.1f, 0.1f), 0.5f);
    private static final Map<UUID, CurseData> curseDataMap = new ConcurrentHashMap<UUID, CurseData>();

    @SubscribeEvent
    public static void onAttack(LivingAttackEvent event) {
        Player attacker;
        Entity entity = event.getSource().m_7639_();
        if (entity instanceof Player && CrimsonScourgeEffect.hasEffect(attacker = (Player)entity)) {
            LivingEntity target = event.getEntity();
            if (target.m_21223_() < target.m_21233_() * 0.4f) {
                return;
            }
            UUID targetId = target.m_20148_();
            long currentTime = target.m_9236_().m_46467_();
            CurseData data = curseDataMap.compute(targetId, (k, v) -> v == null ? new CurseData(0, currentTime + 60L) : new CurseData(v.stacks, currentTime + 60L));
            if (Math.random() < 0.25 && data.stacks < 10) {
                data = new CurseData(data.stacks + 1, data.endTime);
                curseDataMap.put(targetId, data);
                CrimsonScourgeEffect.spawnParticles(target, PURPLE_PARTICLE, 15, 0.5);
            }
            if (data.stacks >= 10) {
                if (target.m_21223_() >= target.m_21233_() * 0.4f) {
                    target.m_6469_(target.m_269291_().m_269425_(), target.m_21233_() * 0.4f);
                    CrimsonScourgeEffect.spawnParticles(target, BLACK_PARTICLE, 50, 1.0);
                }
                curseDataMap.remove(targetId);
            }
        }
    }

    @SubscribeEvent
    public static void onLivingTick(LivingEvent.LivingTickEvent event) {
        Level level;
        LivingEntity entity = event.getEntity();
        UUID uuid = entity.m_20148_();
        CurseData data = curseDataMap.get(uuid);
        if (data != null && (level = entity.m_9236_()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            long currentTime = serverLevel.m_46467_();
            if (currentTime > data.endTime || entity.m_21223_() < entity.m_21233_() * 0.4f) {
                curseDataMap.remove(uuid);
                return;
            }
            if (currentTime - data.lastDamageTick >= 20L) {
                float damagePercent = 0.01f + 0.001f * (float)data.stacks;
                entity.m_6469_(entity.m_269291_().m_269425_(), entity.m_21233_() * damagePercent);
                data.lastDamageTick = currentTime;
                CrimsonScourgeEffect.spawnParticles(entity, RED_PARTICLE, 10 + data.stacks * 3, 0.5);
                curseDataMap.put(uuid, data);
            }
        }
    }

    private static void spawnParticles(LivingEntity target, DustParticleOptions options, int count, double spread) {
        Level level = target.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.m_8767_((ParticleOptions)options, target.m_20185_(), target.m_20186_() + (double)(target.m_20206_() / 2.0f), target.m_20189_(), count, spread, spread, spread, 0.3);
        }
    }

    private static boolean hasEffect(Player player) {
        return CuriosApi.getCuriosInventory((LivingEntity)player).map(inv -> inv.findCurios(stack -> stack.m_41720_() instanceof ModularItem && ((ModularItem)stack.m_41720_()).getEffectLevel(stack, ModEffectStats.crimsonScourgeEffect) > 0)).map(list -> !list.isEmpty()).orElse(false);
    }

    private static class CurseData {
        int stacks;
        long endTime;
        long lastDamageTick;

        CurseData(int stacks, long endTime) {
            this.stacks = Math.min(stacks, 10);
            this.endTime = endTime;
            this.lastDamageTick = 0L;
        }
    }
}

