/*
 * Decompiled with CFR 0.152.
 */
package com.tetra_loopback.effects.curio;

import com.tetra_loopback.effects.gui.ModEffectStats;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import se.mickelus.tetra.effect.ItemEffect;
import se.mickelus.tetra.items.modular.ModularItem;
import top.theillusivec4.curios.api.CuriosApi;

@Mod.EventBusSubscriber(modid="tetra_loopback")
public class AttributeCurioEffect {
    private static final Map<UUID, Map<Attribute, AttributeModifier>> playerModifiers = new ConcurrentHashMap<UUID, Map<Attribute, AttributeModifier>>();
    private static final Map<Attribute, Double> ATTRIBUTE_MULTIPLIERS = new HashMap<Attribute, Double>();
    private static final Map<ItemEffect, Attribute> effectToAttribute;

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase != TickEvent.Phase.END || event.player.m_9236_().f_46443_) {
            return;
        }
        Player player = event.player;
        AttributeCurioEffect.clearOldModifiers(player);
        HashMap<Attribute, Integer> totalLevels = new HashMap<Attribute, Integer>();
        CuriosApi.getCuriosInventory((LivingEntity)player).ifPresent(inv -> inv.findCurios(itemStack -> itemStack.m_41720_() instanceof ModularItem).forEach(slotResult -> {
            ItemStack stack = slotResult.stack();
            ModularItem item = (ModularItem)stack.m_41720_();
            effectToAttribute.forEach((effect, attribute) -> {
                int level = item.getEffectLevel(stack, effect);
                if (level > 0) {
                    totalLevels.merge((Attribute)attribute, level, Integer::sum);
                }
            });
        }));
        AttributeCurioEffect.applyModifiers(player, totalLevels);
    }

    private static void clearOldModifiers(Player player) {
        Map<Attribute, AttributeModifier> modifiers = playerModifiers.getOrDefault(player.m_20148_(), Collections.emptyMap());
        modifiers.forEach((attribute, modifier) -> {
            if (player.m_21051_(attribute) != null && player.m_21051_(attribute).m_22109_(modifier)) {
                player.m_21051_(attribute).m_22130_(modifier);
            }
        });
        playerModifiers.remove(player.m_20148_());
    }

    private static void applyModifiers(Player player, Map<Attribute, Integer> totalLevels) {
        HashMap applied = new HashMap();
        totalLevels.forEach((attribute, level) -> {
            double value = AttributeCurioEffect.getValueByAttribute(attribute, level);
            UUID uuid = AttributeCurioEffect.generateUUID(player.m_20148_(), attribute);
            AttributeModifier modifier = new AttributeModifier(uuid, "tetra_loopback_attribute", value, AttributeCurioEffect.getOperation(attribute));
            if (player.m_21051_(attribute) != null) {
                player.m_21051_(attribute).m_22120_(uuid);
                player.m_21051_(attribute).m_22118_(modifier);
                applied.put(attribute, modifier);
            }
        });
        playerModifiers.put(player.m_20148_(), applied);
    }

    private static UUID generateUUID(UUID playerId, Attribute attribute) {
        return UUID.nameUUIDFromBytes((playerId.toString() + attribute.m_22087_()).getBytes());
    }

    private static double getValueByAttribute(Attribute attribute, int level) {
        return ATTRIBUTE_MULTIPLIERS.getOrDefault(attribute, 1.0) * (double)level;
    }

    private static AttributeModifier.Operation getOperation(Attribute attribute) {
        return attribute == Attributes.f_22280_ ? AttributeModifier.Operation.MULTIPLY_TOTAL : AttributeModifier.Operation.ADDITION;
    }

    static {
        ATTRIBUTE_MULTIPLIERS.put(Attributes.f_22284_, 1.0);
        ATTRIBUTE_MULTIPLIERS.put(Attributes.f_22281_, 1.0);
        ATTRIBUTE_MULTIPLIERS.put(Attributes.f_22279_, 0.01);
        ATTRIBUTE_MULTIPLIERS.put(Attributes.f_22285_, 1.0);
        ATTRIBUTE_MULTIPLIERS.put(Attributes.f_22276_, 1.0);
        ATTRIBUTE_MULTIPLIERS.put(Attributes.f_22283_, 0.1);
        ATTRIBUTE_MULTIPLIERS.put(Attributes.f_22280_, 0.1);
        ATTRIBUTE_MULTIPLIERS.put(Attributes.f_22277_, 1.0);
        ATTRIBUTE_MULTIPLIERS.put(Attributes.f_22278_, 1.0);
        ATTRIBUTE_MULTIPLIERS.put(Attributes.f_22286_, 1.0);
        effectToAttribute = Map.ofEntries(Map.entry(ModEffectStats.attackDamageEffect, Attributes.f_22281_), Map.entry(ModEffectStats.attackKnockbackEffect, Attributes.f_22282_), Map.entry(ModEffectStats.armorEffect, Attributes.f_22284_), Map.entry(ModEffectStats.armorToughnessEffect, Attributes.f_22285_), Map.entry(ModEffectStats.movementSpeedEffect, Attributes.f_22279_), Map.entry(ModEffectStats.maxHealthEffect, Attributes.f_22276_), Map.entry(ModEffectStats.attackSpeedEffect, Attributes.f_22283_), Map.entry(ModEffectStats.flyingSpeedEffect, Attributes.f_22280_), Map.entry(ModEffectStats.followRangeEffect, Attributes.f_22277_), Map.entry(ModEffectStats.knockbackResistanceEffect, Attributes.f_22278_), Map.entry(ModEffectStats.luckEffect, Attributes.f_22286_));
    }
}

