/*
 * Decompiled with CFR 0.152.
 */
package com.tetra_loopback.effects;

import java.util.UUID;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.phys.Vec3;

public class ThunderEffect
extends MobEffect {
    private static final UUID ATTACK_DAMAGE_UUID = UUID.fromString("1a2b3c4d-5e6f-7a8b-9c0d-1e2f3a4b5c6d");
    private static final String COOLDOWN_TAG = "ThunderCooldown";
    private static final String ATTACK_BONUS_TAG = "ThunderAttackBonus";
    private static final String LAST_COMBAT_TAG = "LastCombatTime";

    public ThunderEffect() {
        super(MobEffectCategory.BENEFICIAL, 49151);
    }

    public void m_6742_(LivingEntity entity, int amplifier) {
        long lastCombatTime;
        long currentTime;
        if (!entity.m_9236_().f_46443_ && (currentTime = entity.m_9236_().m_46467_()) - (lastCombatTime = entity.getPersistentData().m_128454_(LAST_COMBAT_TAG)) > 300L) {
            this.resetAttackBonus(entity);
        }
    }

    public boolean m_6584_(int duration, int amplifier) {
        return true;
    }

    private void resetAttackBonus(LivingEntity entity) {
        if (entity.m_21051_(Attributes.f_22281_).m_22111_(ATTACK_DAMAGE_UUID) != null) {
            entity.m_21051_(Attributes.f_22281_).m_22120_(ATTACK_DAMAGE_UUID);
        }
        entity.getPersistentData().m_128473_(ATTACK_BONUS_TAG);
    }

    public static void tryTriggerThunder(LivingEntity attacker, LivingEntity target) {
        if (attacker.m_9236_().f_46443_) {
            return;
        }
        CompoundTag persistentData = attacker.getPersistentData();
        long gameTime = attacker.m_9236_().m_46467_();
        if (gameTime < persistentData.m_128454_(COOLDOWN_TAG)) {
            return;
        }
        if (attacker.m_217043_().m_188501_() < 0.2f) {
            LightningBolt lightning = new LightningBolt(EntityType.f_20465_, attacker.m_9236_());
            lightning.m_20219_(Vec3.m_82539_((Vec3i)target.m_20183_()));
            attacker.m_9236_().m_7967_((Entity)lightning);
            persistentData.m_128356_(COOLDOWN_TAG, gameTime + 200L);
            int currentBonus = persistentData.m_128451_(ATTACK_BONUS_TAG) + 2;
            persistentData.m_128405_(ATTACK_BONUS_TAG, currentBonus);
            if (attacker.m_21051_(Attributes.f_22281_) != null) {
                attacker.m_21051_(Attributes.f_22281_).m_22120_(ATTACK_DAMAGE_UUID);
                AttributeModifier modifier = new AttributeModifier(ATTACK_DAMAGE_UUID, "Thunder Attack Bonus", (double)currentBonus, AttributeModifier.Operation.ADDITION);
                attacker.m_21051_(Attributes.f_22281_).m_22118_(modifier);
            }
            persistentData.m_128356_(LAST_COMBAT_TAG, gameTime);
        }
    }
}

