/*
 * Decompiled with CFR 0.152.
 */
package com.tetra_loopback;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(modid="tetra_loopback", bus=Mod.EventBusSubscriber.Bus.MOD)
public class Config {
    private static final ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
    private static final ForgeConfigSpec.ConfigValue<String> EMBLEM_POSITION = BUILDER.comment("Wearing position: LEFT, CENTER, RIGHT").define("emblemPosition", (Object)"RIGHT", Config::validatePosition);
    private static final ForgeConfigSpec.DoubleValue EMBLEM_DEPTH = BUILDER.comment("depth (0.0-1.0, The lower the value, the closer it is to the body)").defineInRange("emblemDepth", 0.1, 0.0, 1.0);
    private static final ForgeConfigSpec.DoubleValue EMBLEM_SCALE = BUILDER.comment("emblem scale (0.1-2.0)").defineInRange("emblemScale", 0.25, 0.1, 2.0);
    private static final ForgeConfigSpec.ConfigValue<List<? extends String>> ITEM_STRINGS = BUILDER.comment("A list of items to log on common setup.").defineListAllowEmpty("items", List.of("minecraft:iron_ingot"), Config::validateItemName);
    static final ForgeConfigSpec SPEC = BUILDER.build();
    public static String emblemPosition;
    public static double emblemDepth;
    public static double emblemScale;
    public static Set<Item> items;

    private static boolean validatePosition(Object obj) {
        if (obj instanceof String) {
            String position = ((String)obj).toUpperCase();
            return position.equals("LEFT") || position.equals("CENTER") || position.equals("RIGHT");
        }
        return false;
    }

    private static boolean validateItemName(Object obj) {
        String itemName;
        return obj instanceof String && ForgeRegistries.ITEMS.containsKey(new ResourceLocation(itemName = (String)obj));
    }

    @SubscribeEvent
    static void onLoad(ModConfigEvent event) {
        emblemPosition = ((String)EMBLEM_POSITION.get()).toUpperCase();
        emblemDepth = (Double)EMBLEM_DEPTH.get();
        emblemScale = (Double)EMBLEM_SCALE.get();
        items = ((List)ITEM_STRINGS.get()).stream().map(itemName -> (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(itemName))).collect(Collectors.toSet());
    }
}

