/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.module.schematic.requirement;

import java.util.List;
import java.util.Optional;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;
import se.mickelus.tetra.aspect.ItemAspect;
import se.mickelus.tetra.module.schematic.CraftingContext;
import se.mickelus.tetra.module.schematic.requirement.CraftingRequirement;
import se.mickelus.tetra.module.schematic.requirement.IntegerPredicate;

public class AspectRequirement
implements CraftingRequirement {
    ItemAspect aspect;
    IntegerPredicate level;

    public AspectRequirement(ItemAspect aspect, IntegerPredicate level) {
        this.aspect = aspect;
        this.level = level;
    }

    @Override
    public boolean test(CraftingContext context) {
        return Optional.ofNullable(context.targetModule).map(module -> module.getAspects(context.targetStack)).filter(aspects -> aspects.contains(this.aspect)).map(aspects -> this.level == null || this.level.test(aspects.getLevel(this.aspect))).orElse(false);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    @Nullable
    public List<Component> getDescription() {
        if (this.level != null) {
            return List.of(Component.m_237113_((String)I18n.m_118938_((String)"tetra.holo.aspect_requirement_level", (Object[])new Object[]{this.aspect.getLabel().getString(), this.level.getDescription(I18n.m_118938_((String)"tetra.holo.aspect_requirement_level.level_label", (Object[])new Object[0]))})));
        }
        return List.of(Component.m_237113_((String)I18n.m_118938_((String)"tetra.holo.aspect_requirement", (Object[])new Object[]{this.aspect.getLabel().getString()})));
    }
}

