/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.items.modular.impl.holo.gui.craft.schematic;

import java.util.Arrays;
import java.util.Comparator;
import java.util.function.Consumer;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import se.mickelus.mutil.gui.GuiElement;
import se.mickelus.mutil.gui.GuiStringSmall;
import se.mickelus.mutil.gui.animation.Applier;
import se.mickelus.mutil.gui.animation.KeyframeAnimation;
import se.mickelus.tetra.items.modular.IModularItem;
import se.mickelus.tetra.items.modular.impl.holo.gui.craft.schematic.HoloSchematicListItemGui;
import se.mickelus.tetra.items.modular.impl.holo.gui.craft.schematic.HoloToggleVisibilityButtonGui;
import se.mickelus.tetra.module.SchematicRegistry;
import se.mickelus.tetra.module.schematic.CraftingContext;
import se.mickelus.tetra.module.schematic.SchematicType;
import se.mickelus.tetra.module.schematic.UpgradeSchematic;

@ParametersAreNonnullByDefault
public class HoloSchematicListGui
extends GuiElement {
    private final Consumer<UpgradeSchematic> onSchematicSelect;
    private final KeyframeAnimation openAnimation;
    private final KeyframeAnimation showAnimation;
    private final KeyframeAnimation hideAnimation;
    boolean displayAllSchematics = false;
    UpgradeSchematic[] availableSchematics;
    UpgradeSchematic[] allSchematics;
    private final GuiElement schematicContainer;
    private final HoloToggleVisibilityButtonGui toggleButton;

    public HoloSchematicListGui(int x, int y, int width, int height, Consumer<UpgradeSchematic> onSchematicSelect) {
        super(x, y, width, height);
        this.onSchematicSelect = onSchematicSelect;
        this.toggleButton = new HoloToggleVisibilityButtonGui(0, 2, this::toggleDisplay);
        this.addChild((GuiElement)this.toggleButton);
        this.addChild((GuiElement)new GuiStringSmall(0, 17, "Schematics", 0x7F7F7F));
        this.schematicContainer = new GuiElement(0, 23, width, height);
        this.addChild(this.schematicContainer);
        this.openAnimation = new KeyframeAnimation(80, (GuiElement)this).applyTo(new Applier[]{new Applier.Opacity(0.0f, 1.0f), new Applier.TranslateY((float)(y - 5), (float)y)}).withDelay(120);
        this.showAnimation = new KeyframeAnimation(80, (GuiElement)this).applyTo(new Applier[]{new Applier.Opacity(1.0f), new Applier.TranslateY((float)y)});
        this.hideAnimation = new KeyframeAnimation(60, (GuiElement)this).applyTo(new Applier[]{new Applier.Opacity(0.0f), new Applier.TranslateY((float)(y - 5))}).onStop(complete -> {
            this.isVisible = false;
        });
        this.isVisible = false;
    }

    private void toggleDisplay() {
        this.displayAllSchematics = !this.displayAllSchematics;
        this.toggleButton.update(this.displayAllSchematics);
        this.updateSchematics();
    }

    public void update(IModularItem item, String slot) {
        Minecraft mc = Minecraft.m_91087_();
        CraftingContext context = new CraftingContext(mc.f_91074_.m_9236_(), mc.f_91074_.m_20097_(), null, (Player)mc.f_91074_, new ItemStack((ItemLike)item.getItem()), slot, new ResourceLocation[0]);
        this.allSchematics = (UpgradeSchematic[])Arrays.stream(SchematicRegistry.getPreviewSchematics(context, true)).filter(schematic -> !schematic.isHoning()).filter(schematic -> schematic.getType() != SchematicType.improvement).sorted(Comparator.comparing(UpgradeSchematic::getName)).toArray(UpgradeSchematic[]::new);
        this.availableSchematics = (UpgradeSchematic[])Arrays.stream(SchematicRegistry.getPreviewSchematics(context, false)).filter(schematic -> !schematic.isHoning()).filter(schematic -> schematic.getType() != SchematicType.improvement).sorted(Comparator.comparing(UpgradeSchematic::getName)).toArray(UpgradeSchematic[]::new);
        this.updateSchematics();
    }

    private void updateSchematics() {
        int offset = 0;
        int pageLines = 8;
        this.schematicContainer.clearChildren();
        UpgradeSchematic[] schematics = this.displayAllSchematics ? this.allSchematics : this.availableSchematics;
        for (int i = 0; i < schematics.length; ++i) {
            UpgradeSchematic schematic = schematics[i + offset];
            this.schematicContainer.addChild((GuiElement)new HoloSchematicListItemGui(i / pageLines * 106, i % pageLines * 14, 103, schematic, () -> this.onSchematicSelect.accept(schematic)));
        }
    }

    public void animateOpen() {
        this.openAnimation.start();
    }

    protected void onShow() {
        super.onShow();
        if (this.hideAnimation.isActive()) {
            this.hideAnimation.stop();
        }
        this.showAnimation.start();
    }

    protected boolean onHide() {
        if (this.showAnimation.isActive()) {
            this.showAnimation.stop();
        }
        this.hideAnimation.start();
        return false;
    }
}

