/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.items.modular.impl.holo.gui.craft.schematic;

import com.google.common.collect.Multimap;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.ChatFormatting;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraftforge.common.ToolAction;
import se.mickelus.mutil.gui.GuiElement;
import se.mickelus.mutil.gui.GuiTexture;
import se.mickelus.tetra.effect.ItemEffect;
import se.mickelus.tetra.gui.GuiTextures;
import se.mickelus.tetra.module.data.EffectData;
import se.mickelus.tetra.module.data.MaterialMultiplier;
import se.mickelus.tetra.module.data.ToolData;
import se.mickelus.tetra.module.schematic.SchematicType;
import se.mickelus.tetra.module.schematic.UpgradeSchematic;

@ParametersAreNonnullByDefault
public class HoloMaterialTranslationGui
extends GuiElement {
    private final List<Component> emptyTooltipImprovement;
    private final List<Component> emptyTooltip;
    private final GuiTexture icon = new GuiTexture(0, 0, 9, 9, 224, 0, GuiTextures.workbench);
    private List<Component> tooltip;

    public HoloMaterialTranslationGui(int x, int y) {
        super(x, y, 9, 9);
        this.addChild((GuiElement)this.icon);
        this.emptyTooltipImprovement = Collections.singletonList(Component.m_237115_((String)"tetra.holo.craft.empty_translation_improvement"));
        this.emptyTooltip = Collections.singletonList(Component.m_237115_((String)"tetra.holo.craft.empty_translation_module"));
    }

    public List<Component> getTooltipLines() {
        if (this.hasFocus()) {
            return this.tooltip;
        }
        return null;
    }

    public void update(UpgradeSchematic schematic) {
        MaterialMultiplier translation = schematic.getMaterialTranslation();
        if (translation != null) {
            LinkedList<String> primary = new LinkedList<String>();
            LinkedList<String> secondary = new LinkedList<String>();
            LinkedList<String> tertiary = new LinkedList<String>();
            this.extractAttributes(translation.primaryAttributes, primary);
            this.extractAttributes(translation.secondaryAttributes, secondary);
            this.extractAttributes(translation.tertiaryAttributes, tertiary);
            this.extractEffects(translation.primaryEffects, primary);
            this.extractEffects(translation.secondaryEffects, secondary);
            this.extractEffects(translation.tertiaryEffects, tertiary);
            LinkedList<String> result = new LinkedList<String>();
            if (schematic.getType() == SchematicType.improvement) {
                result.add(I18n.m_118938_((String)"tetra.holo.craft.translation_improvement", (Object[])new Object[0]));
            } else {
                result.add(I18n.m_118938_((String)"tetra.holo.craft.translation_module", (Object[])new Object[0]));
            }
            if (translation.durability != null || translation.integrity != null) {
                result.add(" ");
            }
            if (translation.durability != null) {
                result.add(this.getStatLine("tetra.stats.durability", translation.durability.intValue()));
            }
            if (translation.integrity != null) {
                result.add(this.getStatLine("tetra.stats.integrity", translation.integrity.intValue()));
            }
            this.extractTools(translation.tools, result);
            if (!primary.isEmpty()) {
                result.add(" ");
                result.add(ChatFormatting.WHITE + I18n.m_118938_((String)"tetra.holo.craft.materials.stat.primary", (Object[])new Object[0]) + ":");
                result.addAll(primary);
            }
            if (!secondary.isEmpty()) {
                result.add(" ");
                result.add(ChatFormatting.WHITE + I18n.m_118938_((String)"tetra.holo.craft.materials.stat.secondary", (Object[])new Object[0]) + ":");
                result.addAll(secondary);
            }
            if (!tertiary.isEmpty()) {
                result.add(" ");
                result.add(ChatFormatting.WHITE + I18n.m_118938_((String)"tetra.holo.craft.materials.stat.tertiary", (Object[])new Object[0]) + ":");
                result.addAll(tertiary);
            }
            this.tooltip = result.stream().map(Component::m_237113_).collect(Collectors.toList());
        } else {
            this.tooltip = schematic.getType() == SchematicType.improvement ? this.emptyTooltipImprovement : this.emptyTooltip;
        }
    }

    private String getStatLine(String unlocalizedStat, int value) {
        return this.getStatLine(unlocalizedStat, value, null);
    }

    private String getStatLine(String unlocalizedStat, int value, @Nullable String unlocalizedSuffix) {
        if (I18n.m_118936_((String)unlocalizedStat)) {
            StringBuilder line = new StringBuilder(ChatFormatting.GRAY.toString());
            line.append(I18n.m_118938_((String)unlocalizedStat, (Object[])new Object[0]));
            if (unlocalizedSuffix != null) {
                line.append(" ");
                line.append(I18n.m_118938_((String)unlocalizedSuffix, (Object[])new Object[0]));
            }
            if (value < 0) {
                line.append(ChatFormatting.RED);
                line.append(" -");
            } else {
                line.append(ChatFormatting.GREEN);
                line.append(" +");
            }
            line.append(I18n.m_118938_((String)("enchantment.level." + Math.abs(value)), (Object[])new Object[0]));
            return line.toString();
        }
        return null;
    }

    private void extractAttributes(Multimap<Attribute, AttributeModifier> attributes, List<String> result) {
        if (attributes != null) {
            attributes.entries().stream().map(entry -> this.getStatLine(((Attribute)entry.getKey()).m_22087_(), (int)((AttributeModifier)entry.getValue()).m_22218_(), ((AttributeModifier)entry.getValue()).m_22217_() != AttributeModifier.Operation.ADDITION ? "tetra.attribute.multiplier" : null)).filter(Objects::nonNull).map(line -> "  " + line).forEach(result::add);
        }
    }

    private void extractEffects(EffectData effects, List<String> result) {
        if (effects != null) {
            effects.getValues().stream().map(effect -> this.extractEffectLevel((ItemEffect)effect, effects)).filter(Objects::nonNull).map(line -> "  " + line).forEach(result::add);
            effects.getValues().stream().map(effect -> this.extractEffectEfficiency((ItemEffect)effect, effects)).filter(Objects::nonNull).map(line -> "  " + line).forEach(result::add);
        }
    }

    private String extractEffectLevel(ItemEffect effect, EffectData effects) {
        int level = effects.getLevel(effect);
        if (level != 0) {
            String levelKey = "tetra.stats." + effect.getKey() + ".level";
            return this.getStatLine(I18n.m_118936_((String)levelKey) ? levelKey : "tetra.stats." + effect.getKey(), level);
        }
        return null;
    }

    private String extractEffectEfficiency(ItemEffect effect, EffectData effects) {
        int efficiency = (int)effects.getEfficiency(effect);
        if (efficiency != 0) {
            return this.getStatLine("tetra.stats." + effect.getKey() + ".efficiency", efficiency);
        }
        return null;
    }

    private void extractTools(ToolData tools, List<String> result) {
        if (tools != null) {
            result.add("");
            tools.getValues().stream().map(tool -> this.extractToolLevel((ToolAction)tool, tools)).filter(Objects::nonNull).forEach(result::add);
            tools.getValues().stream().map(tool -> this.extractToolEfficiency((ToolAction)tool, tools)).filter(Objects::nonNull).forEach(result::add);
        }
    }

    private String extractToolLevel(ToolAction tool, ToolData toolData) {
        int level = toolData.getLevel(tool);
        if (level != 0) {
            return this.getStatLine("tetra.tool." + tool.name(), level, "tetra.stats.tier_suffix");
        }
        return null;
    }

    private String extractToolEfficiency(ToolAction tool, ToolData toolData) {
        int efficiency = (int)toolData.getEfficiency(tool);
        if (efficiency != 0) {
            return this.getStatLine("tetra.tool." + tool.name(), efficiency, "tetra.stats.efficiency_suffix");
        }
        return null;
    }
}

