/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.items.modular.impl.holo.gui.craft;

import com.google.common.collect.ImmutableMap;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.world.item.ItemStack;
import se.mickelus.tetra.items.modular.impl.holo.gui.craft.HolosphereEntryData;
import se.mickelus.tetra.module.schematic.OutcomePreview;
import se.mickelus.tetra.module.schematic.UpgradeSchematic;

public class HolosphereCraftState {
    ImmutableMap<String, ItemState> itemState = ImmutableMap.of();
    private String selectedItem = null;
    private String selectedSlot = null;
    private UpgradeSchematic selectedSchematic = null;
    private OutcomePreview selectedVariant = null;
    private boolean showingMaterials = false;
    private Runnable onNavigationChange;

    public HolosphereCraftState(Runnable onNavigationChange) {
        this.onNavigationChange = onNavigationChange;
    }

    public int getDepth() {
        if (this.showingMaterials) {
            return 1;
        }
        if (this.selectedVariant != null) {
            return 4;
        }
        if (this.selectedSchematic != null) {
            return 3;
        }
        if (this.selectedSlot != null) {
            return 2;
        }
        if (this.selectedItem != null) {
            return 1;
        }
        return 0;
    }

    public String getSelectedItem() {
        return this.selectedItem;
    }

    public String getSelectedSlot() {
        return this.selectedSlot;
    }

    public String getSelectedSlotName() {
        ItemState selectedItemState = this.getSelectedItemState();
        if (selectedItemState != null) {
            ItemStack itemStack = selectedItemState.itemData.getDefaultStack();
            String[] majorKeys = selectedItemState.itemData().getAsModularItem().getMajorModuleKeys(itemStack);
            for (int i = 0; i < majorKeys.length; ++i) {
                if (!majorKeys[i].equals(this.selectedSlot)) continue;
                return selectedItemState.itemData().getAsModularItem().getMajorModuleNames(itemStack)[i];
            }
            String[] minorKeys = selectedItemState.itemData().getAsModularItem().getMinorModuleKeys(itemStack);
            for (int i = 0; i < minorKeys.length; ++i) {
                if (!minorKeys[i].equals(this.selectedSlot)) continue;
                return selectedItemState.itemData().getAsModularItem().getMinorModuleNames(itemStack)[i];
            }
        }
        return this.selectedSlot;
    }

    public UpgradeSchematic getSelectedSchematic() {
        return this.selectedSchematic;
    }

    public OutcomePreview getSelectedVariant() {
        return this.selectedVariant;
    }

    public boolean isShowingMaterials() {
        return this.showingMaterials;
    }

    public ImmutableMap<String, ItemState> getItemState() {
        return this.itemState;
    }

    @Nullable
    public ItemState getSelectedItemState() {
        if (this.selectedItem != null) {
            return (ItemState)this.itemState.get((Object)this.selectedItem);
        }
        return null;
    }

    public void setAvailableItems(Map<String, HolosphereEntryData> entries) {
        this.itemState = entries.entrySet().stream().collect(Collectors.collectingAndThen(Collectors.toMap(Map.Entry::getKey, entry -> new ItemState((HolosphereEntryData)entry.getValue(), ((HolosphereEntryData)entry.getValue()).getDefaultStack())), ImmutableMap::copyOf));
    }

    public List<HolosphereEntryData> getSortedItemData() {
        return this.itemState.values().stream().map(ItemState::itemData).sorted(Comparator.comparingInt(entry -> entry.position < 0 ? Integer.MAX_VALUE : entry.position)).toList();
    }

    public void onMaterialsSelect() {
        this.selectedItem = null;
        this.selectedSlot = null;
        this.selectedSchematic = null;
        this.showingMaterials = true;
        this.onNavigationChange.run();
    }

    public void onItemSelect(String item) {
        this.selectedItem = item;
        this.selectedSlot = null;
        this.selectedVariant = null;
        this.selectedSchematic = null;
        this.showingMaterials = false;
        this.onNavigationChange.run();
    }

    public void onSlotSelect(String slot) {
        this.selectedSlot = slot;
        this.selectedVariant = null;
        this.selectedSchematic = null;
        this.showingMaterials = false;
        this.onNavigationChange.run();
    }

    public void onSchematicSelect(UpgradeSchematic schematic) {
        this.selectedSchematic = schematic;
        this.selectedVariant = null;
        this.showingMaterials = false;
        this.onNavigationChange.run();
    }

    public void onVariantSelect(OutcomePreview variant) {
        this.selectedVariant = variant;
        this.showingMaterials = false;
        this.onNavigationChange.run();
    }

    public void openFromWorkbench(String key, ItemStack itemStack, String slot, UpgradeSchematic schematic) {
        this.selectedItem = key;
        this.selectedSlot = slot;
        this.selectedSchematic = schematic;
        this.onNavigationChange.run();
    }

    public String getSelectedItemName() {
        return Optional.ofNullable(this.getSelectedItemState()).map(ItemState::itemData).map(itemData -> I18n.m_118938_((String)I18n.m_118938_((String)("tetra.holo.craft." + itemData.key), (Object[])new Object[0]), (Object[])new Object[0])).orElse("???");
    }

    public static class ItemState {
        HolosphereEntryData itemData;
        ItemStack workingStack;

        public ItemState(HolosphereEntryData itemData, ItemStack workingStack) {
            this.itemData = itemData;
            this.workingStack = workingStack;
        }

        public HolosphereEntryData itemData() {
            return this.itemData;
        }

        public void setWorkingStack(ItemStack workingStack) {
            this.workingStack = workingStack;
        }

        public ItemStack workingStack() {
            return this.workingStack;
        }
    }
}

