/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.gui.stats.getter;

import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.ForgeMod;
import se.mickelus.tetra.effect.ItemEffect;
import se.mickelus.tetra.effect.ReachingEffect;
import se.mickelus.tetra.gui.stats.getter.IStatGetter;
import se.mickelus.tetra.gui.stats.getter.ITooltipGetter;
import se.mickelus.tetra.gui.stats.getter.StatGetterAttribute;
import se.mickelus.tetra.gui.stats.getter.StatGetterEffectEfficiency;
import se.mickelus.tetra.gui.stats.getter.StatGetterEffectLevel;

@ParametersAreNonnullByDefault
public class TooltipGetterReaching
implements ITooltipGetter {
    private final IStatGetter levelGetter = new StatGetterEffectLevel(ItemEffect.reaching, 1.0);
    private final IStatGetter efficiencyGetter = new StatGetterEffectEfficiency(ItemEffect.reaching, 1.0);
    private final IStatGetter reachGetter = new StatGetterAttribute((Attribute)ForgeMod.BLOCK_REACH.get(), false);
    private final IStatGetter rangeGetter = new StatGetterAttribute((Attribute)ForgeMod.ENTITY_REACH.get(), false);

    @Override
    public String getTooltipBase(Player player, ItemStack itemStack) {
        return I18n.m_118938_((String)"tetra.stats.reaching.tooltip", (Object[])new Object[]{String.format("%.0f", Float.valueOf(100.0f * ReachingEffect.getOffset((int)this.levelGetter.getValue(player, itemStack), 9.0))), 3});
    }

    @Override
    public boolean hasExtendedTooltip(Player player, ItemStack itemStack) {
        return true;
    }

    @Override
    public String getTooltipExtension(Player player, ItemStack itemStack) {
        int level = (int)this.levelGetter.getValue(player, itemStack);
        double rangedMultiplier = this.efficiencyGetter.getValue(player, itemStack);
        double reach = this.reachGetter.getValue(player, itemStack);
        double range = this.rangeGetter.getValue(player, itemStack);
        return I18n.m_118938_((String)"tetra.stats.reaching.tooltip_extended", (Object[])new Object[]{String.format("%.2f", rangedMultiplier), String.format("%.0f", Float.valueOf(100.0f * ReachingEffect.getOffset(level, reach * reach))), String.format("%.1f", reach), String.format("%.0f", Float.valueOf(100.0f * ReachingEffect.getOffset(level, range * range))), String.format("%.1f", range)});
    }
}

