/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.effect.modifier;

import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import se.mickelus.tetra.data.ModifierEffectStore;
import se.mickelus.tetra.effect.EffectHelper;
import se.mickelus.tetra.effect.data.ItemEffectContext;
import se.mickelus.tetra.effect.data.ItemEffectData;
import se.mickelus.tetra.effect.modifier.ModifierEffect;
import se.mickelus.tetra.items.modular.IModularItem;
import se.mickelus.tetra.items.modular.ItemModularHandheld;

public class ModifierEffectHandler {
    private static final Logger logger = LogManager.getLogger();

    public static void onBreakSpeed(PlayerEvent.BreakSpeed event) {
        if (event.getPosition().isPresent()) {
            Optional.of(event.getEntity().m_21205_()).filter(itemStack -> !itemStack.m_41619_()).filter(itemStack -> itemStack.m_41720_() instanceof ItemModularHandheld).ifPresent(itemStack -> {
                List presentEffects = ((IModularItem)itemStack.m_41720_()).getEffects((ItemStack)itemStack).stream().flatMap(effect -> ModifierEffectStore.breakSpeedModifiers.get(effect).stream()).toList();
                ItemEffectContext context = null;
                if (!presentEffects.isEmpty()) {
                    context = new ItemEffectContext((LivingEntity)event.getEntity(), (ItemStack)itemStack, event.getEntity().m_9236_()).withNumbers((Map<String, Float>)ImmutableMap.of((Object)"unmodifiedSpeed", (Object)Float.valueOf(event.getOriginalSpeed()), (Object)"speed", (Object)Float.valueOf(event.getNewSpeed()))).withEntities((Map<String, Entity>)ImmutableMap.of((Object)"miner", (Object)event.getEntity())).withVectors((Map<String, Vec3>)ImmutableMap.of((Object)"target", (Object)event.getPosition().map(Vec3::m_82528_).orElse(event.getEntity().m_20182_())));
                }
                for (ModifierEffect effect2 : presentEffects) {
                    try {
                        ItemEffectContext localContext = context.withMergedNumbers((Map<String, Float>)ImmutableMap.of((Object)"level", (Object)Float.valueOf(EffectHelper.getEffectLevel(itemStack, effect2.effect)), (Object)"efficiency", (Object)Float.valueOf(EffectHelper.getEffectEfficiency(itemStack, effect2.effect))));
                        if (effect2.data != null) {
                            localContext = localContext.withMergedNumbers(ItemEffectData.calculateNumbers(effect2.data, localContext));
                            localContext = localContext.withMergedVectors(ItemEffectData.calculateVectors(effect2.data, localContext));
                            localContext = localContext.withMergedEntities(ItemEffectData.calculateEntities(effect2.data, localContext));
                        }
                        if (effect2.condition != null && !effect2.condition.test(localContext)) continue;
                        context = context.withMergedNumbers((Map<String, Float>)ImmutableMap.of((Object)"speed", (Object)Float.valueOf(effect2.result.getValue(localContext))));
                    }
                    catch (Exception e) {
                        logger.error("An error occured when calculating break speed for modifier effect '{}': {}", (Object)effect2.key, (Object)e.getMessage());
                        logger.debug(e.getMessage(), (Throwable)e);
                    }
                }
                if (context != null) {
                    event.setNewSpeed(context.getNumbers().get("speed").floatValue());
                }
            });
        }
    }

    public static void onLivingDamage(ItemStack itemStack, LivingDamageEvent event) {
        List presentEffects = ((IModularItem)itemStack.m_41720_()).getEffects(itemStack).stream().flatMap(effect -> ModifierEffectStore.hitDamageModifiers.get(effect).stream()).toList();
        ItemEffectContext context = null;
        if (!presentEffects.isEmpty()) {
            context = new ItemEffectContext(event.getEntity(), itemStack, event.getEntity().m_9236_()).withNumbers((Map<String, Float>)ImmutableMap.of((Object)"damage", (Object)Float.valueOf(event.getAmount()))).withEntities((Map<String, Entity>)ImmutableMap.of((Object)"attacker", (Object)event.getSource().m_7639_(), (Object)"target", (Object)event.getEntity()));
        }
        for (ModifierEffect effect2 : presentEffects) {
            try {
                ItemEffectContext localContext = context.withMergedNumbers((Map<String, Float>)ImmutableMap.of((Object)"level", (Object)Float.valueOf(EffectHelper.getEffectLevel(itemStack, effect2.effect)), (Object)"efficiency", (Object)Float.valueOf(EffectHelper.getEffectEfficiency(itemStack, effect2.effect))));
                if (effect2.data != null) {
                    localContext = localContext.withMergedNumbers(ItemEffectData.calculateNumbers(effect2.data, localContext));
                    localContext = localContext.withMergedVectors(ItemEffectData.calculateVectors(effect2.data, localContext));
                    localContext = localContext.withMergedEntities(ItemEffectData.calculateEntities(effect2.data, localContext));
                }
                if (effect2.condition != null && !effect2.condition.test(localContext)) continue;
                context = context.withMergedNumbers((Map<String, Float>)ImmutableMap.of((Object)"damage", (Object)Float.valueOf(effect2.result.getValue(localContext))));
            }
            catch (Exception e) {
                logger.error("An error occured when calculating living damage for modifier effect '{}': {}", (Object)effect2.key, (Object)e.getMessage());
                logger.debug(e.getMessage(), (Throwable)e);
            }
        }
        if (context != null) {
            event.setAmount(context.getNumbers().get("damage").floatValue());
        }
    }
}

