/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.effect.data.provider.entity;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.world.entity.Entity;
import se.mickelus.mutil.util.JsonOptional;
import se.mickelus.tetra.data.DataManager;
import se.mickelus.tetra.effect.data.ItemEffectContext;
import se.mickelus.tetra.effect.data.provider.entity.ContextEntityProvider;

public interface EntityProvider {
    public Entity getEntity(ItemEffectContext var1);

    public static void register(String key, Function<JsonObject, EntityProvider> deserializer) {
        Deserializer.deserializers.put(key, deserializer);
    }

    public static void register(String identifier, Class<? extends EntityProvider> clazz) {
        Deserializer.deserializers.put(identifier, json -> (EntityProvider)DataManager.gson.fromJson((JsonElement)json, clazz));
    }

    public static class Deserializer
    implements JsonDeserializer<EntityProvider> {
        static final Map<String, Function<JsonObject, EntityProvider>> deserializers = new HashMap<String, Function<JsonObject, EntityProvider>>();

        public EntityProvider deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
            if (jsonElement.isJsonPrimitive()) {
                return new ContextEntityProvider(jsonElement.getAsString());
            }
            JsonObject jsonObject = jsonElement.getAsJsonObject();
            String key = JsonOptional.field((JsonObject)jsonObject, (String)"type").map(JsonElement::getAsString).orElse(null);
            if (deserializers.containsKey(key)) {
                return deserializers.get(key).apply(jsonObject);
            }
            throw new JsonParseException("No deserializer found for EntityProvider type: " + key);
        }
    }
}

