/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.effect.data.outcome;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import se.mickelus.tetra.effect.data.ItemEffectContext;
import se.mickelus.tetra.effect.data.condition.FixedItemEffectCondition;
import se.mickelus.tetra.effect.data.condition.ItemEffectCondition;
import se.mickelus.tetra.effect.data.outcome.ItemEffectOutcome;
import se.mickelus.tetra.effect.data.provider.vector.VectorProvider;

public class SpawnEntityItemEffectOutcome
extends ItemEffectOutcome {
    CompoundTag entity;
    VectorProvider position;
    ItemEffectCondition playSound = new FixedItemEffectCondition(true);
    String outcomeEntityKey = "spawnedEntity";
    ItemEffectOutcome outcome;

    @Override
    public boolean perform(ItemEffectContext context) {
        Level level;
        Vec3 resolvedPosition = this.position.getVector(context);
        Entity entityInstance = EntityType.m_20645_((CompoundTag)this.entity, (Level)context.getLevel(), e -> {
            e.m_6027_(resolvedPosition.m_7096_(), resolvedPosition.m_7098_(), resolvedPosition.m_7094_());
            return e;
        });
        if (entityInstance != null && (level = context.getLevel()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.m_47205_(entityInstance);
            ItemEffectContext updatedContext = context.withMergedEntities((Map<String, Entity>)ImmutableMap.of((Object)this.outcomeEntityKey, (Object)entityInstance));
            if (this.playSound.test(updatedContext) && entityInstance instanceof Mob) {
                Mob mob = (Mob)entityInstance;
                mob.m_8032_();
            }
            if (this.outcome != null) {
                this.outcome.perform(updatedContext);
            }
            return true;
        }
        return false;
    }
}

