/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.effect;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import se.mickelus.tetra.effect.EffectHelper;
import se.mickelus.tetra.effect.ItemEffect;
import se.mickelus.tetra.effect.potion.SatiatedPotionEffect;

@ParametersAreNonnullByDefault
public class SatiatingEffect {
    private static final Cache<UUID, Float> remainderCache = CacheBuilder.newBuilder().maximumSize(100L).expireAfterWrite(1L, TimeUnit.MINUTES).build();
    public static final int satiatedInitialDuration = 400;
    public static final int satiatedStackDuration = 100;

    public static int perform(ItemStack itemStack, Player player, int xp) {
        int maxXpDrain = EffectHelper.getEffectLevel(itemStack, ItemEffect.satiating);
        if (maxXpDrain > 0 && xp > 0) {
            int xpDrain = Math.min(xp, maxXpDrain);
            MobEffectInstance currentSatiatedInstance = player.m_21124_((MobEffect)SatiatedPotionEffect.instance);
            int currentAmplifier = Optional.ofNullable(currentSatiatedInstance).map(MobEffectInstance::m_19564_).orElse(-1);
            int updatedAmplifier = Math.min(127, currentAmplifier + xpDrain);
            int duration = Optional.ofNullable(currentSatiatedInstance).map(MobEffectInstance::m_19557_).map(currentDuration -> Math.max(currentDuration + 100, 400)).orElse(400);
            player.m_7292_(new MobEffectInstance((MobEffect)SatiatedPotionEffect.instance, duration, currentAmplifier + updatedAmplifier, false, false, true));
            return xpDrain;
        }
        return 0;
    }

    private static float getRemainder(UUID playerId) {
        try {
            return ((Float)remainderCache.get((Object)playerId, () -> Float.valueOf(0.0f))).floatValue();
        }
        catch (ExecutionException e) {
            e.printStackTrace();
            return 0.0f;
        }
    }

    public static void setRemainder(UUID playerId, float remainder) {
        remainderCache.put((Object)playerId, (Object)Float.valueOf(remainder));
    }

    public static boolean handleFoodExhaustion(Player player, float exhaustion) {
        MobEffectInstance satiatedEffect;
        if (!player.m_9236_().f_46443_ && !player.m_150110_().f_35934_ && (satiatedEffect = player.m_21124_((MobEffect)SatiatedPotionEffect.instance)) != null && exhaustion > 0.0f) {
            int amplifier = satiatedEffect.m_19564_() + 1;
            float reduction = Math.min(exhaustion, (float)amplifier);
            float adjustedExhaustion = exhaustion - reduction;
            if (adjustedExhaustion > 0.0f) {
                player.m_36324_().m_38703_(adjustedExhaustion);
            }
            float remainder = SatiatingEffect.getRemainder(player.m_20148_());
            int amplifierDrain = (int)(reduction + remainder);
            float newRemainder = reduction + remainder - (float)amplifierDrain;
            SatiatingEffect.setRemainder(player.m_20148_(), newRemainder);
            if (amplifierDrain > 0) {
                int newAmplifier = amplifier - amplifierDrain;
                if (newAmplifier > 0) {
                    player.m_21195_((MobEffect)SatiatedPotionEffect.instance);
                    player.m_7292_(new MobEffectInstance((MobEffect)SatiatedPotionEffect.instance, satiatedEffect.m_19557_(), newAmplifier - 1, false, false, true));
                } else {
                    player.m_21195_((MobEffect)SatiatedPotionEffect.instance);
                }
            }
            return true;
        }
        return false;
    }
}

