/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.effect;

import java.util.Optional;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;
import se.mickelus.mutil.util.CastOptional;
import se.mickelus.tetra.effect.AbilityUseResult;
import se.mickelus.tetra.effect.ChargedAbilityEffect;
import se.mickelus.tetra.effect.ComboPoints;
import se.mickelus.tetra.effect.EchoHelper;
import se.mickelus.tetra.effect.ItemEffect;
import se.mickelus.tetra.effect.potion.SeveredPotionEffect;
import se.mickelus.tetra.effect.potion.SmallStrengthPotionEffect;
import se.mickelus.tetra.effect.potion.StunPotionEffect;
import se.mickelus.tetra.items.modular.ItemModularHandheld;

@ParametersAreNonnullByDefault
public class ExecuteEffect
extends ChargedAbilityEffect {
    public static final ExecuteEffect instance = new ExecuteEffect();

    ExecuteEffect() {
        super(20, 0.5, 40, 8.0, ItemEffect.execute, ChargedAbilityEffect.TargetRequirement.entity, UseAnim.SPEAR, "raised");
    }

    @Override
    public void perform(Player attacker, InteractionHand hand, ItemModularHandheld item, ItemStack itemStack, LivingEntity target, Vec3 hitVec, int chargedTicks) {
        if (!target.m_9236_().f_46443_) {
            AbilityUseResult result = this.isDefensive(item, itemStack, hand) ? this.defensiveExecute(attacker, item, itemStack, target) : this.regularExecute(attacker, item, itemStack, target, chargedTicks);
            this.playEffects(result != AbilityUseResult.fail, target, hitVec);
            item.tickProgression((LivingEntity)attacker, itemStack, result == AbilityUseResult.fail ? 1 : 2);
        }
        attacker.m_36399_(1.0f);
        attacker.m_21011_(hand, false);
        attacker.m_36335_().m_41524_((Item)item, this.getCooldown(item, itemStack));
        if (ComboPoints.canSpend(item, itemStack)) {
            ComboPoints.reset((Entity)attacker);
        }
        item.applyDamage(2, itemStack, (LivingEntity)attacker);
    }

    private AbilityUseResult regularExecute(Player attacker, ItemModularHandheld item, ItemStack itemStack, LivingEntity target, int chargedTicks) {
        AbilityUseResult result;
        int echoLevel;
        int overextendLevel;
        double revengeMultiplier;
        long harmfulCount = target.m_21220_().stream().filter(effect -> effect.m_19544_().m_19483_() == MobEffectCategory.HARMFUL).mapToInt(MobEffectInstance::m_19564_).map(amp -> amp + 1).sum();
        if (target.m_6060_()) {
            ++harmfulCount;
        }
        if (target.m_203117_()) {
            ++harmfulCount;
        }
        float missingHealth = Mth.m_14036_((float)(1.0f - target.m_21223_() / target.m_21233_()), (float)0.0f, (float)1.0f);
        double efficiency = item.getEffectEfficiency(itemStack, ItemEffect.execute);
        double damageMultiplier = (double)missingHealth + (double)harmfulCount * efficiency / 100.0;
        double comboLevel = item.getEffectLevel(itemStack, ItemEffect.abilityCombo);
        if (comboLevel > 0.0) {
            damageMultiplier *= 1.0 + comboLevel * (double)ComboPoints.get((Entity)attacker) / 100.0;
        }
        damageMultiplier += 1.0;
        if (this.canOvercharge(item, itemStack)) {
            damageMultiplier *= 1.0 + (double)(this.getOverchargeBonus(item, itemStack, chargedTicks) * item.getEffectLevel(itemStack, ItemEffect.abilityOvercharge)) / 100.0;
        }
        if ((revengeMultiplier = this.getRevengeMultiplier(attacker, item, itemStack)) > 0.0) {
            damageMultiplier *= revengeMultiplier;
        }
        if ((overextendLevel = item.getEffectLevel(itemStack, ItemEffect.abilityOverextend)) > 0) {
            FoodData foodStats = attacker.m_36324_();
            float exhaustion = Math.min(40.0f, (float)foodStats.m_38702_() + foodStats.m_38722_());
            damageMultiplier *= 1.0 + (double)((float)overextendLevel * exhaustion) * 0.25 / 100.0;
            attacker.m_36399_(exhaustion);
        }
        if ((echoLevel = item.getEffectLevel(itemStack, ItemEffect.abilityEcho)) > 0) {
            this.echoExecute(attacker, item, itemStack, target);
        }
        if ((result = item.hitEntity(itemStack, attacker, target, damageMultiplier, 0.2f, 0.2f)) != AbilityUseResult.fail) {
            int exhilarationLevel;
            int momentumLevel = item.getEffectLevel(itemStack, ItemEffect.abilityMomentum);
            if (momentumLevel > 0) {
                int duration = (int)((double)momentumLevel * damageMultiplier * 20.0);
                target.m_7292_(new MobEffectInstance((MobEffect)StunPotionEffect.instance, duration, 0, false, false));
            }
            if ((exhilarationLevel = item.getEffectLevel(itemStack, ItemEffect.abilityExhilaration)) > 0 && !target.m_6084_()) {
                float maxHealth = target.m_21233_();
                int amplifier = Math.round((1.0f - missingHealth) / (float)exhilarationLevel * 100.0f) - 1;
                int duration = (int)(Math.min(200.0f, item.getEffectEfficiency(itemStack, ItemEffect.abilityExhilaration) * maxHealth) * 20.0f);
                if (amplifier >= 0 && duration > 0) {
                    attacker.m_7292_(new MobEffectInstance((MobEffect)SmallStrengthPotionEffect.instance, duration, amplifier, false, true));
                }
            }
        }
        return result;
    }

    private void echoExecute(Player attacker, ItemModularHandheld item, ItemStack itemStack, LivingEntity target) {
        EchoHelper.echo(attacker, 100, () -> {
            float missingHealth;
            double damageMultiplier;
            long harmfulCount = target.m_21220_().stream().filter(effect -> effect.m_19544_().m_19483_() == MobEffectCategory.HARMFUL).mapToInt(MobEffectInstance::m_19564_).map(amp -> amp + 1).sum();
            if (target.m_6060_()) {
                ++harmfulCount;
            }
            if (target.m_203117_()) {
                ++harmfulCount;
            }
            if ((damageMultiplier = (double)((missingHealth = Mth.m_14036_((float)(1.0f - target.m_21223_() / target.m_21233_()), (float)0.0f, (float)1.0f)) + (float)harmfulCount)) > 0.0) {
                AbilityUseResult result = item.hitEntity(itemStack, attacker, target, damageMultiplier, 0.2f, 0.2f);
                this.playEffects(result != AbilityUseResult.fail, target, target.m_20182_().m_82520_(0.0, (double)(target.m_20206_() / 2.0f), 0.0));
            }
        });
    }

    private AbilityUseResult defensiveExecute(Player attacker, ItemModularHandheld item, ItemStack itemStack, LivingEntity target) {
        AbilityUseResult result;
        boolean targetFullHealth = target.m_21233_() == target.m_21223_();
        double damageMultiplier = (float)item.getEffectLevel(itemStack, ItemEffect.abilityDefensive) / 100.0f;
        if (targetFullHealth) {
            damageMultiplier += (double)(item.getEffectEfficiency(itemStack, ItemEffect.abilityDefensive) / 100.0f);
        }
        if ((result = item.hitEntity(itemStack, attacker, target, damageMultiplier, 0.2f, 0.2f)) != AbilityUseResult.fail) {
            int amp = Optional.ofNullable(target.m_21124_((MobEffect)SeveredPotionEffect.instance)).map(MobEffectInstance::m_19564_).orElse(-1);
            amp += targetFullHealth ? 2 : 1;
            amp = Math.min(amp, 2);
            target.m_7292_(new MobEffectInstance((MobEffect)SeveredPotionEffect.instance, 1200, amp, false, false));
        }
        return result;
    }

    private double getRevengeMultiplier(Player player, ItemModularHandheld item, ItemStack itemStack) {
        int revengeLevel = item.getEffectLevel(itemStack, ItemEffect.abilityRevenge);
        if (revengeLevel > 0 && (player.m_21220_().stream().anyMatch(effect -> effect.m_19544_().m_19483_() == MobEffectCategory.HARMFUL) || player.m_6060_() || player.m_203117_())) {
            return 1.0 + (double)revengeLevel / 100.0;
        }
        return 0.0;
    }

    private void playEffects(boolean isSuccess, LivingEntity target, Vec3 hitVec) {
        if (isSuccess) {
            target.m_20193_().m_5594_(null, target.m_20183_(), SoundEvents.f_12316_, SoundSource.PLAYERS, 1.0f, 0.8f);
            RandomSource rand = target.m_217043_();
            CastOptional.cast((Object)target.m_9236_(), ServerLevel.class).ifPresent(world -> world.m_8767_((ParticleOptions)new DustParticleOptions(new Vector3f(0.6f, 0.0f, 0.0f), 0.8f), hitVec.f_82479_, hitVec.f_82480_, hitVec.f_82481_, 10, rand.m_188583_() * 0.3, rand.m_188583_() * 0.3, rand.m_188583_() * 0.3, (double)0.1f));
        } else {
            target.m_20193_().m_5594_(null, target.m_20183_(), SoundEvents.f_12318_, SoundSource.PLAYERS, 1.0f, 0.8f);
        }
    }
}

