/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.effect;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import se.mickelus.tetra.effect.ItemEffect;
import se.mickelus.tetra.items.modular.IModularItem;

@ParametersAreNonnullByDefault
public class ComboPoints {
    private static final Cache<Integer, Integer> cache = CacheBuilder.newBuilder().maximumSize(100L).expireAfterWrite(30L, TimeUnit.SECONDS).build();

    private static int getIdentifier(Entity entity) {
        return entity.m_9236_().f_46443_ ? -entity.m_19879_() : entity.m_19879_();
    }

    public static void increment(Entity entity) {
        try {
            int identifier = ComboPoints.getIdentifier(entity);
            int points = Math.min(5, (Integer)cache.get((Object)identifier, () -> 0) + 1);
            cache.put((Object)identifier, (Object)points);
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
    }

    public static int get(Entity entity) {
        try {
            return (Integer)cache.get((Object)ComboPoints.getIdentifier(entity), () -> 0);
        }
        catch (ExecutionException e) {
            e.printStackTrace();
            return 0;
        }
    }

    public static int getAndReset(Entity entity) {
        try {
            int points = (Integer)cache.get((Object)ComboPoints.getIdentifier(entity), () -> 0);
            ComboPoints.reset(entity);
            return points;
        }
        catch (ExecutionException e) {
            e.printStackTrace();
            return 0;
        }
    }

    public static void reset(Entity entity) {
        cache.invalidate((Object)ComboPoints.getIdentifier(entity));
    }

    public static boolean canSpend(LivingEntity entity) {
        return Stream.of(entity.m_21205_(), entity.m_21206_()).filter(itemStack -> itemStack.m_41720_() instanceof IModularItem).anyMatch(itemStack -> ComboPoints.canSpend((IModularItem)itemStack.m_41720_(), itemStack));
    }

    public static boolean canSpend(IModularItem item, ItemStack itemStack) {
        return item.getEffectLevel(itemStack, ItemEffect.abilityCombo) > 0;
    }

    public static void onAttackEntity(AttackEntityEvent event) {
        if (event.getTarget().m_6097_() && ComboPoints.canSpend((LivingEntity)event.getEntity()) && (double)event.getEntity().m_36403_(0.0f) > 0.9) {
            ComboPoints.increment((Entity)event.getEntity());
        }
    }
}

