/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.craftingeffect.outcome;

import java.util.Arrays;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.MultifaceBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.ToolAction;
import se.mickelus.tetra.ServerScheduler;
import se.mickelus.tetra.blocks.PropertyMatcher;
import se.mickelus.tetra.craftingeffect.outcome.CraftingEffectOutcome;
import se.mickelus.tetra.module.schematic.UpgradeSchematic;
import se.mickelus.tetra.util.StreamHelper;

public class SetBlocksOutcome
implements CraftingEffectOutcome {
    BlockState blockState;
    PropertyMatcher requirement = PropertyMatcher.any;
    boolean requireReplaceable = true;
    boolean solidBelow = false;
    boolean solidAdjacent = false;
    boolean skipCenter = false;
    int radius = 5;
    int count = 1;
    float chance = 1.0f;
    SoundOptions sound;
    ParticleOptions particle;
    int delay = 0;
    int randomDelay = 0;
    int fxInterval = 10;
    ParticleOptions intervalParticle;
    SoundOptions intervalSound;
    float intervalSoundVolumeChange = 0.0f;
    float intervalSoundPitchChange = 0.0f;

    @Override
    public boolean apply(ResourceLocation[] unlockedEffects, ItemStack upgradedStack, String slot, boolean isReplacing, Player player, ItemStack[] preMaterials, Map<ToolAction, Integer> tools, Level world, UpgradeSchematic schematic, BlockPos pos, BlockState blockState, boolean consumeResources, ItemStack[] postMaterials) {
        if (consumeResources && !world.m_5776_() && world.m_213780_().m_188501_() < this.chance) {
            this.setBlocksAround((ServerLevel)world, pos);
        }
        return true;
    }

    private void setBlocksAround(ServerLevel level, BlockPos origin) {
        BlockPos.m_121985_((BlockPos)origin, (int)this.radius, (int)this.radius, (int)this.radius).map(BlockPos::new).filter(blockPos -> !origin.equals(blockPos) || !this.skipCenter).collect(StreamHelper.toShuffledList()).stream().filter(blockPos -> this.blockState.m_60710_((LevelReader)level, blockPos)).filter(blockPos -> this.testRequirements((Level)level, level.m_8055_(blockPos), (BlockPos)blockPos)).limit(this.count).forEach(blockPos -> this.setBlock(level, (BlockPos)blockPos));
    }

    private void setBlock(ServerLevel level, BlockPos pos) {
        if (this.delay > 0 || this.randomDelay > 0) {
            int i;
            int actualDelay = this.delay + (this.randomDelay > 0 ? level.m_213780_().m_188503_(this.randomDelay) : 0);
            ServerScheduler.schedule(actualDelay, () -> {
                if (this.blockState.m_60710_((LevelReader)level, pos) && this.testRequirements((Level)level, level.m_8055_(pos), pos)) {
                    level.m_7731_(pos, this.blockState, 3);
                    if (this.particle != null) {
                        level.m_8767_(this.particle, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, 8, 0.5, 0.5, 0.5, 0.1);
                    }
                    if (this.sound != null) {
                        level.m_5594_(null, pos, this.sound.type, SoundSource.BLOCKS, this.sound.volume, this.sound.pitch);
                    }
                }
            });
            if (this.intervalParticle != null && this.fxInterval > 0) {
                i = 1;
                while (i * this.fxInterval < actualDelay) {
                    ServerScheduler.schedule(i * this.fxInterval, () -> level.m_8767_(this.intervalParticle, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, 8, 0.5, 0.5, 0.5, 0.1));
                    ++i;
                }
            }
            if (this.intervalSound != null && this.fxInterval > 0) {
                i = 1;
                while (i * this.fxInterval < actualDelay) {
                    float volume = this.intervalSound.volume + (float)i * this.intervalSoundVolumeChange;
                    float pitch = this.intervalSound.pitch + (float)i * this.intervalSoundPitchChange;
                    ServerScheduler.schedule(i * this.fxInterval, () -> level.m_5594_(null, pos, this.intervalSound.type, SoundSource.PLAYERS, volume, pitch));
                    ++i;
                }
            }
        } else {
            level.m_7731_(pos, this.blockState, 3);
            if (this.particle != null) {
                level.m_8767_(this.particle, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, 8, 0.5, 0.5, 0.5, 0.1);
            }
            if (this.sound != null) {
                level.m_5594_(null, pos, this.sound.type, SoundSource.BLOCKS, this.sound.volume, this.sound.pitch);
            }
        }
    }

    private boolean testRequirements(Level level, BlockState blockState, BlockPos blockPos) {
        return !(!this.requirement.test(blockState) || this.requireReplaceable && !blockState.m_247087_() || this.solidBelow && !MultifaceBlock.m_153829_((BlockGetter)level, (Direction)Direction.DOWN, (BlockPos)blockPos.m_7495_(), (BlockState)level.m_8055_(blockPos.m_7495_())) || this.solidAdjacent && !this.isSolidAdjacent(level, blockPos));
    }

    private boolean isSolidAdjacent(Level level, BlockPos blockPos) {
        return Arrays.stream(Direction.values()).anyMatch(dir -> MultifaceBlock.m_153829_((BlockGetter)level, (Direction)dir, (BlockPos)blockPos.m_121945_(dir), (BlockState)level.m_8055_(blockPos.m_121945_(dir))));
    }

    static class SoundOptions {
        SoundEvent type;
        float volume = 1.0f;
        float pitch = 1.0f;

        SoundOptions() {
        }
    }
}

