/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.client.particle;

import net.minecraft.core.IdMap;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import se.mickelus.mutil.network.AbstractPacket;

public class SpawnParticlesPacket
extends AbstractPacket {
    private double x;
    private double y;
    private double z;
    private float dx;
    private float dy;
    private float dz;
    private boolean randomizeVelocity;
    private int count;
    private ParticleOptions particle;

    public SpawnParticlesPacket(double x, double y, double z, float dx, float dy, float dz, int count, ParticleOptions particle) {
        this(x, y, z, dx, dy, dz, true, count, particle);
    }

    public SpawnParticlesPacket(double x, double y, double z, float dx, float dy, float dz, boolean randomizeVelocity, int count, ParticleOptions particle) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.dx = dx;
        this.dy = dy;
        this.dz = dz;
        this.randomizeVelocity = randomizeVelocity;
        this.count = count;
        this.particle = particle;
    }

    public SpawnParticlesPacket() {
    }

    private <T extends ParticleOptions> T readParticle(FriendlyByteBuf buffer, ParticleType<T> particleType) {
        return (T)particleType.m_123743_().m_6507_(particleType, buffer);
    }

    public void toBytes(FriendlyByteBuf buffer) {
        buffer.m_236818_((IdMap)BuiltInRegistries.f_257034_, (Object)this.particle.m_6012_());
        buffer.writeDouble(this.x);
        buffer.writeDouble(this.y);
        buffer.writeDouble(this.z);
        buffer.writeFloat(this.dx);
        buffer.writeFloat(this.dy);
        buffer.writeFloat(this.dz);
        buffer.writeBoolean(this.randomizeVelocity);
        buffer.writeInt(this.count);
        this.particle.m_7711_(buffer);
    }

    public void fromBytes(FriendlyByteBuf buffer) {
        ParticleType particleType = (ParticleType)buffer.m_236816_((IdMap)BuiltInRegistries.f_257034_);
        this.x = buffer.readDouble();
        this.y = buffer.readDouble();
        this.z = buffer.readDouble();
        this.dx = buffer.readFloat();
        this.dy = buffer.readFloat();
        this.dz = buffer.readFloat();
        this.randomizeVelocity = buffer.readBoolean();
        this.count = buffer.readInt();
        this.particle = this.readParticle(buffer, particleType);
    }

    public void handle(Player player) {
        if (this.randomizeVelocity) {
            for (int i = 0; i < this.count; ++i) {
                player.m_9236_().m_7106_(this.particle, this.x, this.y, this.z, Math.random() * (double)this.dx - 0.5 * (double)this.dx, Math.random() * (double)this.dy - 0.5 * (double)this.dy, Math.random() * (double)this.dz - 0.5 * (double)this.dz);
            }
        } else {
            for (int i = 0; i < this.count; ++i) {
                player.m_9236_().m_7106_(this.particle, this.x, this.y, this.z, (double)this.dx, (double)this.dy, (double)this.dz);
            }
        }
    }
}

