/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.client;

import com.google.gson.Gson;
import com.google.gson.JsonParseException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.util.GsonHelper;
import net.minecraftforge.common.ToolAction;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import se.mickelus.tetra.data.DataManager;
import se.mickelus.tetra.module.data.GlyphData;

public class ToolActionIconStore
implements ResourceManagerReloadListener {
    protected static final String jsonExtension = ".json";
    private static final String directory = "tool_actions";
    private static final Logger logger = LogManager.getLogger();
    public static ToolActionIconStore instance;
    private Map<ToolAction, GlyphData> icons = Collections.emptyMap();

    public ToolActionIconStore() {
        instance = this;
    }

    public void m_6213_(ResourceManager resourceManager) {
        this.icons = this.prepareIcons();
        logger.info("Loaded {} tool action icons", (Object)this.icons.size());
    }

    public GlyphData getIcon(ToolAction action) {
        return this.icons.get(action);
    }

    private Map<ToolAction, GlyphData> prepareIcons() {
        return Minecraft.m_91087_().m_91098_().m_214159_(directory, rl -> rl.m_135815_().endsWith(jsonExtension)).entrySet().stream().filter(entry -> "tetra".equals(((ResourceLocation)entry.getKey()).m_135827_())).collect(HashMap::new, (map, entry) -> map.put(this.getAction((ResourceLocation)entry.getKey()), this.getGlyph((ResourceLocation)entry.getKey(), (Resource)entry.getValue())), HashMap::putAll);
    }

    private ToolAction getAction(ResourceLocation resourceLocation) {
        String path = resourceLocation.m_135815_();
        return ToolAction.get((String)path.substring(directory.length() + 1, path.length() - jsonExtension.length()));
    }

    private GlyphData getGlyph(ResourceLocation resourceLocation, Resource resource) {
        GlyphData glyphData;
        block8: {
            BufferedReader reader = resource.m_215508_();
            try {
                glyphData = Optional.of((GlyphData)GsonHelper.m_13776_((Gson)DataManager.gson, (Reader)reader, GlyphData.class)).orElse(null);
                if (reader == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (JsonParseException | IOException e) {
                    logger.warn("Failed to parse tool action icon from '{}': {}", (Object)resourceLocation, (Object)e);
                    return null;
                }
            }
            reader.close();
        }
        return glyphData;
    }
}

