/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.blocks.workbench;

import java.io.IOException;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import se.mickelus.mutil.network.AbstractPacket;
import se.mickelus.tetra.blocks.workbench.WorkbenchTile;
import se.mickelus.tetra.module.SchematicRegistry;
import se.mickelus.tetra.module.schematic.UpgradeSchematic;

@ParametersAreNonnullByDefault
public class WorkbenchPacketUpdate
extends AbstractPacket {
    private BlockPos pos;
    private UpgradeSchematic schematic;
    private String selectedSlot;

    public WorkbenchPacketUpdate() {
    }

    public WorkbenchPacketUpdate(BlockPos pos, UpgradeSchematic schematic, String selectedSlot) {
        this.pos = pos;
        this.schematic = schematic;
        this.selectedSlot = selectedSlot;
    }

    public void toBytes(FriendlyByteBuf buffer) {
        buffer.writeInt(this.pos.m_123341_());
        buffer.writeInt(this.pos.m_123342_());
        buffer.writeInt(this.pos.m_123343_());
        try {
            if (this.schematic != null) {
                WorkbenchPacketUpdate.writeString((String)this.schematic.getKey(), (FriendlyByteBuf)buffer);
            } else {
                WorkbenchPacketUpdate.writeString((String)"", (FriendlyByteBuf)buffer);
            }
            if (this.selectedSlot != null) {
                WorkbenchPacketUpdate.writeString((String)this.selectedSlot, (FriendlyByteBuf)buffer);
            } else {
                WorkbenchPacketUpdate.writeString((String)"", (FriendlyByteBuf)buffer);
            }
        }
        catch (IOException exception) {
            System.err.println("An error occurred when writing schematic name to packet buffer");
        }
    }

    public void fromBytes(FriendlyByteBuf buffer) {
        int x = buffer.readInt();
        int y = buffer.readInt();
        int z = buffer.readInt();
        this.pos = new BlockPos(x, y, z);
        try {
            String schematicKey = WorkbenchPacketUpdate.readString((FriendlyByteBuf)buffer);
            this.schematic = SchematicRegistry.getSchematic(schematicKey);
            this.selectedSlot = WorkbenchPacketUpdate.readString((FriendlyByteBuf)buffer);
            if ("".equals(this.selectedSlot)) {
                this.selectedSlot = null;
            }
        }
        catch (IOException exception) {
            System.err.println("An error occurred when reading schematic name from packet buffer");
        }
    }

    public void handle(Player player) {
        WorkbenchTile workbench = (WorkbenchTile)player.m_9236_().m_7702_(this.pos);
        if (workbench != null) {
            workbench.update(this.schematic, this.selectedSlot, player);
        }
    }
}

