/*
 * Decompiled with CFR 0.152.
 */
package me.codexadrian.tempad.common.network.messages.c2s;

import com.teamresourceful.resourcefullib.common.networking.base.Packet;
import com.teamresourceful.resourcefullib.common.networking.base.PacketContext;
import com.teamresourceful.resourcefullib.common.networking.base.PacketHandler;
import java.util.UUID;
import me.codexadrian.tempad.common.data.LocationData;
import me.codexadrian.tempad.common.data.TempadLocationHandler;
import me.codexadrian.tempad.common.items.TempadItem;
import me.codexadrian.tempad.common.utils.TeleportUtils;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public record SummonTimedoorPacket(UUID location, int color) implements Packet<SummonTimedoorPacket>
{
    public static Handler HANDLER = new Handler();
    public static final ResourceLocation ID = new ResourceLocation("tempad", "timedoor");

    public ResourceLocation getID() {
        return ID;
    }

    public PacketHandler<SummonTimedoorPacket> getHandler() {
        return HANDLER;
    }

    private static class Handler
    implements PacketHandler<SummonTimedoorPacket> {
        private Handler() {
        }

        public void encode(SummonTimedoorPacket message, FriendlyByteBuf buffer) {
            buffer.m_130077_(message.location);
            buffer.m_130130_(message.color);
        }

        public SummonTimedoorPacket decode(FriendlyByteBuf buffer) {
            return new SummonTimedoorPacket(buffer.m_130259_(), buffer.m_130242_());
        }

        public PacketContext handle(SummonTimedoorPacket message) {
            return (player, level) -> {
                TempadItem tempadItem;
                Item patt2023$temp;
                ItemStack itemInHand = TeleportUtils.findTempad(player);
                LocationData locationData = TempadLocationHandler.getLocation(level, player.m_20148_(), message.location);
                if (locationData != null && (patt2023$temp = itemInHand.m_41720_()) instanceof TempadItem && (tempadItem = (TempadItem)patt2023$temp).getOption().canTimedoorOpen(player, itemInHand) && TeleportUtils.mayTeleport(locationData.getLevelKey(), player)) {
                    if (!player.m_150110_().f_35937_) {
                        tempadItem.getOption().onTimedoorOpen(player);
                    }
                    TempadItem.summonTimeDoor(locationData, player, message.color);
                }
            };
        }
    }
}

