/*
 * Decompiled with CFR 0.152.
 */
package net.scsupercraft.teamstages.util;

import dev.ftb.mods.ftbteams.api.FTBTeamsAPI;
import dev.ftb.mods.ftbteams.api.Team;
import dev.ftb.mods.ftbteams.api.TeamManager;
import dev.ftb.mods.ftbteams.api.client.ClientTeamManager;
import dev.ftb.mods.ftbteams.data.PlayerTeam;
import java.util.Collection;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.server.level.ServerPlayer;

public class FtbUtil {
    public static FTBTeamsAPI.API getAPI() {
        return FTBTeamsAPI.api();
    }

    @Nullable
    public static TeamManager getTeamManager() {
        if (!FtbUtil.getAPI().isManagerLoaded()) {
            return null;
        }
        return FtbUtil.getAPI().getManager();
    }

    @Nullable
    public static ClientTeamManager getClientTeamManager() {
        if (!FtbUtil.getAPI().isClientManagerLoaded()) {
            return null;
        }
        return FtbUtil.getAPI().getClientManager();
    }

    @Nullable
    public static Team getTeam(UUID id, boolean isPlayerId) {
        TeamManager manager = FtbUtil.getTeamManager();
        if (manager == null) {
            return null;
        }
        if (!isPlayerId) {
            Optional optionalTeam = manager.getTeamByID(id);
            return optionalTeam.orElse(null);
        }
        Collection teams = manager.getTeams();
        for (Team team : teams) {
            if (!team.isPartyTeam() || !team.getMembers().contains(id)) continue;
            return team;
        }
        return FtbUtil.getPlayerTeam(id);
    }

    @Nullable
    public static Team getTeam(ServerPlayer player) {
        return FtbUtil.getTeam(player.m_20148_(), true);
    }

    @Nullable
    public static PlayerTeam getPlayerTeam(UUID playerId) {
        TeamManager manager = FtbUtil.getTeamManager();
        if (manager == null) {
            return null;
        }
        Optional optionalTeam = manager.getPlayerTeamForPlayerID(playerId);
        return optionalTeam.orElse(null);
    }

    @Nullable
    public static PlayerTeam getPlayerTeam(ServerPlayer player) {
        return FtbUtil.getPlayerTeam(player.m_20148_());
    }
}

