/*
 * Decompiled with CFR 0.152.
 */
package net.scsupercraft.teamstages.packet;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;
import net.scsupercraft.teamstages.packet.handler.MessageTeamStagesHandler;

public class MessageTeamStages {
    private final UUID teamId;
    private final List<String> stages;

    public MessageTeamStages(UUID teamId, Collection<String> stages) {
        this.teamId = teamId;
        this.stages = new ArrayList<String>(stages);
    }

    public List<String> getStages() {
        return this.stages;
    }

    public UUID getTeamId() {
        return this.teamId;
    }

    public static void encode(MessageTeamStages msg, FriendlyByteBuf friendlyByteBuf) {
        CompoundTag tag = new CompoundTag();
        ListTag listTag = new ListTag();
        for (String stage : msg.stages) {
            listTag.add((Object)StringTag.m_129297_((String)stage));
        }
        tag.m_128365_("Stages", (Tag)listTag);
        tag.m_128362_("TeamId", msg.teamId);
        friendlyByteBuf.m_130079_(tag);
    }

    public static MessageTeamStages decode(FriendlyByteBuf friendlyByteBuf) {
        CompoundTag nbt = friendlyByteBuf.m_130261_();
        ListTag stages = nbt.m_128437_("Stages", 8);
        List<String> stagesCollection = stages.stream().map(Tag::m_7916_).toList();
        return new MessageTeamStages(nbt.m_128342_("TeamId"), stagesCollection);
    }

    public static void handle(MessageTeamStages msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> MessageTeamStagesHandler.handle(msg, ctx));
        ctx.get().setPacketHandled(true);
    }
}

