/*
 * Decompiled with CFR 0.152.
 */
package net.scsupercraft.teamstages.mixin;

import dev.ftb.mods.ftbteams.api.Team;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.UUID;
import net.darkhax.gamestages.GameStages;
import net.darkhax.gamestages.data.GameStageSaveHandler;
import net.darkhax.gamestages.data.IStageData;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtIo;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.scsupercraft.teamstages.data.PlayerStageData;
import net.scsupercraft.teamstages.util.FtbUtil;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.gen.Accessor;

@Mixin(value={GameStageSaveHandler.class})
public class GameStageSaveHandlerMixin {
    @Shadow(remap=false)
    @Final
    private static Map<UUID, IStageData> GLOBAL_STAGE_DATA;

    @Accessor(value="GLOBAL_STAGE_DATA", remap=false)
    public static Map<UUID, IStageData> getGlobalStageData() {
        return GLOBAL_STAGE_DATA;
    }

    @Overwrite(remap=false)
    @SubscribeEvent
    public static void onPlayerLoad(PlayerEvent.LoadFromFile event) {
        UUID playerUUID = UUID.fromString(event.getPlayerUUID());
        UUID teamUUID = FtbUtil.getTeamManager() != null && FtbUtil.getTeamManager().getTeamForPlayerID(playerUUID).isPresent() ? ((Team)FtbUtil.getTeamManager().getTeamForPlayerID(playerUUID).orElseThrow()).getTeamId() : null;
        File playerFile = GameStageSaveHandlerMixin.getPlayerFile(event.getPlayerDirectory(), event.getPlayerUUID());
        PlayerStageData playerData = new PlayerStageData(playerUUID, teamUUID);
        if (playerFile.exists()) {
            try {
                CompoundTag tag = NbtIo.m_128937_((File)playerFile);
                tag.m_128362_("StagesPlayerId", playerUUID);
                if (teamUUID != null) {
                    tag.m_128362_("StagesTeamId", teamUUID);
                }
                playerData.readFromNBT(tag);
                GameStages.LOG.debug("Loaded {} stages for {}.", (Object)playerData.getStages().size(), (Object)event.getEntity().m_7755_());
            }
            catch (IOException var4) {
                GameStages.LOG.error("Could not read player data for {}.", (Object)event.getEntity().m_7755_());
                GameStages.LOG.catching((Throwable)var4);
            }
        }
        GameStageSaveHandlerMixin.getGlobalStageData().put(event.getEntity().m_20148_(), playerData);
    }

    @Shadow(remap=false)
    private static File getPlayerFile(File playerDir, String uuid) {
        return null;
    }
}

