/*
 * Decompiled with CFR 0.152.
 */
package net.scsupercraft.teamstages.mixin;

import net.darkhax.gamestages.GameStageHelper;
import net.darkhax.gamestages.GameStages;
import net.darkhax.gamestages.advancement.HasStageTrigger;
import net.darkhax.gamestages.data.IStageData;
import net.darkhax.gamestages.event.GameStageEvent;
import net.darkhax.gamestages.packet.MessageStages;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.scsupercraft.teamstages.TeamStageHelper;
import net.scsupercraft.teamstages.data.PlayerStageData;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;

@Mixin(value={GameStageHelper.class})
public class GameStageHelperMixin {
    @Overwrite(remap=false)
    public static int clearStages(ServerPlayer player) {
        PlayerStageData data = TeamStageHelper.getPlayerData((Player)player);
        if (data != null) {
            int stageCount = data.getStages().size();
            data.clear();
            MinecraftForge.EVENT_BUS.post((Event)new GameStageEvent.Cleared((Player)player, (IStageData)data));
            return stageCount - data.getStages().size();
        }
        return 0;
    }

    @Overwrite(remap=false)
    public static void syncPlayer(ServerPlayer player) {
        PlayerStageData info = TeamStageHelper.getPlayerData((Player)player);
        if (info != null) {
            GameStages.LOG.debug("Syncing {} stages for {}.", (Object)info.getPlayerStages().size(), (Object)player.m_7755_());
            GameStages.NETWORK.syncPlayerStages(player, new MessageStages(info.getPlayerStages()));
            for (String stage : info.getStages()) {
                HasStageTrigger.INSTANCE.trigger(player, stage);
            }
        }
    }
}

