/*
 * Decompiled with CFR 0.152.
 */
package net.scsupercraft.teamstages.listener;

import dev.ftb.mods.ftbteams.api.Team;
import dev.ftb.mods.ftbteams.api.event.PlayerChangedTeamEvent;
import dev.ftb.mods.ftbteams.api.event.TeamCreatedEvent;
import dev.ftb.mods.ftbteams.api.event.TeamEvent;
import dev.ftb.mods.ftbteams.data.PlayerTeam;
import java.util.UUID;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.scsupercraft.teamstages.TeamStageHelper;
import net.scsupercraft.teamstages.data.PlayerStageData;
import net.scsupercraft.teamstages.data.TeamStageSaveHandler;
import net.scsupercraft.teamstages.util.FtbUtil;

public class FtbTeamsEventListener {
    public static void listen() {
        TeamEvent.PLAYER_CHANGED.register(FtbTeamsEventListener::onPlayerChangeParty);
        TeamEvent.CREATED.register(FtbTeamsEventListener::onPartyCreated);
        TeamEvent.DELETED.register(FtbTeamsEventListener::onPartyDeleted);
    }

    private static void onPlayerChangeParty(PlayerChangedTeamEvent event) {
        ServerPlayer player = event.getPlayer();
        if (player == null) {
            return;
        }
        PlayerStageData data = TeamStageHelper.getPlayerData((Player)player);
        if (data != null) {
            data.update();
        }
    }

    private static void onPartyCreated(TeamCreatedEvent event) {
        Team team = event.getTeam();
        UUID teamId = team.getTeamId();
        PlayerTeam playerTeam = FtbUtil.getPlayerTeam(event.getCreatorId());
        if (team.isPartyTeam() && playerTeam != null) {
            TeamStageSaveHandler.copyTeamData(playerTeam.getTeamId(), teamId);
        } else {
            TeamStageSaveHandler.createTeamData(teamId);
        }
    }

    private static void onPartyDeleted(TeamEvent event) {
        TeamStageSaveHandler.deleteTeamData(event.getTeam().getTeamId());
    }
}

