/*
 * Decompiled with CFR 0.152.
 */
package net.scsupercraft.teamstages.ftbquests.tasks;

import dev.architectury.hooks.level.entity.PlayerHooks;
import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.config.NameMap;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.ServerQuestFile;
import dev.ftb.mods.ftbquests.quest.TeamData;
import dev.ftb.mods.ftbquests.quest.task.AbstractBooleanTask;
import dev.ftb.mods.ftbquests.quest.task.Task;
import dev.ftb.mods.ftbquests.quest.task.TaskType;
import dev.ftb.mods.ftbteams.api.Team;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.scsupercraft.teamstages.TeamStageHelper;
import net.scsupercraft.teamstages.data.PlayerStageData;
import net.scsupercraft.teamstages.data.TeamStageData;
import net.scsupercraft.teamstages.data.TeamStageSaveHandler;
import net.scsupercraft.teamstages.ftbquests.Tasks;
import net.scsupercraft.teamstages.util.FtbUtil;
import net.scsupercraft.teamstages.util.GameStageEffect;

public class StageTask
extends AbstractBooleanTask {
    protected String stage = "";
    protected GameStageEffect effect = GameStageEffect.PLAYER;

    public StageTask(long id, Quest quest) {
        super(id, quest);
    }

    public TaskType getType() {
        return Tasks.Stage;
    }

    public String getStage() {
        return this.stage;
    }

    public void setStage(String stage) {
        if (TeamStageHelper.isValidStageName((String)stage)) {
            this.stage = stage;
        }
    }

    public GameStageEffect getEffect() {
        return this.effect;
    }

    public void setEffect(GameStageEffect effect) {
        this.effect = effect;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void fillConfigGroup(ConfigGroup config) {
        super.fillConfigGroup(config);
        config.addString("stage", this.stage, this::setStage, "").setNameKey("teamstages.quests.tasks.stage.stage");
        config.addEnum("effect", (Object)this.effect, this::setEffect, NameMap.of((Object)((Object)GameStageEffect.PLAYER), (Object[])GameStageEffect.values()).create()).setNameKey("teamstages.quests.tasks.stage.effect");
    }

    @OnlyIn(value=Dist.CLIENT)
    public MutableComponent getAltTitle() {
        return Component.m_237110_((String)"teamstages.quests.tasks.stage.altTitle", (Object[])new Object[]{this.getStage()});
    }

    public void writeData(CompoundTag nbt) {
        super.writeData(nbt);
        nbt.m_128359_("stage", this.stage);
        nbt.m_128359_("effect", this.effect.toString());
    }

    public void readData(CompoundTag nbt) {
        super.readData(nbt);
        this.stage = nbt.m_128461_("stage");
        this.effect = GameStageEffect.valueOf(nbt.m_128461_("effect"));
    }

    public void writeNetData(FriendlyByteBuf buffer) {
        super.writeNetData(buffer);
        buffer.m_130072_(this.stage, Short.MAX_VALUE);
        buffer.m_130068_((Enum)this.effect);
    }

    public void readNetData(FriendlyByteBuf buffer) {
        super.readNetData(buffer);
        this.stage = buffer.m_130136_(Short.MAX_VALUE);
        this.effect = (GameStageEffect)buffer.m_130066_(GameStageEffect.class);
    }

    public int autoSubmitOnPlayerTick() {
        return 20;
    }

    public boolean canSubmit(TeamData teamData, ServerPlayer player) {
        Team team = FtbUtil.getTeam(teamData.getTeamId(), false);
        return this.teamCondition(team) || this.playerCondition(player);
    }

    private boolean teamCondition(@Nullable Team team) {
        if (team == null) {
            return false;
        }
        TeamStageData data = TeamStageHelper.getTeamData(team);
        if (data == null) {
            return false;
        }
        return this.effect.isTeamEffect() && data.hasStage(this.stage);
    }

    private boolean playerCondition(ServerPlayer player) {
        PlayerStageData data = TeamStageHelper.getPlayerData((Player)player);
        if (data == null) {
            return false;
        }
        return this.effect.isPlayerEffect() && data.playerHasStage(this.stage);
    }

    public static void checkStages(ServerPlayer player) {
        TeamData data;
        if (player == null || !TeamStageSaveHandler.isLoaded()) {
            return;
        }
        Team team = FtbUtil.getTeam(player);
        if (team == null) {
            return;
        }
        TeamData teamData = data = ServerQuestFile.INSTANCE != null && !PlayerHooks.isFake((Player)player) ? ServerQuestFile.INSTANCE.getOrCreateTeamData(team) : null;
        if (data != null && !data.isLocked()) {
            ServerQuestFile.INSTANCE.withPlayerContext(player, () -> {
                for (Task task : ServerQuestFile.INSTANCE.getAllTasks()) {
                    if (!(task instanceof StageTask) || !data.canStartTasks(task.getQuest())) continue;
                    task.submitTask(data, player);
                }
            });
        }
    }
}

