/*
 * Decompiled with CFR 0.152.
 */
package net.scsupercraft.teamstages.ftbquests.rewards;

import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.config.NameMap;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.reward.Reward;
import dev.ftb.mods.ftbquests.quest.reward.RewardAutoClaim;
import dev.ftb.mods.ftbquests.quest.reward.RewardType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.scsupercraft.teamstages.TeamStageHelper;
import net.scsupercraft.teamstages.data.PlayerStageData;
import net.scsupercraft.teamstages.ftbquests.Rewards;
import net.scsupercraft.teamstages.util.GameStageEffect;

public class StageReward
extends Reward {
    protected String stage = "";
    protected GameStageEffect effect = GameStageEffect.PLAYER;
    protected boolean remove = false;

    public StageReward(long id, Quest q) {
        super(id, q);
        this.autoclaim = RewardAutoClaim.INVISIBLE;
    }

    public RewardType getType() {
        return Rewards.Stage;
    }

    public String getStage() {
        return this.stage;
    }

    public void setStage(String stage) {
        if (TeamStageHelper.isValidStageName((String)stage)) {
            this.stage = stage;
        }
    }

    public GameStageEffect getEffect() {
        return this.effect;
    }

    public void setEffect(GameStageEffect effect) {
        this.effect = effect;
    }

    public boolean getRemove() {
        return this.remove;
    }

    public void setRemove(boolean remove) {
        this.remove = remove;
    }

    public void claim(ServerPlayer player, boolean notify) {
        PlayerStageData data = TeamStageHelper.getPlayerData((Player)player);
        if (data == null) {
            return;
        }
        if (this.remove) {
            data.removeStage(this.stage, true, this.effect);
        } else {
            data.addStage(this.stage, true, this.effect);
        }
        if (!notify) {
            return;
        }
        if (this.remove) {
            player.m_240418_((Component)Component.m_237110_((String)"commands.gamestage.remove.target", (Object[])new Object[]{this.stage}), true);
        } else {
            player.m_240418_((Component)Component.m_237110_((String)"commands.gamestage.add.target", (Object[])new Object[]{this.stage}), true);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void fillConfigGroup(ConfigGroup config) {
        super.fillConfigGroup(config);
        config.addString("stage", this.stage, this::setStage, "").setNameKey("teamstages.quests.rewards.stage.stage");
        config.addEnum("effect", (Object)this.effect, this::setEffect, NameMap.of((Object)((Object)GameStageEffect.PLAYER), (Object[])GameStageEffect.values()).create()).setNameKey("teamstages.quests.rewards.stage.effect");
        config.addBool("remove", this.remove, this::setRemove, false).setNameKey("teamstages.quests.rewards.stage.remove");
    }

    @OnlyIn(value=Dist.CLIENT)
    public MutableComponent getAltTitle() {
        return Component.m_237110_((String)"teamstages.quests.rewards.stage.altTitle", (Object[])new Object[]{this.getStage()});
    }

    public void writeData(CompoundTag nbt) {
        super.writeData(nbt);
        nbt.m_128359_("stage", this.stage);
        nbt.m_128359_("effect", this.effect.toString());
        nbt.m_128379_("remove", this.remove);
    }

    public void readData(CompoundTag nbt) {
        super.readData(nbt);
        this.stage = nbt.m_128461_("stage");
        this.effect = GameStageEffect.valueOf(nbt.m_128461_("effect"));
        this.remove = nbt.m_128471_("remove");
    }

    public void writeNetData(FriendlyByteBuf buffer) {
        super.writeNetData(buffer);
        buffer.m_130072_(this.stage, Short.MAX_VALUE);
        buffer.m_130068_((Enum)this.effect);
        buffer.writeBoolean(this.remove);
    }

    public void readNetData(FriendlyByteBuf buffer) {
        super.readNetData(buffer);
        this.stage = buffer.m_130136_(Short.MAX_VALUE);
        this.effect = (GameStageEffect)buffer.m_130066_(GameStageEffect.class);
        this.remove = buffer.readBoolean();
    }
}

