/*
 * Decompiled with CFR 0.152.
 */
package net.scsupercraft.teamstages.data;

import dev.ftb.mods.ftbteams.api.Team;
import dev.ftb.mods.ftbteams.api.TeamManager;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.darkhax.gamestages.data.GameStageSaveHandler;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.world.level.storage.LevelResource;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.scsupercraft.teamstages.TeamStages;
import net.scsupercraft.teamstages.data.PlayerStageData;
import net.scsupercraft.teamstages.data.TeamStageData;
import net.scsupercraft.teamstages.listener.ServerEventListener;
import net.scsupercraft.teamstages.util.FtbUtil;

public class TeamStageSaveHandler {
    private static boolean loaded = false;
    private static final Map<UUID, TeamStageData> GLOBAL_STAGE_DATA = new HashMap<UUID, TeamStageData>();
    @OnlyIn(value=Dist.CLIENT)
    private static TeamStageData clientData;

    public static void save() {
        File saveDir = TeamStageSaveHandler.getSaveDirectory().toFile();
        if (!saveDir.exists()) {
            saveDir.mkdirs();
        }
        GLOBAL_STAGE_DATA.forEach(TeamStageSaveHandler::save);
    }

    private static void save(UUID teamID, TeamStageData data) {
        try {
            CompoundTag tag = data.writeToNBT();
            NbtIo.m_128944_((CompoundTag)tag, (File)TeamStageSaveHandler.getTeamFile(teamID.toString()));
        }
        catch (IOException e) {
            TeamStages.LOGGER.error("Failed to save data for team {}", (Object)(data.getTeam() != null ? data.getTeam().getShortName() : "unknown"), (Object)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void load() {
        if (loaded) {
            return;
        }
        File saveDir = TeamStageSaveHandler.getSaveDirectory().toFile();
        GLOBAL_STAGE_DATA.clear();
        if (!saveDir.exists()) {
            saveDir.mkdirs();
            TeamStageSaveHandler.registerAllTeams();
            loaded = true;
            return;
        }
        try {
            File[] files = saveDir.listFiles(File::isFile);
            if (files == null) {
                throw new IOException();
            }
            for (File file : files) {
                try {
                    TeamStageData data = new TeamStageData(null);
                    CompoundTag tag = NbtIo.m_128937_((File)file);
                    data.readFromNBT(tag);
                    GLOBAL_STAGE_DATA.put(data.getTeamID(), data);
                    TeamStages.LOGGER.debug("Loaded {} stages for {}.", (Object)data.getStages().size(), (Object)(data.getTeam() != null ? data.getTeam().getShortName() : "unknown"));
                }
                catch (IOException e) {
                    TeamStages.LOGGER.error("Could not read team data for file {}.", (Object)file.getName(), (Object)e);
                }
            }
        }
        catch (Exception e) {
            TeamStages.LOGGER.error("An error occurred while trying to load team stages!", (Throwable)e);
        }
        finally {
            TeamStageSaveHandler.registerAllTeams();
            loaded = true;
        }
    }

    public static boolean isLoaded() {
        return loaded && ServerEventListener.isServerLoaded();
    }

    public static void markUnloaded() {
        loaded = false;
    }

    public static void registerAllTeams() {
        TeamManager manager = FtbUtil.getTeamManager();
        if (manager == null) {
            return;
        }
        for (Team team2 : manager.getTeams()) {
            UUID teamId = team2.getTeamId();
            if (GLOBAL_STAGE_DATA.containsKey(teamId)) continue;
            TeamStageSaveHandler.createTeamData(teamId);
        }
        manager.getKnownPlayerTeams().forEach((uuid, team) -> {
            if (!GLOBAL_STAGE_DATA.containsKey(uuid)) {
                TeamStageSaveHandler.createTeamData(uuid);
            }
        });
    }

    public static void createTeamData(UUID uuid) {
        GLOBAL_STAGE_DATA.put(uuid, new TeamStageData(uuid));
    }

    public static void deleteTeamData(UUID uuid) {
        GLOBAL_STAGE_DATA.remove(uuid);
        File teamDataFile = TeamStageSaveHandler.getTeamFile(uuid.toString());
        if (teamDataFile.exists()) {
            teamDataFile.delete();
        }
    }

    public static void copyTeamData(UUID srcTeamId, UUID destTeamId) {
        TeamStageData stageData = new TeamStageData(destTeamId);
        TeamStageData srcData = TeamStageSaveHandler.getTeamData(srcTeamId);
        if (srcData == null) {
            return;
        }
        for (String stage : srcData.getStages()) {
            stageData.addStage(stage, false);
        }
        GLOBAL_STAGE_DATA.put(destTeamId, stageData);
    }

    @Nullable
    public static TeamStageData getTeamData(UUID uuid) {
        return GLOBAL_STAGE_DATA.get(uuid);
    }

    @Nullable
    public static PlayerStageData getPlayerData(UUID uuid) {
        return (PlayerStageData)GameStageSaveHandler.getPlayerData((UUID)uuid);
    }

    private static File getPlayerFile(File playerDir, String uuid) {
        File saveDir = new File(playerDir, "gamestages");
        if (!saveDir.exists()) {
            saveDir.mkdirs();
        }
        return new File(saveDir, uuid + ".dat");
    }

    private static File getTeamFile(String uuid) {
        File saveDir = TeamStageSaveHandler.getSaveDirectory().toFile();
        if (!saveDir.exists()) {
            saveDir.mkdirs();
        }
        return new File(saveDir, uuid + ".dat");
    }

    private static Path getSaveDirectory() {
        return TeamStages.server.m_129843_(LevelResource.f_78182_).resolve("ftbteams/teamstages");
    }

    @OnlyIn(value=Dist.CLIENT)
    public static TeamStageData getClientData() {
        return clientData;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void setClientData(TeamStageData stageData) {
        clientData = stageData;
    }
}

