/*
 * Decompiled with CFR 0.152.
 */
package net.scsupercraft.teamstages.data;

import dev.ftb.mods.ftbteams.api.Team;
import dev.ftb.mods.ftbteams.api.TeamManager;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.UUID;
import net.darkhax.gamestages.data.StageData;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.scsupercraft.teamstages.TeamStageHelper;
import net.scsupercraft.teamstages.data.ITeamStageData;
import net.scsupercraft.teamstages.data.PlayerStageData;
import net.scsupercraft.teamstages.data.TeamStageSaveHandler;
import net.scsupercraft.teamstages.util.FtbUtil;
import net.scsupercraft.teamstages.util.GameStageEffect;
import org.jetbrains.annotations.Nullable;

public class TeamStageData
extends StageData
implements ITeamStageData {
    public static final String TAG_STAGES_TEAM_ID = "StagesTeamId";
    protected UUID teamID;

    public TeamStageData(UUID teamID) {
        this.teamID = teamID;
    }

    @Override
    public UUID getTeamID() {
        return this.teamID;
    }

    @Override
    @Nullable
    public Team getTeam() {
        if (!TeamStageSaveHandler.isLoaded()) {
            return null;
        }
        TeamManager manager = FtbUtil.getTeamManager();
        if (manager == null) {
            return null;
        }
        Optional optionalTeam = manager.getTeamByID(this.teamID);
        return optionalTeam.orElse(null);
    }

    public boolean memberHasStage(String stage) {
        return this.getMemberStages().contains(stage);
    }

    public void addStage(String stage) {
        this.addStage(stage, true);
    }

    public void addStage(String stage, boolean sync) {
        super.addStage(stage);
        if (sync) {
            TeamStageHelper.syncTeam(this.getTeam());
        }
    }

    public void removeStage(String stage) {
        this.removeStage(stage, true);
    }

    public void removeStage(String stage, boolean sync) {
        if (!this.hasStage(stage)) {
            return;
        }
        super.removeStage(stage);
        if (sync) {
            TeamStageHelper.syncTeam(this.getTeam());
        }
    }

    public void clear() {
        this.clear(true);
    }

    public void clear(boolean sync) {
        super.clear();
        if (sync) {
            TeamStageHelper.syncTeam(this.getTeam());
        }
    }

    public Collection<String> getMemberStages() {
        HashSet<String> stages = new HashSet<String>();
        Team team = this.getTeam();
        if (team == null) {
            return Collections.unmodifiableCollection(stages);
        }
        for (ServerPlayer player : team.getOnlineMembers()) {
            PlayerStageData data = TeamStageHelper.getPlayerData((Player)player);
            if (data == null) continue;
            stages.addAll(data.getStages(GameStageEffect.PLAYER));
        }
        return Collections.unmodifiableCollection(stages);
    }

    public void readFromNBT(CompoundTag tag) {
        ListTag list = tag.m_128437_("Stages", 8);
        for (int tagIndex = 0; tagIndex < list.size(); ++tagIndex) {
            this.addStage(list.m_128778_(tagIndex), false);
        }
        this.teamID = tag.m_128342_(TAG_STAGES_TEAM_ID);
    }

    public CompoundTag writeToNBT() {
        CompoundTag tag = super.writeToNBT();
        tag.m_128362_(TAG_STAGES_TEAM_ID, this.teamID);
        return tag;
    }

    public String toString() {
        return "TeamStageData [owner=" + (this.getTeam() != null ? this.getTeam().getShortName() : "unknown") + ", unlockedStages=" + this.getStages() + "]";
    }
}

