/*
 * Decompiled with CFR 0.152.
 */
package net.scsupercraft.teamstages.data;

import dev.ftb.mods.ftbteams.api.Team;
import dev.ftb.mods.ftbteams.api.TeamManager;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.UUID;
import net.darkhax.gamestages.data.StageData;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.server.level.ServerPlayer;
import net.scsupercraft.teamstages.TeamStageHelper;
import net.scsupercraft.teamstages.TeamStages;
import net.scsupercraft.teamstages.config.CommonConfig;
import net.scsupercraft.teamstages.data.IPlayerStageData;
import net.scsupercraft.teamstages.data.ITeamStageData;
import net.scsupercraft.teamstages.data.TeamStageData;
import net.scsupercraft.teamstages.data.TeamStageSaveHandler;
import net.scsupercraft.teamstages.ftbquests.FtbQuestsIntegration;
import net.scsupercraft.teamstages.ftbquests.tasks.StageTask;
import net.scsupercraft.teamstages.util.FtbUtil;
import net.scsupercraft.teamstages.util.GameStageEffect;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlayerStageData
extends StageData
implements ITeamStageData,
IPlayerStageData {
    public static final String TAG_STAGES_TEAM_ID = "StagesTeamId";
    public static final String TAG_STAGES_PLAYER_ID = "StagesPlayerId";
    protected UUID teamID;
    protected UUID playerID;

    public PlayerStageData(UUID playerID, @Nullable UUID teamID) {
        this.playerID = playerID;
        if (teamID != null) {
            this.teamID = teamID;
        } else {
            this.update();
        }
    }

    @Override
    public UUID getPlayerID() {
        return this.playerID;
    }

    @Override
    @Nullable
    public ServerPlayer getPlayer() {
        return TeamStages.server.m_6846_().m_11259_(this.playerID);
    }

    @Override
    @Nullable
    public UUID getTeamID() {
        return this.teamID;
    }

    @Override
    @Nullable
    public Team getTeam() {
        if (!TeamStageSaveHandler.isLoaded()) {
            return null;
        }
        TeamManager manager = FtbUtil.getTeamManager();
        if (manager == null) {
            return null;
        }
        Optional optionalTeam = manager.getTeamByID(this.teamID);
        return optionalTeam.orElse(null);
    }

    @Nullable
    public TeamStageData getTeamStageData() {
        return TeamStageSaveHandler.getTeamData(this.getTeamID());
    }

    public boolean needsUpdate() {
        ServerPlayer player = this.getPlayer();
        TeamManager manager = FtbUtil.getTeamManager();
        if (manager == null || player == null) {
            return false;
        }
        Optional optionalTeam = manager.getTeamForPlayer(this.getPlayer());
        return optionalTeam.filter(value -> value.getTeamId() != this.teamID).isPresent();
    }

    public void update() {
        if (!this.needsUpdate()) {
            return;
        }
        TeamManager manager = FtbUtil.getTeamManager();
        if (manager == null) {
            return;
        }
        Optional optionalTeam = manager.getTeamForPlayer(this.getPlayer());
        if (optionalTeam.isEmpty()) {
            return;
        }
        Team team = (Team)optionalTeam.get();
        this.teamID = team.getTeamId();
        TeamStageHelper.syncTeam(this.getTeam());
    }

    public Collection<String> getStages() {
        return this.getStages(CommonConfig.listEffect);
    }

    public Collection<String> getStages(GameStageEffect effect) {
        TeamStageData data;
        HashSet collection = new HashSet();
        if (effect.isTeamEffect() && (data = this.getTeamStageData()) != null) {
            collection.addAll(data.getStages());
        }
        if (effect.isPlayerEffect()) {
            collection.addAll(super.getStages());
        }
        return Collections.unmodifiableCollection(collection);
    }

    public boolean hasStage(@NotNull String stage) {
        return this.hasStage(stage, CommonConfig.checkEffect);
    }

    public boolean hasStage(@NotNull String stage, GameStageEffect effect) {
        return this.getStages(effect).contains(stage);
    }

    public void addStage(String stage) {
        this.addStage(stage, true);
    }

    public void addStage(String stage, boolean sync) {
        this.addStage(stage, sync, CommonConfig.changeEffect);
    }

    public void addStage(String stage, boolean sync, GameStageEffect effect) {
        boolean syncTeam = false;
        if (effect.isTeamEffect()) {
            TeamStageData data = this.getTeamStageData();
            if (data != null) {
                data.addStage(stage);
            }
            if (sync) {
                syncTeam = true;
            }
        }
        if (effect.isPlayerEffect()) {
            super.addStage(stage);
        }
        if (syncTeam) {
            TeamStageHelper.syncTeam(this.getTeam());
        } else if (sync) {
            TeamStageHelper.syncPlayer((ServerPlayer)this.getPlayer());
        }
        if (FtbQuestsIntegration.enabled) {
            StageTask.checkStages(this.getPlayer());
        }
    }

    public void removeStage(String stage) {
        this.removeStage(stage, true);
    }

    public void removeStage(String stage, boolean sync) {
        this.removeStage(stage, sync, CommonConfig.changeEffect);
    }

    public void removeStage(String stage, boolean sync, GameStageEffect effect) {
        boolean syncTeam = false;
        if (effect.isTeamEffect()) {
            TeamStageData data = this.getTeamStageData();
            if (data != null && data.hasStage(stage)) {
                data.removeStage(stage);
            }
            if (sync) {
                syncTeam = true;
            }
        }
        if (effect.isPlayerEffect() && super.hasStage(stage)) {
            super.removeStage(stage);
        }
        if (syncTeam) {
            TeamStageHelper.syncTeam(this.getTeam());
        } else if (sync) {
            TeamStageHelper.syncPlayer((ServerPlayer)this.getPlayer());
        }
    }

    public void clear() {
        this.clear(true);
    }

    public void clear(boolean sync) {
        boolean syncTeam = false;
        if (CommonConfig.changeEffect.isTeamEffect()) {
            TeamStageData data = this.getTeamStageData();
            if (data != null) {
                data.clear();
            }
            if (sync) {
                syncTeam = true;
            }
        }
        if (CommonConfig.changeEffect.isPlayerEffect()) {
            super.clear();
        }
        if (syncTeam) {
            TeamStageHelper.syncTeam(this.getTeam());
        } else if (sync) {
            TeamStageHelper.syncPlayer((ServerPlayer)this.getPlayer());
        }
    }

    public Collection<String> getPlayerStages() {
        return super.getStages();
    }

    public boolean playerHasStage(@NotNull String stage) {
        return super.hasStage(stage);
    }

    public void addPlayerStage(String stage) {
        this.addPlayerStage(stage, true);
    }

    public void addPlayerStage(String stage, boolean sync) {
        super.addStage(stage);
        if (sync) {
            TeamStageHelper.syncPlayer((ServerPlayer)this.getPlayer());
        }
    }

    public void removePlayerStage(String stage) {
        this.removePlayerStage(stage, true);
    }

    public void removePlayerStage(String stage, boolean sync) {
        super.removeStage(stage);
        if (sync) {
            TeamStageHelper.syncPlayer((ServerPlayer)this.getPlayer());
        }
    }

    public void clearPlayer() {
        this.clearPlayer(true);
    }

    public void clearPlayer(boolean sync) {
        super.clear();
        if (sync) {
            TeamStageHelper.syncPlayer((ServerPlayer)this.getPlayer());
        }
    }

    public void readFromNBT(CompoundTag tag) {
        ListTag list = tag.m_128437_("Stages", 8);
        for (int tagIndex = 0; tagIndex < list.size(); ++tagIndex) {
            this.addStage(list.m_128778_(tagIndex), false, GameStageEffect.PLAYER);
        }
        this.teamID = tag.m_128441_(TAG_STAGES_TEAM_ID) ? tag.m_128342_(TAG_STAGES_TEAM_ID) : null;
        this.playerID = tag.m_128342_(TAG_STAGES_PLAYER_ID);
    }

    public CompoundTag writeToNBT() {
        CompoundTag tag = super.writeToNBT();
        tag.m_128362_(TAG_STAGES_TEAM_ID, this.teamID);
        tag.m_128362_(TAG_STAGES_PLAYER_ID, this.playerID);
        return tag;
    }

    public String toString() {
        return "PlayerStageData [owner=" + (this.getPlayer() != null ? this.getPlayer().m_6302_() : "unknown") + ", unlockedStages=" + this.getStages() + "]";
    }
}

