/*
 * Decompiled with CFR 0.152.
 */
package net.scsupercraft.teamstages.command;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import dev.ftb.mods.ftbteams.api.Team;
import dev.ftb.mods.ftbteams.data.TeamArgument;
import java.util.Collection;
import java.util.stream.Collectors;
import net.darkhax.gamestages.command.StageArgumentType;
import net.darkhax.gamestages.data.StageData;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.scsupercraft.teamstages.TeamStageHelper;
import net.scsupercraft.teamstages.data.PlayerStageData;
import net.scsupercraft.teamstages.data.TeamStageData;
import net.scsupercraft.teamstages.util.FtbUtil;

public class TeamStageCommands {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        for (CommandNode node : dispatcher.getRoot().getChildren()) {
            if (!node.getName().equals("gamestage")) continue;
            dispatcher.register((LiteralArgumentBuilder)Commands.m_82127_((String)"gs").redirect(node));
            break;
        }
        LiteralArgumentBuilder commandLiteral = Commands.m_82127_((String)"teamstage");
        commandLiteral.then(TeamStageCommands.createCommands("player", false));
        commandLiteral.then(TeamStageCommands.createCommands("team", true));
        LiteralCommandNode command = dispatcher.register(commandLiteral);
        dispatcher.register((LiteralArgumentBuilder)Commands.m_82127_((String)"ts").redirect((CommandNode)command));
    }

    private static LiteralArgumentBuilder<CommandSourceStack> createCommand(String key, int permissions, boolean forTeam, Command<CommandSourceStack> command, Command<CommandSourceStack> commandNoPlayer) {
        RequiredArgumentBuilder targetArg = forTeam ? Commands.m_82129_((String)"target", (ArgumentType)TeamArgument.create()) : Commands.m_82129_((String)"target", (ArgumentType)EntityArgument.m_91466_());
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)key).requires(sender -> sender.m_6761_(permissions))).executes(commandNoPlayer)).then(targetArg.executes(command));
    }

    private static LiteralArgumentBuilder<CommandSourceStack> createSilentStageCommand(String key, int permissions, boolean forTeam, Command<CommandSourceStack> command, Command<CommandSourceStack> silent) {
        RequiredArgumentBuilder targetArg = forTeam ? Commands.m_82129_((String)"target", (ArgumentType)TeamArgument.create()) : Commands.m_82129_((String)"target", (ArgumentType)EntityArgument.m_91466_());
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)key).requires(sender -> sender.m_6761_(permissions))).then(targetArg.then(((RequiredArgumentBuilder)Commands.m_82129_((String)"stage", (ArgumentType)new StageArgumentType()).executes(command)).then(Commands.m_82129_((String)"silent", (ArgumentType)BoolArgumentType.bool()).executes(silent))));
    }

    private static LiteralArgumentBuilder<CommandSourceStack> createStageCommand(String key, int permissions, boolean forTeam, Command<CommandSourceStack> command, Command<CommandSourceStack> commandNoPlayer) {
        RequiredArgumentBuilder targetArg = forTeam ? Commands.m_82129_((String)"target", (ArgumentType)TeamArgument.create()) : Commands.m_82129_((String)"target", (ArgumentType)EntityArgument.m_91466_());
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)key).requires(sender -> sender.m_6761_(permissions))).then(Commands.m_82129_((String)"stage", (ArgumentType)new StageArgumentType()).executes(commandNoPlayer))).then(targetArg.then(Commands.m_82129_((String)"stage", (ArgumentType)new StageArgumentType()).executes(command)));
    }

    private static LiteralArgumentBuilder<CommandSourceStack> createCommands(String key, boolean forTeam) {
        LiteralArgumentBuilder command = Commands.m_82127_((String)key);
        command.then(TeamStageCommands.createSilentStageCommand("add", 2, forTeam, (Command<CommandSourceStack>)((Command)ctx -> TeamStageCommands.changeStages((CommandContext<CommandSourceStack>)ctx, true, false, forTeam)), (Command<CommandSourceStack>)((Command)ctx -> TeamStageCommands.changeStages((CommandContext<CommandSourceStack>)ctx, true, true, forTeam))));
        command.then(TeamStageCommands.createCommand("all", 2, forTeam, (Command<CommandSourceStack>)((Command)ctx -> TeamStageCommands.grantAll((CommandContext<CommandSourceStack>)ctx, true, forTeam)), (Command<CommandSourceStack>)((Command)ctx -> TeamStageCommands.grantAll((CommandContext<CommandSourceStack>)ctx, false, forTeam))));
        command.then(TeamStageCommands.createStageCommand("check", 2, forTeam, (Command<CommandSourceStack>)((Command)ctx -> TeamStageCommands.checkStage((CommandContext<CommandSourceStack>)ctx, true, forTeam)), (Command<CommandSourceStack>)((Command)ctx -> TeamStageCommands.checkStage((CommandContext<CommandSourceStack>)ctx, false, forTeam))));
        command.then(TeamStageCommands.createCommand("clear", 2, forTeam, (Command<CommandSourceStack>)((Command)ctx -> TeamStageCommands.clearStages((CommandContext<CommandSourceStack>)ctx, true, forTeam)), (Command<CommandSourceStack>)((Command)ctx -> TeamStageCommands.clearStages((CommandContext<CommandSourceStack>)ctx, false, forTeam))));
        command.then(TeamStageCommands.createCommand("info", 0, forTeam, (Command<CommandSourceStack>)((Command)ctx -> TeamStageCommands.getStageInfo((CommandContext<CommandSourceStack>)ctx, true, forTeam)), (Command<CommandSourceStack>)((Command)ctx -> TeamStageCommands.getStageInfo((CommandContext<CommandSourceStack>)ctx, false, forTeam))));
        command.then(TeamStageCommands.createSilentStageCommand("remove", 2, forTeam, (Command<CommandSourceStack>)((Command)ctx -> TeamStageCommands.changeStages((CommandContext<CommandSourceStack>)ctx, false, false, forTeam)), (Command<CommandSourceStack>)((Command)ctx -> TeamStageCommands.changeStages((CommandContext<CommandSourceStack>)ctx, false, true, forTeam))));
        return command;
    }

    public static int grantAll(CommandContext<CommandSourceStack> context, boolean hasTarget, boolean forTeam) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        if (forTeam) {
            Team team = hasTarget ? TeamArgument.get(context, (String)"target") : FtbUtil.getTeam(source.m_81375_());
            TeamStageData data = TeamStageHelper.getTeamData(team);
            if (data == null) {
                return 1;
            }
            TeamStageHelper.addTeamStage(team, TeamStageHelper.getKnownStages().toArray(new String[0]));
            for (ServerPlayer player : team.getOnlineMembers()) {
                player.m_5661_((Component)Component.m_237115_((String)"commands.gamestage.all.target"), false);
                if (player == source.m_81373_()) continue;
                source.m_288197_(() -> Component.m_237110_((String)"commands.gamestage.all.sender", (Object[])new Object[]{player.m_5446_()}), true);
            }
        } else {
            ServerPlayer player = hasTarget ? EntityArgument.m_91474_(context, (String)"target") : source.m_81375_();
            PlayerStageData data = TeamStageHelper.getPlayerData((Player)player);
            if (data == null) {
                return 1;
            }
            TeamStageHelper.addPlayerStage(player, TeamStageHelper.getKnownStages().toArray(new String[0]));
            player.m_5661_((Component)Component.m_237115_((String)"commands.gamestage.all.target"), false);
            if (player != source.m_81373_()) {
                source.m_288197_(() -> Component.m_237110_((String)"commands.gamestage.all.sender", (Object[])new Object[]{player.m_5446_()}), true);
            }
        }
        return 1;
    }

    public static int checkStage(CommandContext<CommandSourceStack> context, boolean hasTarget, boolean forTeam) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        String stage = StageArgumentType.getStage(context, (String)"stage");
        if (forTeam) {
            Team team;
            Team team2 = team = hasTarget ? TeamArgument.get(context, (String)"target") : FtbUtil.getTeam(source.m_81375_());
            if (team == null) {
                return 1;
            }
            boolean hasStage = TeamStageHelper.teamHasStage(team, stage);
            source.m_288197_(() -> Component.m_237110_((String)(hasStage ? "commands.gamestage.check.success" : "commands.gamestage.check.failure"), (Object[])new Object[]{team.getShortName(), stage}), false);
            return hasStage ? 1 : 0;
        }
        ServerPlayer player = hasTarget ? EntityArgument.m_91474_(context, (String)"target") : source.m_81375_();
        boolean hasStage = TeamStageHelper.playerHasStage((Player)player, stage);
        source.m_288197_(() -> Component.m_237110_((String)(hasStage ? "commands.gamestage.check.success" : "commands.gamestage.check.failure"), (Object[])new Object[]{player.m_5446_(), stage}), false);
        return hasStage ? 1 : 0;
    }

    public static int clearStages(CommandContext<CommandSourceStack> context, boolean hasTarget, boolean forTeam) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        if (forTeam) {
            Team team;
            Team team2 = team = hasTarget ? TeamArgument.get(context, (String)"target") : FtbUtil.getTeam(source.m_81375_());
            if (team == null) {
                return 1;
            }
            int removedStages = TeamStageHelper.clearTeamStages(team);
            for (ServerPlayer player : team.getOnlineMembers()) {
                player.m_5661_((Component)Component.m_237110_((String)"commands.gamestage.clear.target", (Object[])new Object[]{removedStages}), false);
                if (player == source.m_81373_()) continue;
                source.m_288197_(() -> Component.m_237110_((String)"commands.gamestage.clear.sender", (Object[])new Object[]{removedStages, player.m_5446_()}), true);
            }
        } else {
            ServerPlayer player = hasTarget ? EntityArgument.m_91474_(context, (String)"target") : source.m_81375_();
            int removedStages = TeamStageHelper.clearPlayerStages(player);
            player.m_5661_((Component)Component.m_237110_((String)"commands.gamestage.clear.target", (Object[])new Object[]{removedStages}), false);
            if (player != source.m_81373_()) {
                source.m_288197_(() -> Component.m_237110_((String)"commands.gamestage.clear.sender", (Object[])new Object[]{removedStages, player.m_5446_()}), true);
            }
        }
        return 1;
    }

    public static int getStageInfo(CommandContext<CommandSourceStack> context, boolean hasTarget, boolean forTeam) throws CommandSyntaxException {
        Collection<String> collection;
        String infoOwner;
        StageData data;
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        if (forTeam) {
            Team team = hasTarget ? TeamArgument.get(context, (String)"target") : FtbUtil.getTeam(source.m_81375_());
            data = TeamStageHelper.getTeamData(team);
            infoOwner = team != null ? team.getShortName() : "unknown";
        } else {
            ServerPlayer player = hasTarget ? EntityArgument.m_91474_(context, (String)"target") : source.m_81375_();
            data = TeamStageHelper.getPlayerData((Player)player);
            infoOwner = player.m_6302_();
        }
        if (data == null) {
            source.m_288197_(() -> Component.m_237110_((String)"commands.gamestage.info.empty", (Object[])new Object[]{infoOwner}), false);
            return 1;
        }
        if (data instanceof PlayerStageData) {
            StageData playerStageData = data;
            collection = playerStageData.getPlayerStages();
        } else {
            collection = data.getStages();
        }
        Collection<String> stages = collection;
        String stageInfo = stages.stream().map(Object::toString).collect(Collectors.joining(", "));
        if (stageInfo.isEmpty()) {
            source.m_288197_(() -> Component.m_237110_((String)"commands.gamestage.info.empty", (Object[])new Object[]{infoOwner}), false);
        } else {
            source.m_288197_(() -> Component.m_237110_((String)"commands.gamestage.info.stages", (Object[])new Object[]{infoOwner, stageInfo}), false);
        }
        return 1;
    }

    private static int changeStages(CommandContext<CommandSourceStack> context, boolean adding, boolean hasSilentArg, boolean forTeam) throws CommandSyntaxException {
        boolean silent;
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        String stage = StageArgumentType.getStage(context, (String)"stage");
        boolean bl = silent = hasSilentArg && BoolArgumentType.getBool(context, (String)"silent");
        if (forTeam) {
            Team team = TeamArgument.get(context, (String)"target");
            TeamStageData data = TeamStageHelper.getTeamData(team);
            if (data == null || adding == data.hasStage(stage)) {
                return 1;
            }
            if (adding) {
                data.addStage(stage);
            } else {
                data.removeStage(stage);
            }
            if (silent) {
                return 1;
            }
            for (ServerPlayer player : team.getOnlineMembers()) {
                player.m_5661_((Component)Component.m_237110_((String)(adding ? "commands.gamestage.add.target" : "commands.gamestage.remove.target"), (Object[])new Object[]{stage}), false);
                if (player == source.m_81373_()) continue;
                source.m_288197_(() -> Component.m_237110_((String)(adding ? "commands.gamestage.add.sender" : "commands.gamestage.remove.sender"), (Object[])new Object[]{stage, player.m_5446_()}), true);
            }
        } else {
            ServerPlayer player = EntityArgument.m_91474_(context, (String)"target");
            PlayerStageData data = TeamStageHelper.getPlayerData((Player)player);
            if (data == null || adding == data.playerHasStage(stage)) {
                return 1;
            }
            if (adding) {
                data.addPlayerStage(stage);
            } else {
                data.removePlayerStage(stage);
            }
            if (silent) {
                return 1;
            }
            player.m_5661_((Component)Component.m_237110_((String)(adding ? "commands.gamestage.add.target" : "commands.gamestage.remove.target"), (Object[])new Object[]{stage}), false);
            if (player != source.m_81373_()) {
                source.m_288197_(() -> Component.m_237110_((String)(adding ? "commands.gamestage.add.sender" : "commands.gamestage.remove.sender"), (Object[])new Object[]{stage, player.m_5446_()}), true);
            }
        }
        return 1;
    }
}

