/*
 * Decompiled with CFR 0.152.
 */
package net.scsupercraft.teamstages;

import dev.ftb.mods.ftbteams.api.Team;
import java.util.Arrays;
import java.util.Collection;
import java.util.UUID;
import javax.annotation.Nullable;
import net.darkhax.gamestages.GameStageHelper;
import net.darkhax.gamestages.data.GameStageSaveHandler;
import net.darkhax.gamestages.data.IStageData;
import net.darkhax.gamestages.event.GameStageEvent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.util.thread.EffectiveSide;
import net.scsupercraft.teamstages.TeamStages;
import net.scsupercraft.teamstages.data.PlayerStageData;
import net.scsupercraft.teamstages.data.TeamStageData;
import net.scsupercraft.teamstages.data.TeamStageSaveHandler;
import net.scsupercraft.teamstages.packet.MessageTeamStages;
import net.scsupercraft.teamstages.packet.TeamStagesPacketHandler;

public class TeamStageHelper
extends GameStageHelper {
    public static boolean playerHasStage(Player player, String stage) {
        return TeamStageHelper.playerHasStage(player, TeamStageHelper.getPlayerData(player), stage);
    }

    public static boolean playerHasStage(Player player, @Nullable IStageData data, String stage) {
        if (data instanceof PlayerStageData) {
            PlayerStageData playerStageData = (PlayerStageData)data;
            GameStageEvent.Check event = new GameStageEvent.Check(player, stage, playerStageData.playerHasStage(stage));
            MinecraftForge.EVENT_BUS.post((Event)event);
            return event.hasStage();
        }
        return false;
    }

    public static boolean playerHasAnyOf(Player player, String ... stages) {
        return TeamStageHelper.playerHasAnyOf(player, (IStageData)TeamStageHelper.getPlayerData(player), stages);
    }

    public static boolean playerHasAnyOf(Player player, Collection<String> stages) {
        return TeamStageHelper.playerHasAnyOf(player, (IStageData)TeamStageHelper.getPlayerData(player), stages);
    }

    public static boolean playerHasAnyOf(Player player, @Nullable IStageData data, Collection<String> stages) {
        return stages.stream().anyMatch(stage -> TeamStageHelper.playerHasStage(player, data, stage));
    }

    public static boolean playerHasAnyOf(Player player, @Nullable IStageData data, String ... stages) {
        return Arrays.stream(stages).anyMatch(stage -> TeamStageHelper.playerHasStage(player, data, stage));
    }

    public static boolean playerHasAllOf(Player player, String ... stages) {
        return TeamStageHelper.playerHasAllOf(player, (IStageData)TeamStageHelper.getPlayerData(player), stages);
    }

    public static boolean playerHasAllOf(Player player, Collection<String> stages) {
        return TeamStageHelper.playerHasAllOf(player, (IStageData)TeamStageHelper.getPlayerData(player), stages);
    }

    public static boolean playerHasAllOf(Player player, @Nullable IStageData data, Collection<String> stages) {
        return stages.stream().allMatch(stage -> TeamStageHelper.playerHasStage(player, data, stage));
    }

    public static boolean playerHasAllOf(Player player, @Nullable IStageData data, String ... stages) {
        return Arrays.stream(stages).allMatch(stage -> TeamStageHelper.playerHasStage(player, data, stage));
    }

    public static void addPlayerStage(ServerPlayer player, String ... stages) {
        PlayerStageData data = TeamStageHelper.getPlayerData((Player)player);
        if (data != null) {
            for (String stage : stages) {
                data.addPlayerStage(stage, false);
            }
            TeamStageHelper.syncPlayer((ServerPlayer)player);
        }
    }

    public static void removePlayerStage(ServerPlayer player, String ... stages) {
        PlayerStageData data = TeamStageHelper.getPlayerData((Player)player);
        if (data != null) {
            for (String stage : stages) {
                data.removePlayerStage(stage, false);
            }
            TeamStageHelper.syncPlayer((ServerPlayer)player);
        }
    }

    public static int clearPlayerStages(ServerPlayer player) {
        PlayerStageData stageInfo = TeamStageHelper.getPlayerData((Player)player);
        if (stageInfo != null) {
            int stageCount = stageInfo.getPlayerStages().size();
            stageInfo.clearPlayer();
            return stageCount;
        }
        return 0;
    }

    @Nullable
    public static PlayerStageData getPlayerData(Player player) {
        if (player != null) {
            if (player instanceof ServerPlayer) {
                return (PlayerStageData)GameStageSaveHandler.getPlayerData((UUID)player.m_20148_());
            }
            if (EffectiveSide.get().isClient()) {
                return (PlayerStageData)GameStageSaveHandler.getClientData();
            }
        }
        return null;
    }

    public static boolean teamHasStage(Team team, String stage) {
        return TeamStageHelper.teamHasStage(TeamStageHelper.getTeamData(team), stage);
    }

    public static boolean teamHasStage(@Nullable IStageData data, String stage) {
        if (data instanceof PlayerStageData) {
            PlayerStageData stageData = (PlayerStageData)data;
            if (stageData.getTeamStageData() == null) {
                return false;
            }
            return stageData.getTeamStageData().hasStage(stage);
        }
        if (data instanceof TeamStageData) {
            TeamStageData stageData = (TeamStageData)data;
            return stageData.hasStage(stage);
        }
        return false;
    }

    public static boolean teamHasAnyOf(Team team, Collection<String> stages) {
        return stages.stream().anyMatch(stage -> TeamStageHelper.teamHasStage(team, stage));
    }

    public static boolean teamHasAnyOf(Team team, String ... stages) {
        return Arrays.stream(stages).anyMatch(stage -> TeamStageHelper.teamHasStage(team, stage));
    }

    public static boolean teamHasAllOf(Team team, Collection<String> stages) {
        return stages.stream().allMatch(stage -> TeamStageHelper.teamHasStage(team, stage));
    }

    public static boolean teamHasAllOf(Team team, String ... stages) {
        return Arrays.stream(stages).allMatch(stage -> TeamStageHelper.teamHasStage(team, stage));
    }

    public static void addTeamStage(Team team, String ... stages) {
        TeamStageData data = TeamStageHelper.getTeamData(team);
        if (data != null) {
            for (String stage : stages) {
                data.addStage(stage, false);
            }
            TeamStageHelper.syncTeam(team);
        }
    }

    public static void removeTeamStage(Team team, String ... stages) {
        TeamStageData data = TeamStageHelper.getTeamData(team);
        if (data != null) {
            for (String stage : stages) {
                data.removeStage(stage, false);
            }
            TeamStageHelper.syncTeam(team);
        }
    }

    public static int clearTeamStages(Team team) {
        TeamStageData stageInfo = TeamStageHelper.getTeamData(team);
        if (stageInfo != null) {
            int stageCount = stageInfo.getStages().size();
            stageInfo.clear();
            return stageCount;
        }
        return 0;
    }

    @Nullable
    public static TeamStageData getTeamData(Team team) {
        if (team != null) {
            if (team.isClientTeam()) {
                return TeamStageSaveHandler.getClientData();
            }
            return TeamStageSaveHandler.getTeamData(team.getTeamId());
        }
        return null;
    }

    public static void syncTeam(Team team) {
        TeamStageData info = TeamStageHelper.getTeamData(team);
        if (info != null) {
            TeamStages.LOGGER.debug("Syncing {} stages for {}.", (Object)info.getStages().size(), (Object)team.getShortName());
            for (ServerPlayer player : team.getOnlineMembers()) {
                TeamStagesPacketHandler.sendToClient(player, new MessageTeamStages(team.getTeamId(), info.getStages()));
                TeamStageHelper.syncPlayer((ServerPlayer)player);
            }
        }
    }
}

