/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.network;

import java.util.UUID;
import net.mehvahdjukaar.moonlight.api.platform.network.ChannelHandler;
import net.mehvahdjukaar.moonlight.api.platform.network.Message;
import net.mehvahdjukaar.moonlight.api.platform.network.NetworkDir;
import net.mehvahdjukaar.supplementaries.client.renderers.entities.funny.PickleData;
import net.mehvahdjukaar.supplementaries.common.network.ModNetwork;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class PicklePacket
implements Message {
    protected UUID playerID;
    protected final boolean on;
    private final boolean isJar;

    public PicklePacket(UUID appliesTo, boolean on, boolean isJar) {
        this.playerID = appliesTo;
        this.on = on;
        this.isJar = isJar;
    }

    public PicklePacket(FriendlyByteBuf buf) {
        this.on = buf.readBoolean();
        this.isJar = buf.readBoolean();
        if (buf.isReadable()) {
            this.playerID = buf.m_130259_();
        }
    }

    public void writeToBuffer(FriendlyByteBuf buf) {
        buf.writeBoolean(this.on);
        buf.writeBoolean(this.isJar);
        if (this.playerID != null) {
            buf.m_130077_(this.playerID);
        }
    }

    public void handle(ChannelHandler.Context context) {
        if (context.getDirection() == NetworkDir.PLAY_TO_CLIENT) {
            PickleData.set(this.playerID, this.on, this.isJar);
        } else {
            Player player = context.getSender();
            UUID id = player.m_36316_().getId();
            if (PickleData.isDev(id, this.isJar)) {
                PickleData.set(id, this.on, this.isJar);
                this.playerID = id;
                for (ServerPlayer p : player.m_20194_().m_6846_().m_11314_()) {
                    if (p == player) continue;
                    ModNetwork.CHANNEL.sendToClientPlayer(p, (Message)new PicklePacket(this.playerID, this.on, this.isJar));
                }
            }
        }
    }
}

