/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.tiles;

import net.mehvahdjukaar.moonlight.api.platform.ForgeHelper;
import net.mehvahdjukaar.supplementaries.common.block.blocks.TurnTableBlock;
import net.mehvahdjukaar.supplementaries.common.utils.BlockUtil;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.mehvahdjukaar.supplementaries.reg.ModSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseRailBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.RailShape;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class TurnTableBlockTile
extends BlockEntity {
    private int cooldown = 5;
    private boolean canRotate = false;
    private int catTimer = 0;

    public TurnTableBlockTile(BlockPos pos, BlockState state) {
        super(ModRegistry.TURN_TABLE_TILE.get(), pos, state);
    }

    public void tryRotate() {
        this.canRotate = true;
        this.cooldown = TurnTableBlock.getPeriod(this.m_58900_());
    }

    public int getCatTimer() {
        return this.catTimer;
    }

    public void setCat() {
        this.catTimer = 400;
    }

    public static void tick(Level level, BlockPos pos, BlockState state, TurnTableBlockTile tile) {
        tile.catTimer = Math.max(tile.catTimer - 1, 0);
        if (tile.cooldown == 0) {
            BlockPos targetPos;
            boolean ccw;
            Direction dir = (Direction)state.m_61143_((Property)TurnTableBlock.FACING);
            boolean success = BlockUtil.tryRotatingBlock(dir, ccw = (Boolean)state.m_61143_((Property)TurnTableBlock.INVERTED) ^ state.m_61143_((Property)TurnTableBlock.FACING) == Direction.DOWN, targetPos = pos.m_121945_(dir), level, null).isPresent();
            if (success) {
                level.m_7696_(pos, state.m_60734_(), 0, 0);
                level.m_142346_(null, GameEvent.f_157792_, targetPos);
                level.m_5594_(null, targetPos, ModSounds.BLOCK_ROTATE.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                if (dir == Direction.UP) {
                    tile.tryRotatingMinecartsAbove(level, pos, ccw);
                }
            }
            tile.cooldown = TurnTableBlock.getPeriod(state);
            int power = (Integer)state.m_61143_((Property)TurnTableBlock.POWER);
            boolean bl = tile.canRotate = success && power != 0;
            if (power == 0) {
                level.m_7731_(pos, (BlockState)state.m_61124_((Property)TurnTableBlock.ROTATING, (Comparable)Boolean.valueOf(false)), 3);
            }
        } else if (tile.canRotate) {
            --tile.cooldown;
        }
    }

    private void tryRotatingMinecartsAbove(Level level, BlockPos pos, boolean ccw) {
        BlockPos above = pos.m_7494_();
        BlockState state = level.m_8055_(above);
        Block block = state.m_60734_();
        if (block instanceof BaseRailBlock) {
            BaseRailBlock rb = (BaseRailBlock)block;
            for (AbstractMinecart c : level.m_45976_(AbstractMinecart.class, new AABB(above))) {
                RailShape shape = ForgeHelper.getRailDirection((BaseRailBlock)rb, (BlockState)state, (Level)level, (BlockPos)above, (AbstractMinecart)c);
                Direction.Axis axis = TurnTableBlockTile.getRailAxis(shape);
                if (axis == Direction.Axis.Y) continue;
                c.m_146922_(c.m_146908_() + (float)(ccw ? 90 : -90));
                c.f_19859_ = c.m_146908_();
                c.m_146884_(new Vec3((double)((float)pos.m_123341_() + 0.5f), c.m_20186_(), (double)pos.m_123343_() + 0.5));
                c.f_19790_ = c.m_20185_();
                c.f_19792_ = c.m_20189_();
                Vec3 movement = c.m_20184_();
                c.m_20256_(movement.m_82524_(ccw ? 1.5707964f : -1.5707964f));
            }
        }
    }

    private static Direction.Axis getMinecartMovementAxis(AbstractMinecart m) {
        Vec3 dir = Vec3.m_82498_((float)0.0f, (float)m.m_146908_());
        return Direction.m_122366_((double)dir.f_82479_, (double)dir.f_82480_, (double)dir.f_82481_).m_122434_();
    }

    private static Direction.Axis getRailAxis(RailShape rail) {
        return switch (rail) {
            case RailShape.EAST_WEST, RailShape.ASCENDING_WEST, RailShape.ASCENDING_EAST -> Direction.Axis.X;
            case RailShape.NORTH_SOUTH, RailShape.ASCENDING_SOUTH, RailShape.ASCENDING_NORTH -> Direction.Axis.Z;
            default -> Direction.Axis.Y;
        };
    }

    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        this.cooldown = compound.m_128451_("Cooldown");
        this.canRotate = compound.m_128471_("CanRotate");
    }

    public void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        compound.m_128405_("Cooldown", this.cooldown);
        compound.m_128379_("CanRotate", this.canRotate);
    }
}

