/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.tools;

import com.atsuishio.superbwarfare.entity.vehicle.base.VehicleEntity;
import com.mojang.math.Axis;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

public class VectorTool {
    public static double calculateAngle(Vec3 start, Vec3 end) {
        double startLength = start.m_82553_();
        double endLength = end.m_82553_();
        if (startLength > 0.0 && endLength > 0.0) {
            return Math.toDegrees(Math.acos(Mth.m_14008_((double)(start.m_82526_(end) / (startLength * endLength)), (double)-1.0, (double)1.0)));
        }
        return 0.0;
    }

    public static float calculateY(float x) {
        if (x < -90.0f) {
            return -(x + 180.0f) / 90.0f;
        }
        if (x <= 90.0f) {
            return x / 90.0f;
        }
        return (180.0f - x) / 90.0f;
    }

    public static Quaternionf combineRotations(float partialTicks, VehicleEntity entity) {
        Quaternionf yawRot = Axis.f_252436_.m_252977_(-Mth.m_14179_((float)partialTicks, (float)entity.f_19859_, (float)entity.m_146908_()));
        Quaternionf pitchRot = Axis.f_252529_.m_252977_(Mth.m_14179_((float)partialTicks, (float)entity.f_19860_, (float)entity.m_146909_()));
        Quaternionf rollRot = Axis.f_252403_.m_252977_(Mth.m_14179_((float)partialTicks, (float)entity.prevRoll, (float)entity.getRoll()));
        Quaternionf combined = new Quaternionf((Quaternionfc)yawRot);
        combined.mul((Quaternionfc)pitchRot);
        combined.mul((Quaternionfc)rollRot);
        return combined;
    }

    public static Quaternionf combineRotationsYaw(float partialTicks, VehicleEntity entity) {
        Quaternionf yawRot = Axis.f_252436_.m_252977_(-Mth.m_14179_((float)partialTicks, (float)entity.f_19859_, (float)entity.m_146908_()));
        return new Quaternionf((Quaternionfc)yawRot);
    }

    public static Quaternionf combineRotationsTurret(float partialTicks, VehicleEntity entity) {
        Quaternionf turretYawRot = Axis.f_252436_.m_252977_(Mth.m_14179_((float)partialTicks, (float)entity.turretYRotO, (float)entity.getTurretYRot()));
        Quaternionf combined = VectorTool.combineRotations(partialTicks, entity);
        combined.mul((Quaternionfc)turretYawRot);
        return combined;
    }

    public static Quaternionf combineRotationsBarrel(float partialTicks, VehicleEntity entity) {
        Quaternionf turretPitchRot = Axis.f_252529_.m_252977_(Mth.m_14179_((float)partialTicks, (float)entity.turretXRotO, (float)entity.getTurretXRot()));
        Quaternionf combined = VectorTool.combineRotationsTurret(partialTicks, entity);
        combined.mul((Quaternionfc)turretPitchRot);
        return combined;
    }

    public static Vec3 randomPos(Vec3 originPos, int radius) {
        return originPos.m_82549_(new Vec3(Math.random() * (double)radius, 0.0, 0.0).m_82524_((float)(360.0 * Math.random()) * ((float)Math.PI / 180)));
    }

    public static boolean isInLiquid(Level level, Vec3 position) {
        BlockPos blockPos = BlockPos.m_274446_((Position)position);
        FluidState fluidState = level.m_6425_(blockPos);
        if (!fluidState.m_76178_()) {
            float fluidHeight = fluidState.m_76155_((BlockGetter)level, blockPos);
            double yOffset = position.f_82480_ - (double)blockPos.m_123342_();
            return yOffset < (double)fluidHeight;
        }
        return false;
    }

    public static Vec3 calculateReflection(Vec3 v1, Vec3 v0) {
        double dot = v1.m_82526_(v0);
        return v1.m_82546_(v0.m_82490_(2.0 * dot));
    }

    public static Vec3 lerpGetEntityBoundingBoxCenter(Entity entity, float partialTick) {
        return new Vec3(Mth.m_14139_((double)partialTick, (double)entity.f_19854_, (double)entity.m_20185_()), Mth.m_14139_((double)partialTick, (double)(entity.f_19855_ + (double)(entity.m_20206_() / 2.0f)), (double)(entity.m_20186_() + (double)(entity.m_20206_() / 2.0f))), Mth.m_14139_((double)partialTick, (double)entity.f_19856_, (double)entity.m_20189_()));
    }
}

