/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.tools;

import com.atsuishio.superbwarfare.entity.OBBEntity;
import com.atsuishio.superbwarfare.tools.TraceTool;
import java.util.Optional;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Intersectionf;
import org.joml.Math;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector2f;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public record OBB(Vector3f center, Vector3f extents, Quaternionf rotation, Part part) {
    public void setCenter(Vector3f center) {
        this.center.set((Vector3fc)center);
    }

    public void setExtents(Vector3f extents) {
        this.extents.set((Vector3fc)extents);
    }

    public void setRotation(Quaternionf rotation) {
        this.rotation.set((Quaternionfc)rotation);
    }

    public Vector3f[] getVertices() {
        Vector3f[] vertices = new Vector3f[8];
        Vector3f[] localVertices = new Vector3f[]{new Vector3f(-this.extents.x, -this.extents.y, -this.extents.z), new Vector3f(this.extents.x, -this.extents.y, -this.extents.z), new Vector3f(this.extents.x, this.extents.y, -this.extents.z), new Vector3f(-this.extents.x, this.extents.y, -this.extents.z), new Vector3f(-this.extents.x, -this.extents.y, this.extents.z), new Vector3f(this.extents.x, -this.extents.y, this.extents.z), new Vector3f(this.extents.x, this.extents.y, this.extents.z), new Vector3f(-this.extents.x, this.extents.y, this.extents.z)};
        for (int i = 0; i < 8; ++i) {
            Vector3f vertex = localVertices[i];
            vertex.rotate((Quaternionfc)this.rotation);
            vertex.add((Vector3fc)this.center);
            vertices[i] = vertex;
        }
        return vertices;
    }

    public Vector3f[] getAxes() {
        Vector3f[] axes = new Vector3f[]{new Vector3f(1.0f, 0.0f, 0.0f), new Vector3f(0.0f, 1.0f, 0.0f), new Vector3f(0.0f, 0.0f, 1.0f)};
        this.rotation.transform(axes[0]);
        this.rotation.transform(axes[1]);
        this.rotation.transform(axes[2]);
        return axes;
    }

    public static boolean isColliding(OBB obb, OBB other) {
        Vector3f[] axes1 = obb.getAxes();
        Vector3f[] axes2 = other.getAxes();
        return Intersectionf.testObOb((Vector3f)obb.center(), (Vector3f)axes1[0], (Vector3f)axes1[1], (Vector3f)axes1[2], (Vector3f)obb.extents(), (Vector3f)other.center(), (Vector3f)axes2[0], (Vector3f)axes2[1], (Vector3f)axes2[2], (Vector3f)other.extents());
    }

    public static boolean isColliding(OBB obb, AABB aabb) {
        Vector3f obbCenter = obb.center();
        Vector3f[] obbAxes = obb.getAxes();
        Vector3f obbHalfExtents = obb.extents();
        Vector3f aabbCenter = aabb.m_82399_().m_252839_();
        Vector3f aabbHalfExtents = new Vector3f((float)(aabb.m_82362_() / 2.0), (float)(aabb.m_82376_() / 2.0), (float)(aabb.m_82385_() / 2.0));
        return Intersectionf.testObOb((float)obbCenter.x, (float)obbCenter.y, (float)obbCenter.z, (float)obbAxes[0].x, (float)obbAxes[0].y, (float)obbAxes[0].z, (float)obbAxes[1].x, (float)obbAxes[1].y, (float)obbAxes[1].z, (float)obbAxes[2].x, (float)obbAxes[2].y, (float)obbAxes[2].z, (float)obbHalfExtents.x, (float)obbHalfExtents.y, (float)obbHalfExtents.z, (float)aabbCenter.x, (float)aabbCenter.y, (float)aabbCenter.z, (float)1.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f, (float)aabbHalfExtents.x, (float)aabbHalfExtents.y, (float)aabbHalfExtents.z);
    }

    public static Vector3f getClosestPointOBB(Vector3f point, OBB obb) {
        Vector3f nearP = new Vector3f((Vector3fc)obb.center());
        Vector3f dist = point.sub((Vector3fc)nearP, new Vector3f());
        float[] extents = new float[]{obb.extents().x, obb.extents().y, obb.extents().z};
        Vector3f[] axes = obb.getAxes();
        for (int i = 0; i < 3; ++i) {
            float distance = dist.dot((Vector3fc)axes[i]);
            distance = Math.clamp((float)distance, (float)(-extents[i]), (float)extents[i]);
            nearP.x += distance * axes[i].x;
            nearP.y += distance * axes[i].y;
            nearP.z += distance * axes[i].z;
        }
        return nearP;
    }

    public Optional<Vector3f> clip(Vector3f pFrom, Vector3f pTo) {
        Vector3f[] axes = new Vector3f[]{this.rotation.transform(new Vector3f(1.0f, 0.0f, 0.0f)), this.rotation.transform(new Vector3f(0.0f, 1.0f, 0.0f)), this.rotation.transform(new Vector3f(0.0f, 0.0f, 1.0f))};
        Vector3f localFrom = this.worldToLocal(pFrom, axes);
        Vector3f localTo = this.worldToLocal(pTo, axes);
        Vector3f dir = new Vector3f((Vector3fc)localTo).sub((Vector3fc)localFrom);
        double tEnter = 0.0;
        double tExit = 1.0;
        for (int i = 0; i < 3; ++i) {
            double min = -this.extents.get(i);
            double max = this.extents.get(i);
            double origin = localFrom.get(i);
            double direction = dir.get(i);
            if (Math.abs((double)direction) < (double)1.0E-7f) {
                if (!(origin < min) && !(origin > max)) continue;
                return Optional.empty();
            }
            double t1 = (min - origin) / direction;
            double t2 = (max - origin) / direction;
            double tNear = Math.min((double)t1, (double)t2);
            double tFar = Math.max((double)t1, (double)t2);
            if (tNear > tEnter) {
                tEnter = tNear;
            }
            if (tFar < tExit) {
                tExit = tFar;
            }
            if (!(tEnter > tExit)) continue;
            return Optional.empty();
        }
        Vector3f localHit = new Vector3f((Vector3fc)dir).mul((float)tEnter).add((Vector3fc)localFrom);
        return Optional.of(this.localToWorld(localHit, axes));
    }

    private Vector3f worldToLocal(Vector3f worldPoint, Vector3f[] axes) {
        Vector3f rel = new Vector3f((Vector3fc)worldPoint).sub((Vector3fc)this.center);
        return new Vector3f(rel.dot((Vector3fc)axes[0]), rel.dot((Vector3fc)axes[1]), rel.dot((Vector3fc)axes[2]));
    }

    private Vector3f localToWorld(Vector3f localPoint, Vector3f[] axes) {
        Vector3f result = new Vector3f((Vector3fc)this.center);
        result.add((Vector3fc)axes[0].mul(localPoint.x, new Vector3f()));
        result.add((Vector3fc)axes[1].mul(localPoint.y, new Vector3f()));
        result.add((Vector3fc)axes[2].mul(localPoint.z, new Vector3f()));
        return result;
    }

    public OBB inflate(float amount) {
        Vector3f newExtents = new Vector3f((Vector3fc)this.extents).add(amount, amount, amount);
        return new OBB(this.center, newExtents, this.rotation, this.part);
    }

    public OBB inflate(float x, float y, float z) {
        Vector3f newExtents = new Vector3f((Vector3fc)this.extents).add(x, y, z);
        return new OBB(this.center, newExtents, this.rotation, this.part);
    }

    public OBB move(Vec3 vec3) {
        Vector3f newCenter = new Vector3f((float)((double)this.center.x + vec3.f_82479_), (float)((double)this.center.y + vec3.f_82480_), (float)((double)this.center.z + vec3.f_82481_));
        return new OBB(newCenter, this.extents, this.rotation, this.part);
    }

    public boolean contains(Vec3 vec3) {
        Vector3f rel = new Vector3f((Vector3fc)vec3.m_252839_()).sub((Vector3fc)this.center);
        Vector3f[] axes = new Vector3f[]{this.rotation.transform(new Vector3f(1.0f, 0.0f, 0.0f)), this.rotation.transform(new Vector3f(0.0f, 1.0f, 0.0f)), this.rotation.transform(new Vector3f(0.0f, 0.0f, 1.0f))};
        float projX = Math.abs((float)rel.dot((Vector3fc)axes[0]));
        float projY = Math.abs((float)rel.dot((Vector3fc)axes[1]));
        float projZ = Math.abs((float)rel.dot((Vector3fc)axes[2]));
        return projX <= this.extents.x && projY <= this.extents.y && projZ <= this.extents.z;
    }

    @Nullable
    public static OBB getLookingObb(Player player, double range) {
        Entity lookingEntity = TraceTool.findLookingEntity((Entity)player, range);
        if (!(lookingEntity instanceof OBBEntity)) {
            return null;
        }
        OBBEntity obbEntity = (OBBEntity)lookingEntity;
        Vec3 eyePos = player.m_20299_(1.0f);
        Vec3 viewVec = player.m_20252_(1.0f);
        Vec3 lookEnd = eyePos.m_82549_(viewVec.m_82490_(range));
        OBB closestOBB = null;
        double minDistanceSq = Double.MAX_VALUE;
        for (OBB obb : obbEntity.getOBBs()) {
            double distanceSq;
            Vec3 hitPos = OBB.rayIntersect(obb, eyePos, lookEnd);
            if (hitPos == null || !((distanceSq = eyePos.m_82557_(hitPos)) < minDistanceSq)) continue;
            minDistanceSq = distanceSq;
            closestOBB = obb;
        }
        return closestOBB;
    }

    @Nullable
    public static Vec3 rayIntersect(OBB obb, Vec3 start, Vec3 end) {
        Vec3 center = new Vec3(obb.center());
        Vec3 extents = new Vec3(obb.extents());
        Quaternionf rotation = obb.rotation();
        Quaternionf inverse = new Quaternionf((Quaternionfc)rotation).conjugate();
        Vector3f localStart = OBB.toLocal(obb, start);
        Vector3f localEnd = OBB.toLocal(obb, end);
        float minX = (float)(-extents.f_82479_);
        float minY = (float)(-extents.f_82480_);
        float minZ = (float)(-extents.f_82481_);
        float maxX = (float)extents.f_82479_;
        float maxY = (float)extents.f_82480_;
        float maxZ = (float)extents.f_82481_;
        Vector2f result = new Vector2f();
        boolean intersects = Intersectionf.intersectRayAab((float)localStart.x, (float)localStart.y, (float)localStart.z, (float)(localEnd.x - localStart.x), (float)(localEnd.y - localStart.y), (float)(localEnd.z - localStart.z), (float)minX, (float)minY, (float)minZ, (float)maxX, (float)maxY, (float)maxZ, (Vector2f)result);
        if (intersects) {
            float t = result.x;
            Vector3f localHit = new Vector3f(localStart.x + t * (localEnd.x - localStart.x), localStart.y + t * (localEnd.y - localStart.y), localStart.z + t * (localEnd.z - localStart.z));
            rotation.transform(localHit);
            return new Vec3((double)localHit.x + center.f_82479_, (double)localHit.y + center.f_82480_, (double)localHit.z + center.f_82481_);
        }
        return null;
    }

    private static Vector3f toLocal(OBB obb, Vec3 worldPoint) {
        Vec3 center = new Vec3(obb.center());
        Quaternionf rotation = obb.rotation();
        Quaternionf inverse = new Quaternionf((Quaternionfc)rotation).conjugate();
        Vector3f relative = new Vector3f((float)(worldPoint.f_82479_ - center.f_82479_), (float)(worldPoint.f_82480_ - center.f_82480_), (float)(worldPoint.f_82481_ - center.f_82481_));
        inverse.transform(relative);
        return relative;
    }

    public static enum Part {
        EMPTY,
        WHEEL_LEFT,
        WHEEL_RIGHT,
        TURRET,
        ENGINE1,
        ENGINE2,
        BODY,
        INTERACTIVE;

    }
}

