/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.perk.functional;

import com.atsuishio.superbwarfare.data.gun.GunData;
import com.atsuishio.superbwarfare.init.ModPerks;
import com.atsuishio.superbwarfare.item.gun.GunItem;
import com.atsuishio.superbwarfare.perk.Perk;
import com.atsuishio.superbwarfare.tools.DamageTypeTool;
import java.util.Collection;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingExperienceDropEvent;
import net.minecraftforge.event.entity.living.LootingLevelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class PowerfulAttraction
extends Perk {
    public PowerfulAttraction() {
        super("powerful_attraction", Perk.Type.FUNCTIONAL);
    }

    @SubscribeEvent
    public static void onLivingDrops(LivingDropsEvent event) {
        DamageSource source = event.getSource();
        if (source == null) {
            return;
        }
        Entity sourceEntity = source.m_7639_();
        if (!(sourceEntity instanceof LivingEntity)) {
            return;
        }
        LivingEntity living = (LivingEntity)sourceEntity;
        ItemStack stack = living.m_21205_();
        if (!(stack.m_41720_() instanceof GunItem)) {
            return;
        }
        short level = GunData.from((ItemStack)stack).perk.getLevel(ModPerks.POWERFUL_ATTRACTION);
        if (level > 0 && (DamageTypeTool.isGunDamage(source) || DamageTypeTool.isExplosionDamage(source))) {
            Collection drops = event.getDrops();
            drops.forEach(itemEntity -> {
                ItemStack item = itemEntity.m_32055_();
                living.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(cap -> {
                    for (int i = 0; i < cap.getSlots(); ++i) {
                        ItemEntity entity;
                        ItemStack insertedStack;
                        int inserted;
                        for (inserted = item.m_41613_(); inserted > 0 && (insertedStack = cap.insertItem(i, item.m_255036_(inserted), true)).m_41613_() == inserted && ItemStack.m_150942_((ItemStack)insertedStack, (ItemStack)item); --inserted) {
                        }
                        if (inserted > 0) {
                            cap.insertItem(i, item.m_255036_(inserted), false);
                            item.m_41774_(inserted);
                            if (item.m_41619_()) continue;
                            entity = new ItemEntity(living.m_9236_(), living.m_20185_(), living.m_20186_(), living.m_20189_(), item);
                            entity.m_32010_(10);
                            living.m_9236_().m_7967_((Entity)entity);
                            continue;
                        }
                        entity = new ItemEntity(living.m_9236_(), living.m_20185_(), living.m_20186_(), living.m_20189_(), item);
                        entity.m_32010_(10);
                        living.m_9236_().m_7967_((Entity)entity);
                    }
                });
            });
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onLivingExperienceDrop(LivingExperienceDropEvent event) {
        Player player = event.getAttackingPlayer();
        if (player == null) {
            return;
        }
        ItemStack stack = player.m_21205_();
        if (!(stack.m_41720_() instanceof GunItem)) {
            return;
        }
        short level = GunData.from((ItemStack)stack).perk.getLevel(ModPerks.POWERFUL_ATTRACTION);
        if (level > 0) {
            player.m_6756_((int)((float)event.getDroppedExperience() * (0.8f + 0.2f * (float)level)));
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onLootingLevel(LootingLevelEvent event) {
        DamageSource source = event.getDamageSource();
        if (source == null) {
            return;
        }
        Entity sourceEntity = source.m_7639_();
        if (!(sourceEntity instanceof LivingEntity)) {
            return;
        }
        LivingEntity living = (LivingEntity)sourceEntity;
        ItemStack stack = living.m_21205_();
        if (!(stack.m_41720_() instanceof GunItem)) {
            return;
        }
        short level = GunData.from((ItemStack)stack).perk.getLevel(ModPerks.POWERFUL_ATTRACTION);
        if (level > 0 && (DamageTypeTool.isGunDamage(source) || DamageTypeTool.isExplosionDamage(source))) {
            event.setLootingLevel(level / 4);
        }
    }
}

