/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.network.message.send;

import com.atsuishio.superbwarfare.entity.vehicle.base.ControllableVehicle;
import com.atsuishio.superbwarfare.entity.vehicle.base.MobileVehicleEntity;
import com.atsuishio.superbwarfare.init.ModItems;
import com.atsuishio.superbwarfare.tools.EntityFindUtil;
import com.atsuishio.superbwarfare.tools.ItemNBTTool;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;

public record VehicleMovementMessage(short keys) {
    public static VehicleMovementMessage decode(FriendlyByteBuf buffer) {
        return new VehicleMovementMessage(buffer.readShort());
    }

    public static void encode(VehicleMovementMessage message, FriendlyByteBuf buffer) {
        buffer.writeShort((int)message.keys);
    }

    public static void handler(VehicleMovementMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            if (context.getSender() != null) {
                MobileVehicleEntity mobileVehicleEntity;
                ServerPlayer player = context.getSender();
                Entity entity = player.m_20202_();
                ItemStack stack = player.m_21205_();
                MobileVehicleEntity vehicle = null;
                if (entity instanceof MobileVehicleEntity && (mobileVehicleEntity = (MobileVehicleEntity)entity).m_146895_() == player) {
                    vehicle = mobileVehicleEntity;
                } else if (stack.m_150930_((Item)ModItems.MONITOR.get()) && ItemNBTTool.getBoolean(stack, "Using", false) && ItemNBTTool.getBoolean(stack, "Linked", false)) {
                    vehicle = EntityFindUtil.findDrone(player.m_9236_(), stack.m_41784_().m_128461_("LinkedDrone"));
                }
                if (!(vehicle instanceof ControllableVehicle)) {
                    return;
                }
                ControllableVehicle controllable = vehicle;
                controllable.processInput(message.keys);
            }
        });
        context.setPacketHandled(true);
    }
}

