/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.network.message.receive;

import com.atsuishio.superbwarfare.network.ClientPacketHandler;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;

public record LivingGunKillMessage(int attackerId, int targetId, boolean headshot, ResourceKey<DamageType> damageType) {
    public static void encode(LivingGunKillMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.attackerId);
        buffer.writeInt(message.targetId);
        buffer.writeBoolean(message.headshot);
        buffer.m_236858_(message.damageType);
    }

    public static LivingGunKillMessage decode(FriendlyByteBuf buffer) {
        int attackerId = buffer.readInt();
        int targetId = buffer.readInt();
        boolean headshot = buffer.readBoolean();
        ResourceKey damageType = buffer.m_236801_(Registries.f_268580_);
        return new LivingGunKillMessage(attackerId, targetId, headshot, (ResourceKey<DamageType>)damageType);
    }

    public static void handler(LivingGunKillMessage message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ClientLevel level = Minecraft.m_91087_().f_91073_;
            if (level != null) {
                OwnableEntity ownableEntity;
                Player player;
                LivingEntity living;
                Entity entity = level.m_6815_(message.attackerId);
                Object attacker = entity instanceof LivingEntity ? ((living = (LivingEntity)entity) instanceof Player ? (player = (Player)living) : (living instanceof OwnableEntity && (ownableEntity = (OwnableEntity)living).m_269323_() instanceof Player ? living : null)) : null;
                Entity target = level.m_6815_(message.targetId);
                if (attacker != null && target != null) {
                    DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> LivingGunKillMessage.lambda$handler$1((LivingEntity)attacker, target, message, (Supplier)ctx));
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }

    private static /* synthetic */ Runnable lambda$handler$1(LivingEntity attacker, Entity target, LivingGunKillMessage message, Supplier ctx) {
        return () -> LivingGunKillMessage.lambda$handler$0(attacker, target, message, (Supplier)ctx);
    }

    private static /* synthetic */ void lambda$handler$0(LivingEntity attacker, Entity target, LivingGunKillMessage message, Supplier ctx) {
        ClientPacketHandler.handleLivingKillMessage(attacker, target, message.headshot, message.damageType, ctx);
    }
}

