/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.mobeffect;

import com.atsuishio.superbwarfare.Mod;
import com.atsuishio.superbwarfare.init.ModDamageTypes;
import com.atsuishio.superbwarfare.init.ModMobEffects;
import com.atsuishio.superbwarfare.init.ModSounds;
import com.atsuishio.superbwarfare.network.message.receive.ClientIndicatorMessage;
import com.atsuishio.superbwarfare.tools.DamageHandler;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.MobEffectEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.PacketDistributor;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ShockMobEffect
extends MobEffect {
    public ShockMobEffect() {
        super(MobEffectCategory.HARMFUL, -256);
        this.m_19472_(Attributes.f_22279_, "7107DE5E-7CE8-4030-940E-514C1F160890", -10.0, AttributeModifier.Operation.ADDITION);
    }

    public void m_6742_(LivingEntity entity, int amplifier) {
        Entity attacker = !entity.getPersistentData().m_128441_("TargetShockAttacker") ? null : entity.m_9236_().m_6815_(entity.getPersistentData().m_128451_("TargetShockAttacker"));
        DamageHandler.doDamage((Entity)entity, ModDamageTypes.causeShockDamage(entity.m_9236_().m_9598_(), attacker), 2.0f + 1.25f * (float)amplifier);
        entity.m_9236_().m_5594_(null, entity.m_20097_(), (SoundEvent)ModSounds.ELECTRIC.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
        if (attacker instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)attacker;
            player.m_9236_().m_5594_(null, player.m_20183_(), (SoundEvent)ModSounds.INDICATION.get(), SoundSource.VOICE, 1.0f, 1.0f);
            Mod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> player), (Object)new ClientIndicatorMessage(0, 5));
        }
    }

    public boolean m_6584_(int duration, int amplifier) {
        return duration % 20 == 0;
    }

    @SubscribeEvent
    public static void onEffectAdded(MobEffectEvent.Added event) {
        LivingEntity living = event.getEntity();
        MobEffectInstance instance = event.getEffectInstance();
        if (!instance.m_19544_().equals(ModMobEffects.SHOCK.get())) {
            return;
        }
        if (living instanceof Player) {
            if (!living.m_9236_().m_5776_()) {
                living.m_9236_().m_5594_(null, BlockPos.m_274561_((double)living.m_20185_(), (double)living.m_20186_(), (double)living.m_20189_()), (SoundEvent)ModSounds.SHOCK.get(), SoundSource.HOSTILE, 1.0f, 1.0f);
            } else {
                living.m_9236_().m_7785_(living.m_20185_(), living.m_20186_(), living.m_20189_(), (SoundEvent)ModSounds.SHOCK.get(), SoundSource.HOSTILE, 1.0f, 1.0f, false);
            }
        }
        DamageHandler.doDamage((Entity)living, ModDamageTypes.causeShockDamage(living.m_9236_().m_9598_(), event.getEffectSource()), 2.0f + 1.25f * (float)instance.m_19564_());
        Entity entity = event.getEffectSource();
        if (entity instanceof LivingEntity) {
            LivingEntity source = (LivingEntity)entity;
            living.getPersistentData().m_128405_("TargetShockAttacker", source.m_19879_());
        }
    }

    @SubscribeEvent
    public static void onEffectExpired(MobEffectEvent.Expired event) {
        LivingEntity living = event.getEntity();
        MobEffectInstance instance = event.getEffectInstance();
        if (instance == null) {
            return;
        }
        if (instance.m_19544_().equals(ModMobEffects.SHOCK.get())) {
            living.getPersistentData().m_128473_("TargetShockAttacker");
        }
    }

    @SubscribeEvent
    public static void onEffectRemoved(MobEffectEvent.Remove event) {
        LivingEntity living = event.getEntity();
        MobEffectInstance instance = event.getEffectInstance();
        if (instance == null) {
            return;
        }
        if (instance.m_19544_().equals(ModMobEffects.SHOCK.get())) {
            living.getPersistentData().m_128473_("TargetShockAttacker");
        }
    }

    @SubscribeEvent
    public static void onLivingTick(LivingEvent.LivingTickEvent event) {
        LivingEntity living = event.getEntity();
        if (living.m_21023_((MobEffect)ModMobEffects.SHOCK.get())) {
            living.m_146926_((float)Mth.m_216263_((RandomSource)RandomSource.m_216327_(), (double)-23.0, (double)-36.0));
            living.f_19860_ = living.m_146909_();
        }
    }

    @SubscribeEvent
    public static void onEntityAttacked(LivingAttackEvent event) {
        LivingEntity living;
        if (event == null || event.getEntity() == null) {
            return;
        }
        DamageSource source = event.getSource();
        Entity entity = source.m_7640_();
        if (entity == null) {
            return;
        }
        if (entity instanceof LivingEntity && (living = (LivingEntity)entity).m_21023_((MobEffect)ModMobEffects.SHOCK.get())) {
            event.setCanceled(true);
        }
    }
}

