/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.menu;

import com.atsuishio.superbwarfare.data.gun.GunData;
import com.atsuishio.superbwarfare.data.gun.subdata.Perks;
import com.atsuishio.superbwarfare.init.ModBlocks;
import com.atsuishio.superbwarfare.init.ModMenuTypes;
import com.atsuishio.superbwarfare.item.PerkItem;
import com.atsuishio.superbwarfare.item.gun.GunItem;
import com.atsuishio.superbwarfare.perk.Perk;
import com.atsuishio.superbwarfare.perk.PerkInstance;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;

public class ReforgingTableMenu
extends AbstractContainerMenu {
    protected final Container container;
    protected final ContainerLevelAccess access;
    public static final int INPUT_SLOT = 0;
    public static final int AMMO_PERK_SLOT = 1;
    public static final int FUNC_PERK_SLOT = 2;
    public static final int DAMAGE_PERK_SLOT = 3;
    public static final int RESULT_SLOT = 4;
    public static final int MAX_PERK_LEVEL = 20;
    public static final int MAX_UPGRADE_POINT = 100;
    public final DataSlot ammoPerkLevel = DataSlot.m_39401_();
    public final DataSlot funcPerkLevel = DataSlot.m_39401_();
    public final DataSlot damagePerkLevel = DataSlot.m_39401_();
    public final DataSlot upgradePoint = DataSlot.m_39401_();
    public static final int X_OFFSET = 0;
    public static final int Y_OFFSET = 11;

    public ReforgingTableMenu(int pContainerId, Inventory pPlayerInventory) {
        this(pContainerId, pPlayerInventory, (Container)new SimpleContainer(5), ContainerLevelAccess.f_39287_);
    }

    public ReforgingTableMenu(int pContainerId, Inventory pPlayerInventory, ContainerLevelAccess access) {
        this(pContainerId, pPlayerInventory, (Container)new SimpleContainer(5), access);
    }

    public ReforgingTableMenu(int pContainerId, Inventory inventory, Container container, ContainerLevelAccess pContainerLevelAccess) {
        super((MenuType)ModMenuTypes.REFORGING_TABLE_MENU.get(), pContainerId);
        ReforgingTableMenu.m_38869_((Container)container, (int)5);
        this.container = container;
        this.access = pContainerLevelAccess;
        this.ammoPerkLevel.m_6422_(0);
        this.funcPerkLevel.m_6422_(0);
        this.damagePerkLevel.m_6422_(0);
        this.upgradePoint.m_6422_(0);
        this.m_38895_(this.ammoPerkLevel);
        this.m_38895_(this.funcPerkLevel);
        this.m_38895_(this.damagePerkLevel);
        this.m_38895_(this.upgradePoint);
        this.m_38897_(new InputSlot(container, 0, 20, 22));
        this.m_38897_(new PerkSlot(container, 1, Perk.Type.AMMO, 80, 25));
        this.m_38897_(new PerkSlot(container, 2, Perk.Type.FUNCTIONAL, 80, 45));
        this.m_38897_(new PerkSlot(container, 3, Perk.Type.DAMAGE, 80, 65));
        this.m_38897_(new ResultSlot(container, 4, 142, 45));
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.m_38897_(new Slot((Container)inventory, j + i * 9 + 9, 8 + j * 18 + 0, 84 + i * 18 + 11));
            }
        }
        for (int k = 0; k < 9; ++k) {
            this.m_38897_(new Slot((Container)inventory, k, 8 + k * 18 + 0, 153));
        }
    }

    @NotNull
    public ItemStack m_7648_(@NotNull Player pPlayer, int pIndex) {
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(pIndex);
        if (slot.m_6657_()) {
            ItemStack stack = slot.m_7993_();
            itemstack = stack.m_41777_();
            if (pIndex == 0) {
                this.onTakeGun(stack);
                if (!this.m_38903_(stack, 5, 41, false)) {
                    return ItemStack.f_41583_;
                }
            } else if (pIndex >= 1 && pIndex <= 3) {
                this.onTakePerk(stack);
                if (!this.m_38903_(stack, 5, 41, false)) {
                    return ItemStack.f_41583_;
                }
            } else if (pIndex == 4) {
                if (!this.m_38903_(stack, 4, 40, false)) {
                    return ItemStack.f_41583_;
                }
            } else if (stack.m_41720_() instanceof GunItem) {
                if (!this.m_38903_(stack, 0, 1, false)) {
                    return ItemStack.f_41583_;
                }
            } else {
                Item item = stack.m_41720_();
                if (item instanceof PerkItem) {
                    PerkItem perkItem = (PerkItem)item;
                    Perk.Type type = perkItem.getPerk().type;
                    if (type == Perk.Type.AMMO ? !this.m_38903_(stack, 1, 2, false) : (type == Perk.Type.FUNCTIONAL ? !this.m_38903_(stack, 2, 3, false) : type == Perk.Type.DAMAGE && !this.m_38903_(stack, 3, 4, false))) {
                        return ItemStack.f_41583_;
                    }
                }
            }
            if (stack.m_41619_()) {
                slot.m_269060_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (stack.m_41613_() == itemstack.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(pPlayer, stack);
        }
        return itemstack;
    }

    public boolean m_6875_(@NotNull Player pPlayer) {
        return (Boolean)this.access.m_39299_((level, pos) -> level.m_8055_(pos).m_60713_((Block)ModBlocks.REFORGING_TABLE.get()) && pPlayer.m_20275_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5) <= 64.0, (Object)true);
    }

    public void m_6877_(@NotNull Player pPlayer) {
        this.access.m_39292_((level, pos) -> {
            ItemStack gun = this.container.m_8020_(0);
            ItemStack copy = gun.m_41777_();
            for (int i = 0; i < this.container.m_6643_(); ++i) {
                Item patt7072$temp;
                ItemStack itemstack = this.container.m_8020_(i);
                if (copy.m_41720_() instanceof GunItem && (patt7072$temp = itemstack.m_41720_()) instanceof PerkItem) {
                    PerkItem perkItem = (PerkItem)patt7072$temp;
                    if (!copy.m_41619_() && GunData.from((ItemStack)copy).perk.getLevel(perkItem) > 0) continue;
                }
                if (itemstack.m_41720_() instanceof GunItem) {
                    GunData data = GunData.from(itemstack);
                    data.upgradePoint.set(Math.min(100, this.upgradePoint.m_6501_()));
                }
                if (!itemstack.m_41619_()) {
                    pPlayer.m_150109_().m_150079_(itemstack);
                }
                this.container.m_8016_(i);
            }
        });
    }

    public void setPerkLevel(Perk.Type type, boolean upgrade, boolean isCreative) {
        if (upgrade && this.upgradePoint.m_6501_() <= 0 && !isCreative) {
            return;
        }
        if (!upgrade && this.upgradePoint.m_6501_() >= 100 && !isCreative) {
            return;
        }
        switch (type) {
            case AMMO: {
                this.ammoPerkLevel.m_6422_(upgrade ? Math.min(20, this.ammoPerkLevel.m_6501_() + 1) : Math.max(1, this.ammoPerkLevel.m_6501_() - 1));
                break;
            }
            case FUNCTIONAL: {
                this.funcPerkLevel.m_6422_(upgrade ? Math.min(20, this.funcPerkLevel.m_6501_() + 1) : Math.max(1, this.funcPerkLevel.m_6501_() - 1));
                break;
            }
            case DAMAGE: {
                this.damagePerkLevel.m_6422_(upgrade ? Math.min(20, this.damagePerkLevel.m_6501_() + 1) : Math.max(1, this.damagePerkLevel.m_6501_() - 1));
            }
        }
        if (!isCreative) {
            this.upgradePoint.m_6422_(Mth.m_14045_((int)(this.upgradePoint.m_6501_() + (upgrade ? -1 : 1)), (int)0, (int)100));
        }
    }

    public void handleUpgradePoint(ItemStack stack) {
        if (!(stack.m_41720_() instanceof GunItem)) {
            return;
        }
        GunData data = GunData.from(stack);
        double oldPoint = data.upgradePoint.get();
        int point = (int)oldPoint;
        int newPoint = this.upgradePoint.m_6501_();
        int delta = newPoint - point;
        if (delta != 0) {
            data.upgradePoint.set(oldPoint + (double)delta);
        }
    }

    public void generateResult() {
        ItemStack gun = this.container.m_8020_(0);
        if (!(gun.m_41720_() instanceof GunItem)) {
            return;
        }
        ItemStack ammo = this.container.m_8020_(1);
        ItemStack func = this.container.m_8020_(2);
        ItemStack damage = this.container.m_8020_(3);
        if (ammo.m_41619_() && func.m_41619_() && damage.m_41619_()) {
            return;
        }
        ItemStack result = gun.m_41777_();
        GunData data = GunData.from(result);
        List.of(ammo, func, damage).forEach(item -> {
            Item patt10027$temp;
            if (!item.m_41619_() && (patt10027$temp = item.m_41720_()) instanceof PerkItem) {
                PerkItem perkItem = (PerkItem)patt10027$temp;
                if (GunData.from(this.container.m_8020_(0)).canApplyPerk(perkItem.getPerk())) {
                    Perks perks = data.perk;
                    Perk perk = perkItem.getPerk();
                    perks.set(new PerkInstance(perk, switch (perkItem.getPerk().type) {
                        default -> throw new IncompatibleClassChangeError();
                        case Perk.Type.AMMO -> (short)this.ammoPerkLevel.m_6501_();
                        case Perk.Type.FUNCTIONAL -> (short)this.funcPerkLevel.m_6501_();
                        case Perk.Type.DAMAGE -> (short)this.damagePerkLevel.m_6501_();
                    }));
                    this.container.m_6836_(switch (perkItem.getPerk().type) {
                        default -> throw new IncompatibleClassChangeError();
                        case Perk.Type.AMMO -> 1;
                        case Perk.Type.FUNCTIONAL -> 2;
                        case Perk.Type.DAMAGE -> 3;
                    }, ItemStack.f_41583_);
                }
            }
        });
        this.handleUpgradePoint(result);
        this.ammoPerkLevel.m_6422_(0);
        this.funcPerkLevel.m_6422_(0);
        this.damagePerkLevel.m_6422_(0);
        this.upgradePoint.m_6422_(0);
        this.container.m_6836_(0, ItemStack.f_41583_);
        this.container.m_6836_(4, result);
        this.container.m_6596_();
    }

    private void onTakePerk(ItemStack perk) {
        ItemStack gun = this.container.m_8020_(0);
        if (!(gun.m_41720_() instanceof GunItem)) {
            return;
        }
        Item item = perk.m_41720_();
        if (item instanceof PerkItem) {
            PerkItem perkItem = (PerkItem)item;
            switch (perkItem.getPerk().type) {
                case AMMO: {
                    this.ammoPerkLevel.m_6422_(0);
                    break;
                }
                case FUNCTIONAL: {
                    this.funcPerkLevel.m_6422_(0);
                    break;
                }
                case DAMAGE: {
                    this.damagePerkLevel.m_6422_(0);
                }
            }
            GunData inputData = GunData.from(gun);
            short level = inputData.perk.getLevel(perkItem);
            if (level <= 0) {
                this.upgradePoint.m_6422_((int)inputData.upgradePoint.get());
                return;
            }
            ItemStack output = gun.m_41777_();
            GunData outputData = GunData.from(output);
            outputData.perk.remove(perkItem.getPerk());
            inputData.upgradePoint.set(Math.min(100.0, (double)(level - 1) + inputData.upgradePoint.get()));
            this.upgradePoint.m_6422_((int)inputData.upgradePoint.get());
            this.container.m_6836_(0, output);
            this.container.m_6596_();
        }
    }

    private void onPlacePerk(ItemStack pStack) {
        Item item = pStack.m_41720_();
        if (!(item instanceof PerkItem)) {
            return;
        }
        PerkItem perkItem = (PerkItem)item;
        switch (perkItem.getPerk().type) {
            case AMMO: {
                this.ammoPerkLevel.m_6422_(1);
                break;
            }
            case FUNCTIONAL: {
                this.funcPerkLevel.m_6422_(1);
                break;
            }
            case DAMAGE: {
                this.damagePerkLevel.m_6422_(1);
            }
        }
    }

    private void onPlaceGun(ItemStack stack) {
        if (!(stack.m_41720_() instanceof GunItem)) {
            return;
        }
        GunData data = GunData.from(stack);
        int point = (int)data.upgradePoint.get();
        this.upgradePoint.m_6422_(Mth.m_14045_((int)point, (int)0, (int)100));
        for (Perk.Type type : Perk.Type.values()) {
            PerkInstance perkInstance = data.perk.getInstance(type);
            if (perkInstance == null) continue;
            switch (type) {
                case AMMO: {
                    this.ammoPerkLevel.m_6422_((int)perkInstance.level());
                    break;
                }
                case FUNCTIONAL: {
                    this.funcPerkLevel.m_6422_((int)perkInstance.level());
                    break;
                }
                case DAMAGE: {
                    this.damagePerkLevel.m_6422_((int)perkInstance.level());
                }
            }
            Item ammoPerkItem = (Item)perkInstance.perk().getItem().get();
            this.container.m_6836_(switch (type) {
                default -> throw new IncompatibleClassChangeError();
                case Perk.Type.AMMO -> 1;
                case Perk.Type.FUNCTIONAL -> 2;
                case Perk.Type.DAMAGE -> 3;
            }, ammoPerkItem.m_7968_());
        }
        this.container.m_6596_();
        this.m_38946_();
    }

    private void onTakeGun(ItemStack stack) {
        ItemStack damage;
        ItemStack func;
        if (!(stack.m_41720_() instanceof GunItem)) {
            return;
        }
        GunData data = GunData.from(stack);
        for (Perk.Type type : Perk.Type.values()) {
            PerkItem perkItem;
            Item item;
            int slot;
            Perk perk = data.perk.get(type);
            switch (type) {
                default: {
                    throw new IncompatibleClassChangeError();
                }
                case AMMO: {
                    int n = 1;
                    break;
                }
                case FUNCTIONAL: {
                    int n = 2;
                    break;
                }
                case DAMAGE: {
                    int n = slot = 3;
                }
            }
            if (perk == null || !((item = this.container.m_8020_(slot).m_41720_()) instanceof PerkItem) || (perkItem = (PerkItem)item).getPerk() != perk) continue;
            this.container.m_6836_(slot, ItemStack.f_41583_);
        }
        data.upgradePoint.set(Math.min(100, this.upgradePoint.m_6501_()));
        this.upgradePoint.m_6422_(0);
        this.ammoPerkLevel.m_6422_(0);
        this.funcPerkLevel.m_6422_(0);
        this.damagePerkLevel.m_6422_(0);
        ItemStack ammo = this.container.m_8020_(1);
        if (ammo != ItemStack.f_41583_) {
            this.m_38903_(ammo, 5, 41, false);
        }
        if ((func = this.container.m_8020_(2)) != ItemStack.f_41583_) {
            this.m_38903_(func, 5, 41, false);
        }
        if ((damage = this.container.m_8020_(3)) != ItemStack.f_41583_) {
            this.m_38903_(damage, 5, 41, false);
        }
        this.container.m_6596_();
    }

    @Nullable
    public ItemStack getPerkItemBySlot(Perk.Type type) {
        return switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case Perk.Type.AMMO -> this.container.m_8020_(1);
            case Perk.Type.FUNCTIONAL -> this.container.m_8020_(2);
            case Perk.Type.DAMAGE -> this.container.m_8020_(3);
        };
    }

    class InputSlot
    extends Slot {
        public InputSlot(Container pContainer, int pSlot, int pX, int pY) {
            super(pContainer, pSlot, pX, pY);
        }

        public boolean m_5857_(ItemStack pStack) {
            if (pStack.m_41720_() instanceof GunItem) {
                ItemStack ammoPerk = this.f_40218_.m_8020_(1);
                ItemStack funcPerk = this.f_40218_.m_8020_(2);
                ItemStack damagePerk = this.f_40218_.m_8020_(3);
                boolean flag1 = ammoPerk.m_41619_();
                boolean flag2 = funcPerk.m_41619_();
                boolean flag3 = damagePerk.m_41619_();
                return flag1 && flag2 && flag3 && this.f_40218_.m_8020_(4).m_41619_() && this.f_40218_.m_8020_(0).m_41619_();
            }
            return false;
        }

        public int m_6641_() {
            return 1;
        }

        public void m_142406_(@NotNull Player pPlayer, @NotNull ItemStack pStack) {
            super.m_142406_(pPlayer, pStack);
            ReforgingTableMenu.this.onTakeGun(pStack);
        }

        public void m_269060_(@NotNull ItemStack pStack) {
            ReforgingTableMenu.this.onPlaceGun(pStack);
            super.m_269060_(pStack);
        }
    }

    class PerkSlot
    extends Slot {
        public Perk.Type type;

        public PerkSlot(Container pContainer, int pSlot, Perk.Type type, int pX, int pY) {
            super(pContainer, pSlot, pX, pY);
            this.type = type;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean m_5857_(@NotNull ItemStack pStack) {
            int slot = switch (this.type) {
                default -> throw new IncompatibleClassChangeError();
                case Perk.Type.AMMO -> 1;
                case Perk.Type.FUNCTIONAL -> 2;
                case Perk.Type.DAMAGE -> 3;
            };
            Item item = pStack.m_41720_();
            if (!(item instanceof PerkItem)) return false;
            PerkItem perkItem = (PerkItem)item;
            if (perkItem.getPerk().type != this.type) return false;
            if (this.f_40218_.m_8020_(0).m_41619_()) return false;
            if (!(this.f_40218_.m_8020_(0).m_41720_() instanceof GunItem)) return false;
            if (!GunData.from(this.f_40218_.m_8020_(0)).canApplyPerk(perkItem.getPerk())) return false;
            if (!this.f_40218_.m_8020_(slot).m_41619_()) return false;
            return true;
        }

        public int m_6641_() {
            return 1;
        }

        public void m_142406_(Player pPlayer, ItemStack pStack) {
            ReforgingTableMenu.this.onTakePerk(pStack);
            super.m_142406_(pPlayer, pStack);
        }

        public void m_269060_(ItemStack pStack) {
            ReforgingTableMenu.this.onPlacePerk(pStack);
            super.m_269060_(pStack);
        }
    }

    static class ResultSlot
    extends Slot {
        public ResultSlot(Container pContainer, int pSlot, int pX, int pY) {
            super(pContainer, pSlot, pX, pY);
        }

        public boolean m_5857_(ItemStack pStack) {
            return false;
        }

        public int m_6641_() {
            return 1;
        }
    }
}

