/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.item.gun.launcher;

import com.atsuishio.superbwarfare.Mod;
import com.atsuishio.superbwarfare.client.renderer.gun.IglaItemRenderer;
import com.atsuishio.superbwarfare.data.gun.GunData;
import com.atsuishio.superbwarfare.data.gun.GunProp;
import com.atsuishio.superbwarfare.entity.projectile.IglaMissileEntity;
import com.atsuishio.superbwarfare.entity.vehicle.base.VehicleEntity;
import com.atsuishio.superbwarfare.init.ModSounds;
import com.atsuishio.superbwarfare.init.ModTags;
import com.atsuishio.superbwarfare.item.gun.GunItem;
import com.atsuishio.superbwarfare.network.message.receive.ShootClientMessage;
import com.atsuishio.superbwarfare.perk.Perk;
import com.atsuishio.superbwarfare.perk.PerkInstance;
import com.atsuishio.superbwarfare.tools.EntityFindUtil;
import com.atsuishio.superbwarfare.tools.ParticleTool;
import com.atsuishio.superbwarfare.tools.SeekTool;
import com.atsuishio.superbwarfare.tools.SoundTool;
import com.atsuishio.superbwarfare.tools.VectorTool;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.function.Supplier;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundStopSoundPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Pig;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3d;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.renderer.GeoItemRenderer;

public class IglaItem
extends GunItem {
    public IglaItem() {
        super(new Item.Properties().m_41497_(Rarity.EPIC));
    }

    @Override
    public Supplier<? extends GeoItemRenderer<? extends Item>> getRenderer() {
        return IglaItemRenderer::new;
    }

    private PlayState idlePredicate(AnimationState<IglaItem> event) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return PlayState.STOP;
        }
        ItemStack stack = player.m_21205_();
        if (!(stack.m_41720_() instanceof GunItem)) {
            return PlayState.STOP;
        }
        if (event.getData(DataTickets.ITEM_RENDER_PERSPECTIVE) != ItemDisplayContext.FIRST_PERSON_RIGHT_HAND) {
            return event.setAndContinue(RawAnimation.begin().thenLoop("animation.igla_9k38.idle"));
        }
        if (GunData.from((ItemStack)stack).reload.empty()) {
            return event.setAndContinue(RawAnimation.begin().thenPlay("animation.igla_9k38.reload"));
        }
        return event.setAndContinue(RawAnimation.begin().thenLoop("animation.igla_9k38.idle"));
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
        AnimationController idleController = new AnimationController((GeoAnimatable)this, "idleController", 0, this::idlePredicate);
        data.add(new AnimationController[]{idleController});
    }

    @Override
    public Set<SoundEvent> getReloadSound() {
        return Set.of((SoundEvent)ModSounds.IGLA_RELOAD_EMPTY.get(), (SoundEvent)ModSounds.IGLA_LOCK.get(), (SoundEvent)ModSounds.IGLA_LOCKON.get());
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @ParametersAreNonnullByDefault
    public void m_6883_(ItemStack stack, Level world, Entity entity, int slot, boolean selected) {
        super.m_6883_(stack, world, entity, slot, selected);
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (selected) {
                GunData data;
                CompoundTag tag = stack.m_41784_();
                if (tag.m_128471_("Seeking")) {
                    Entity seekingEntity;
                    ServerPlayer serverPlayer;
                    List<Entity> decoy = SeekTool.seekLivingEntities((Entity)player, player.m_9236_(), 512.0, 20.0);
                    for (Entity e : decoy) {
                        if (!e.m_6095_().m_204039_(ModTags.EntityTypes.DECOY)) continue;
                        tag.m_128359_("TargetEntity", e.m_20149_());
                        tag.m_128347_("TargetPosX", e.m_20182_().f_82479_);
                        tag.m_128347_("TargetPosY", e.m_20182_().f_82480_);
                        tag.m_128347_("TargetPosZ", e.m_20182_().f_82481_);
                    }
                    Entity targetEntity = EntityFindUtil.findEntity(player.m_9236_(), tag.m_128461_("TargetEntity"));
                    if (targetEntity != null && VectorTool.calculateAngle(player.m_20252_(1.0f), player.m_146892_().m_82505_(targetEntity.m_20191_().m_82399_())) < 20.0) {
                        tag.m_128405_("SeekTime", tag.m_128451_("SeekTime") + 1);
                        if (tag.m_128451_("SeekTime") > 0 && (!targetEntity.m_20197_().isEmpty() || targetEntity instanceof VehicleEntity) && targetEntity.f_19797_ % 3 == 0) {
                            targetEntity.m_9236_().m_5594_(null, targetEntity.m_20097_(), targetEntity instanceof Pig ? SoundEvents.f_12235_ : (SoundEvent)ModSounds.LOCKING_WARNING.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
                        }
                    } else {
                        tag.m_128405_("SeekTime", 0);
                    }
                    if (tag.m_128451_("SeekTime") == 1 && player instanceof ServerPlayer) {
                        serverPlayer = (ServerPlayer)player;
                        SoundTool.playLocalSound(serverPlayer, (SoundEvent)ModSounds.IGLA_LOCK.get(), 1.0f, 1.0f);
                    }
                    if (targetEntity != null && tag.m_128451_("SeekTime") > 30) {
                        if (player instanceof ServerPlayer) {
                            serverPlayer = (ServerPlayer)player;
                            SoundTool.playLocalSound(serverPlayer, (SoundEvent)ModSounds.IGLA_LOCKON.get(), 1.0f, 1.0f);
                        }
                        if ((!targetEntity.m_20197_().isEmpty() || targetEntity instanceof VehicleEntity) && targetEntity.f_19797_ % 2 == 0) {
                            targetEntity.m_9236_().m_5594_(null, targetEntity.m_20097_(), targetEntity instanceof Pig ? SoundEvents.f_12235_ : (SoundEvent)ModSounds.LOCKED_WARNING.get(), SoundSource.PLAYERS, 1.0f, 0.95f);
                        }
                    }
                    if ((seekingEntity = SeekTool.seekEntity((Entity)player, player.m_9236_(), 512.0, 20.0)) != null && seekingEntity.m_6095_().m_204039_(ModTags.EntityTypes.DECOY)) {
                        tag.m_128405_("SeekTime", 0);
                    }
                }
                if (!(data = GunData.from(stack)).reloading()) return;
                tag.m_128379_("Seeking", false);
                tag.m_128405_("SeekTime", 0);
                tag.m_128359_("TargetEntity", "none");
                return;
            }
        }
        stack.m_41784_().m_128405_("SeekTime", 0);
    }

    @Override
    public ResourceLocation getGunIcon(GunData data) {
        return Mod.loc("textures/gun_icon/igla_9k38_icon.png");
    }

    private void fire(Player player) {
        Level level = player.m_9236_();
        ItemStack stack = player.m_21205_();
        if (!(stack.m_41720_() instanceof GunItem)) {
            return;
        }
        GunData data = GunData.from(stack);
        CompoundTag tag = data.tag();
        if (tag.m_128451_("SeekTime") < 30) {
            return;
        }
        float yRot = player.m_146908_() + 360.0f;
        yRot = (yRot + 90.0f) % 360.0f;
        Vector3d firePos = new Vector3d(0.0, -0.2, 0.15);
        firePos.rotateZ((double)(-player.m_146909_() * ((float)Math.PI / 180)));
        firePos.rotateY((double)(-yRot * ((float)Math.PI / 180)));
        Level level2 = player.m_9236_();
        if (level2 instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level2;
            IglaMissileEntity missileEntity = new IglaMissileEntity((LivingEntity)player, level, data.get(GunProp.DAMAGE).floatValue(), data.get(GunProp.EXPLOSION_DAMAGE).floatValue(), data.get(GunProp.EXPLOSION_RADIUS).floatValue());
            for (Perk.Type type : Perk.Type.values()) {
                PerkInstance instance = data.perk.getInstance(type);
                if (instance == null) continue;
                instance.perk().modifyProjectile(data, instance, (Entity)missileEntity);
            }
            missileEntity.m_6034_(player.m_20185_() + firePos.x, player.m_20188_() + firePos.y, player.m_20189_() + firePos.z);
            missileEntity.m_6686_(player.m_20154_().f_82479_, player.m_20154_().f_82480_ + 0.12, player.m_20154_().f_82481_, 3.0f, 1.0f);
            missileEntity.setTargetUuid(tag.m_128461_("TargetEntity"));
            level.m_7967_((Entity)missileEntity);
            ParticleTool.sendParticle(serverLevel, ParticleTypes.f_123796_, player.m_20185_() + 1.8 * player.m_20154_().f_82479_, player.m_20186_() + (double)player.m_20206_() - 0.1 + 1.8 * player.m_20154_().f_82480_, player.m_20189_() + 1.8 * player.m_20154_().f_82481_, 30, 0.4, 0.4, 0.4, 0.005, true);
            ServerPlayer serverPlayer = (ServerPlayer)player;
            SoundTool.playLocalSound(serverPlayer, (SoundEvent)ModSounds.IGLA_FIRE_1P.get(), 2.0f, 1.0f);
            serverPlayer.m_9236_().m_5594_(null, serverPlayer.m_20097_(), (SoundEvent)ModSounds.IGLA_FIRE_3P.get(), SoundSource.PLAYERS, 4.0f, 1.0f);
            serverPlayer.m_9236_().m_5594_(null, serverPlayer.m_20097_(), (SoundEvent)ModSounds.IGLA_FAR.get(), SoundSource.PLAYERS, 10.0f, 1.0f);
            Mod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new ShootClientMessage(10.0));
        }
        data.ammo.set(data.ammo.get() - data.get(GunProp.AMMO_COST_PER_SHOOT));
    }

    @Override
    public void shoot(@Nullable Entity shooter, @NotNull ServerLevel level, @NotNull Vec3 shootPosition, @NotNull Vec3 shootDirection, @NotNull GunData data, double spread, boolean zoom, @Nullable UUID uuid) {
    }

    @Override
    public void onFireKeyPress(GunData data, Player player, boolean zoom) {
        super.onFireKeyPress(data, player, zoom);
        if (!zoom || !data.hasEnoughAmmoToShoot((Entity)player)) {
            return;
        }
        this.fire(player);
    }

    @Override
    public void onChangeSlot(ItemStack stack, Player player) {
        super.onChangeSlot(stack, player);
        GunData data = GunData.from(stack);
        CompoundTag tag = data.tag();
        tag.m_128473_("Seeking");
        tag.m_128473_("SeekTime");
        tag.m_128359_("TargetEntity", "none");
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            ClientboundStopSoundPacket clientboundstopsoundpacket = new ClientboundStopSoundPacket(Mod.loc("igla_9k38_lock"), SoundSource.PLAYERS);
            serverPlayer.f_8906_.m_9829_((Packet)clientboundstopsoundpacket);
        }
    }
}

