/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.item.gun.handgun;

import com.atsuishio.superbwarfare.Mod;
import com.atsuishio.superbwarfare.client.GunRendererBuilder;
import com.atsuishio.superbwarfare.client.TooltipTool;
import com.atsuishio.superbwarfare.client.model.item.AureliaSceptreModel;
import com.atsuishio.superbwarfare.data.gun.GunData;
import com.atsuishio.superbwarfare.event.ClientEventHandler;
import com.atsuishio.superbwarfare.item.gun.GunItem;
import com.atsuishio.superbwarfare.tools.RarityTool;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.renderer.GeoItemRenderer;

public class AureliaSceptre
extends GunItem {
    public AureliaSceptre() {
        super(new Item.Properties().m_41497_(RarityTool.LEGENDARY));
    }

    @Override
    public Supplier<? extends GeoItemRenderer<? extends Item>> getRenderer() {
        return GunRendererBuilder.simple(AureliaSceptreModel::new, 0.0, 0.0, 0.3022, 0.3);
    }

    private PlayState idlePredicate(AnimationState<AureliaSceptre> event) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return PlayState.STOP;
        }
        ItemStack stack = player.m_21205_();
        if (!(stack.m_41720_() instanceof GunItem)) {
            return PlayState.STOP;
        }
        if (event.getData(DataTickets.ITEM_RENDER_PERSPECTIVE) != ItemDisplayContext.FIRST_PERSON_RIGHT_HAND) {
            return event.setAndContinue(RawAnimation.begin().thenLoop("animation.aurelia_sceptre.idle"));
        }
        if (player.m_20142_() && player.m_20096_() && ClientEventHandler.cantSprint == 0.0f && !GunData.from((ItemStack)stack).reload.normal() && !GunData.from((ItemStack)stack).reload.empty() && ClientEventHandler.drawTime < 0.01 && ClientEventHandler.gunMelee == 0) {
            return event.setAndContinue(RawAnimation.begin().thenLoop("animation.aurelia_sceptre.run"));
        }
        return event.setAndContinue(RawAnimation.begin().thenLoop("animation.aurelia_sceptre.idle"));
    }

    @OnlyIn(value=Dist.CLIENT)
    private PlayState firePredicate(AnimationState<AureliaSceptre> event) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return PlayState.STOP;
        }
        ItemStack stack = player.m_21205_();
        Item item = stack.m_41720_();
        if (!(item instanceof GunItem)) {
            return PlayState.STOP;
        }
        GunItem gunItem = (GunItem)item;
        if (event.getData(DataTickets.ITEM_RENDER_PERSPECTIVE) != ItemDisplayContext.FIRST_PERSON_RIGHT_HAND) {
            return event.setAndContinue(RawAnimation.begin().thenLoop("animation.aurelia_sceptre.idle"));
        }
        GunData data = GunData.from(stack);
        if (ClientEventHandler.holdFire && gunItem.canShoot(data, (Entity)player)) {
            return event.setAndContinue(RawAnimation.begin().thenLoop("animation.aurelia_sceptre.fire"));
        }
        return event.setAndContinue(RawAnimation.begin().thenLoop("animation.aurelia_sceptre.idle"));
    }

    private PlayState meleePredicate(AnimationState<AureliaSceptre> event) {
        if (event.getData(DataTickets.ITEM_RENDER_PERSPECTIVE) != ItemDisplayContext.FIRST_PERSON_RIGHT_HAND) {
            return event.setAndContinue(RawAnimation.begin().thenLoop("animation.aurelia_sceptre.idle"));
        }
        if (ClientEventHandler.gunMelee > 0) {
            return event.setAndContinue(RawAnimation.begin().thenPlay("animation.aurelia_sceptre.hit"));
        }
        return event.setAndContinue(RawAnimation.begin().thenLoop("animation.aurelia_sceptre.idle"));
    }

    @ParametersAreNonnullByDefault
    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> list, TooltipFlag flag) {
        list.add((Component)Component.m_237119_());
        list.add((Component)Component.m_237115_((String)"des.superbwarfare.aurelia_sceptre_1").m_130940_(ChatFormatting.GRAY));
        list.add((Component)Component.m_237115_((String)"des.superbwarfare.aurelia_sceptre_2").m_130940_(ChatFormatting.GRAY).m_130940_(ChatFormatting.ITALIC));
        TooltipTool.addHideText(list, (Component)Component.m_237119_());
        TooltipTool.addHideText(list, (Component)Component.m_237115_((String)"des.superbwarfare.trachelium_3").m_130940_(ChatFormatting.WHITE));
        TooltipTool.addHideText(list, (Component)Component.m_237115_((String)"des.superbwarfare.aurelia_sceptre_3").m_130948_(Style.f_131099_.m_178520_(11259375)));
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
        AnimationController idleController = new AnimationController((GeoAnimatable)this, "idleController", 6, this::idlePredicate);
        data.add(new AnimationController[]{idleController});
        AnimationController fireController = new AnimationController((GeoAnimatable)this, "fireController", 3, this::firePredicate);
        data.add(new AnimationController[]{fireController});
        AnimationController meleeController = new AnimationController((GeoAnimatable)this, "meleeController", 0, this::meleePredicate);
        data.add(new AnimationController[]{meleeController});
    }

    @Override
    public ResourceLocation getGunIcon(GunData data) {
        return Mod.loc("textures/gun_icon/aurelia_sceptre_icon.png");
    }

    @Override
    public void addReloadTimeBehavior(Map<Integer, Consumer<GunData>> behaviors) {
        super.addReloadTimeBehavior(behaviors);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public IClientItemExtensions getClientExtensions() {
        return new IClientItemExtensions(){
            private final BlockEntityWithoutLevelRenderer renderer;
            private static final HumanoidModel.ArmPose POSE = HumanoidModel.ArmPose.create((String)"AureliaSceptre", (boolean)false, (model, entity, arm) -> {
                if (arm != HumanoidArm.LEFT) {
                    model.f_102811_.f_104203_ = -1.1780972f + model.f_102808_.f_104203_ + 0.05f * model.f_102811_.f_104203_;
                    model.f_102811_.f_104204_ = 0.08726646f + model.f_102808_.f_104204_;
                }
            });
            {
                this.renderer = (BlockEntityWithoutLevelRenderer)AureliaSceptre.this.getRenderer().get();
            }

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                return this.renderer;
            }

            public HumanoidModel.ArmPose getArmPose(LivingEntity entityLiving, InteractionHand hand, ItemStack stack) {
                if (!stack.m_41619_() && entityLiving.m_7655_() == hand) {
                    return POSE;
                }
                return HumanoidModel.ArmPose.EMPTY;
            }
        };
    }
}

