/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.item.gun;

import com.atsuishio.superbwarfare.Mod;
import com.atsuishio.superbwarfare.client.PoseTool;
import com.atsuishio.superbwarfare.client.screens.WeaponEditScreen;
import com.atsuishio.superbwarfare.client.tooltip.component.GunImageComponent;
import com.atsuishio.superbwarfare.data.Prop;
import com.atsuishio.superbwarfare.data.gun.DefaultGunData;
import com.atsuishio.superbwarfare.data.gun.FireMode;
import com.atsuishio.superbwarfare.data.gun.GunData;
import com.atsuishio.superbwarfare.data.gun.GunProp;
import com.atsuishio.superbwarfare.data.gun.GunPropertyModifier;
import com.atsuishio.superbwarfare.data.gun.ProjectileInfo;
import com.atsuishio.superbwarfare.data.gun.value.AttachmentType;
import com.atsuishio.superbwarfare.data.launchable.LaunchableEntityTool;
import com.atsuishio.superbwarfare.data.launchable.ShootData;
import com.atsuishio.superbwarfare.entity.projectile.CustomDamageProjectile;
import com.atsuishio.superbwarfare.entity.projectile.CustomGravityEntity;
import com.atsuishio.superbwarfare.entity.projectile.ExplosiveProjectile;
import com.atsuishio.superbwarfare.entity.projectile.ProjectileEntity;
import com.atsuishio.superbwarfare.event.ClientEventHandler;
import com.atsuishio.superbwarfare.init.ModPerks;
import com.atsuishio.superbwarfare.init.ModSounds;
import com.atsuishio.superbwarfare.item.CustomRendererItem;
import com.atsuishio.superbwarfare.item.ItemScreenProvider;
import com.atsuishio.superbwarfare.perk.AmmoPerk;
import com.atsuishio.superbwarfare.perk.Perk;
import com.atsuishio.superbwarfare.perk.PerkInstance;
import com.atsuishio.superbwarfare.tools.EntityFindUtil;
import com.atsuishio.superbwarfare.tools.RangeTool;
import com.atsuishio.superbwarfare.tools.SoundTool;
import com.atsuishio.superbwarfare.tools.VectorTool;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.animatable.SingletonGeoAnimatable;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.util.GeckoLibUtil;

@Mod.EventBusSubscriber
public abstract class GunItem
extends Item
implements GeoItem,
CustomRendererItem,
ItemScreenProvider,
GunPropertyModifier {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    protected final Map<GunProp<?>, Prop.PropModifyContext<GunData, DefaultGunData, ?>> propertyModifiers = new HashMap();
    private boolean isDamageable = false;
    public final Map<Integer, Consumer<GunData>> reloadTimeBehaviors = new HashMap<Integer, Consumer<GunData>>();
    public final Map<Integer, Consumer<GunData>> boltTimeBehaviors = new HashMap<Integer, Consumer<GunData>>();

    public GunItem(Item.Properties properties) {
        super(properties.m_41487_(1));
        this.addReloadTimeBehavior(this.reloadTimeBehaviors);
        this.addBoltTimeBehavior(this.boltTimeBehaviors);
        SingletonGeoAnimatable.registerSyncedAnimatable((GeoAnimatable)this);
        this.setProperty(GunProp.DAMAGE, (data, v) -> v + this.getCustomDamage((GunData)data));
        this.setProperty(GunProp.HEADSHOT, (data, v) -> v + this.getCustomHeadshot((GunData)data));
        this.setProperty(GunProp.BYPASSES_ARMOR, (data, v) -> v + this.getCustomBypassArmor((GunData)data));
        this.setProperty(GunProp.MAGAZINE, (data, v) -> v + this.getCustomMagazine((GunData)data));
        this.setProperty(GunProp.DEFAULT_ZOOM, (data, v) -> v + this.getCustomZoom((GunData)data));
        this.setProperty(GunProp.RPM, (data, v) -> v + this.getCustomRPM((GunData)data));
        this.setProperty(GunProp.WEIGHT, (data, v) -> v + this.getCustomWeight((GunData)data));
        this.setProperty(GunProp.VELOCITY, (data, v) -> v + this.getCustomVelocity((GunData)data));
        this.setProperty(GunProp.SOUND_RADIUS, (data, v) -> v + this.getCustomSoundRadius((GunData)data));
        this.setProperty(GunProp.BOLT_ACTION_TIME, (data, v) -> v + this.getCustomBoltActionTime((GunData)data));
    }

    @Override
    @NotNull
    public Map<GunProp<?>, Prop.PropModifyContext<GunData, DefaultGunData, ?>> getPropModifiers() {
        return this.propertyModifiers;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public boolean isPerspectiveAware() {
        return true;
    }

    @ParametersAreNonnullByDefault
    public boolean m_6777_(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer) {
        return false;
    }

    @ParametersAreNonnullByDefault
    public void m_6883_(ItemStack stack, Level level, Entity entity, int slot, boolean selected) {
        LivingEntity living;
        if (!(stack.m_41720_() instanceof GunItem) || level.f_46443_) {
            return;
        }
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            GeoItem.getOrAssignId((ItemStack)stack, (ServerLevel)serverLevel);
        }
        GunData data = GunData.from(stack);
        boolean inMainHand = entity instanceof LivingEntity && (living = (LivingEntity)entity).m_21205_() == stack;
        data.tick(entity, inMainHand);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return false;
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        Multimap map = super.getAttributeModifiers(slot, stack);
        UUID uuid = new UUID(slot.toString().hashCode(), 0L);
        if (slot != EquipmentSlot.MAINHAND) {
            return map;
        }
        GunData data = GunData.from(stack);
        map = HashMultimap.create((Multimap)map);
        map.put((Object)Attributes.f_22279_, (Object)new AttributeModifier(uuid, "superbwarfare_attribute_modifier", (double)-0.01f - (double)0.005f * data.get(GunProp.WEIGHT), AttributeModifier.Operation.MULTIPLY_BASE));
        if (data.get(GunProp.MELEE_DAMAGE) > 0.0) {
            map.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "superbwarfare_attribute_modifier", data.get(GunProp.MELEE_DAMAGE).doubleValue(), AttributeModifier.Operation.ADDITION));
        }
        return map;
    }

    @NotNull
    public Optional<TooltipComponent> m_142422_(@NotNull ItemStack pStack) {
        return Optional.of(new GunImageComponent(pStack));
    }

    public Set<SoundEvent> getReloadSound() {
        return Set.of();
    }

    public ResourceLocation getGunIcon(ItemStack stack) {
        return this.getGunIcon(GunData.from(stack));
    }

    public ResourceLocation getGunIcon(GunData data) {
        return Mod.loc("textures/gun_icon/default_icon.png");
    }

    public boolean m_5812_(@NotNull ItemStack stack) {
        return false;
    }

    public boolean m_8120_(@NotNull ItemStack stack) {
        return false;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return false;
    }

    public int getMaxDamage(@NotNull ItemStack stack) {
        Integer maxDurability = GunData.from(stack).get(GunProp.MAX_DURABILITY);
        this.isDamageable = maxDurability > 0;
        return maxDurability;
    }

    public boolean isDamageable(ItemStack stack) {
        return this.isDamageable;
    }

    public boolean isOpenBolt(GunData data) {
        return false;
    }

    public boolean hasBulletInBarrel(GunData data) {
        return false;
    }

    public boolean hasCustomBarrel(GunData data) {
        return false;
    }

    public int[] getValidBarrels() {
        return new int[]{0, 1, 2};
    }

    public boolean hasCustomGrip(GunData data) {
        return false;
    }

    public int[] getValidGrips() {
        return new int[]{0, 1, 2, 3};
    }

    public boolean hasCustomMagazine(GunData data) {
        return false;
    }

    public int[] getValidMagazines() {
        return new int[]{0, 1, 2};
    }

    public boolean hasCustomScope(GunData data) {
        return false;
    }

    public int[] getValidScopes() {
        return new int[]{0, 1, 2, 3};
    }

    public boolean hasCustomStock(GunData data) {
        return false;
    }

    public int[] getValidStocks() {
        return new int[]{0, 1, 2};
    }

    public boolean hasBipod(GunData data) {
        return false;
    }

    public boolean canEjectShell(GunData data) {
        return false;
    }

    public boolean hasMeleeAttack(GunData data) {
        return data.get(GunProp.MELEE_DAMAGE) > 0.0;
    }

    public double getCustomDamage(GunData data) {
        return 0.0;
    }

    public double getCustomHeadshot(GunData data) {
        return 0.0;
    }

    public double getCustomBypassArmor(GunData data) {
        return 0.0;
    }

    public int getCustomMagazine(GunData data) {
        return 0;
    }

    public double getCustomZoom(GunData data) {
        return 0.0;
    }

    public int getCustomRPM(GunData data) {
        return 0;
    }

    public double getCustomWeight(GunData data) {
        CompoundTag tag = data.attachment();
        double scopeWeight = switch (tag.m_128451_("Scope")) {
            case 1 -> 0.5;
            case 2 -> 1.0;
            case 3 -> 1.5;
            default -> 0.0;
        };
        double barrelWeight = switch (tag.m_128451_("Barrel")) {
            case 1 -> 0.5;
            case 2 -> 1.0;
            default -> 0.0;
        };
        double magazineWeight = switch (tag.m_128451_("Magazine")) {
            case 1 -> 1.0;
            case 2 -> 2.0;
            default -> 0.0;
        };
        double stockWeight = switch (tag.m_128451_("Stock")) {
            case 1 -> -2.0;
            case 2 -> 1.5;
            default -> 0.0;
        };
        double gripWeight = switch (tag.m_128451_("Grip")) {
            case 1, 2 -> 0.25;
            case 3 -> 1.0;
            default -> 0.0;
        };
        return scopeWeight + barrelWeight + magazineWeight + stockWeight + gripWeight;
    }

    public double getCustomVelocity(GunData data) {
        return 0.0;
    }

    public double getCustomSoundRadius(GunData data) {
        return data.attachment.get(AttachmentType.BARREL) == 2 ? 0.6 : 1.0;
    }

    public int getCustomBoltActionTime(GunData data) {
        return 0;
    }

    public boolean canAdjustZoom(GunData data) {
        return false;
    }

    public boolean canSwitchScope(GunData data) {
        return false;
    }

    public void addReloadTimeBehavior(Map<Integer, Consumer<GunData>> behaviors) {
    }

    public void addBoltTimeBehavior(Map<Integer, Consumer<GunData>> behaviors) {
    }

    public boolean canShoot(GunData data, @Nullable Entity shooter) {
        return data.get(GunProp.PROJECTILE_AMOUNT) > 0 && !data.overHeat.get() && !data.reloading() && !data.charging() && !data.bolt.needed.get() && data.hasEnoughAmmoToShoot(shooter);
    }

    public void beforeShoot(@Nullable Entity shooter, @NotNull ServerLevel level, @NotNull Vec3 shootPosition, @NotNull Vec3 shootDirection, @NotNull GunData data, double spread, boolean zoom) {
        if (data.currentAvailableShots(shooter) == 1) {
            data.holdOpen.set(true);
        }
        if (data.get(GunProp.BOLT_ACTION_TIME) > 0 && data.hasEnoughAmmoToShoot(shooter)) {
            data.bolt.needed.set(true);
        }
    }

    public void afterShoot(@Nullable Entity shooter, @NotNull ServerLevel level, @NotNull Vec3 shootPosition, @NotNull Vec3 shootDirection, @NotNull GunData data, double spread, boolean zoom, @Nullable UUID uuid) {
        ItemStack stack;
        if (!data.useBackpackAmmo()) {
            data.ammo.set(data.ammo.get() - data.get(GunProp.AMMO_COST_PER_SHOOT));
            data.isEmpty.set(true);
            data.closeStrike.set(true);
        } else {
            data.consumeBackupAmmo(shooter, (int)data.get(GunProp.AMMO_COST_PER_SHOOT));
        }
        if (!data.hasEnoughAmmoToShoot(shooter)) {
            data.burstAmount.reset();
        }
        if (this.getMaxDamage(stack = data.stack()) > 0) {
            if (shooter instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)shooter;
                stack.m_41622_(data.get(GunProp.DURABILITY_PER_SHOOT).intValue(), living, p -> p.m_21190_(living.m_7655_()));
            } else if (stack.m_220157_(data.get(GunProp.DURABILITY_PER_SHOOT).intValue(), RandomSource.m_216327_(), null)) {
                stack.m_41774_(1);
            }
        }
        if (shooter != null && data.get(GunProp.RECOIL) != 0.0) {
            shooter.m_20256_(shooter.m_20184_().m_82549_(shooter.m_20252_(1.0f).m_82490_(-data.get(GunProp.RECOIL).doubleValue())));
        }
        data.clearTempModifications();
    }

    public void shoot(@NotNull ServerLevel level, @NotNull Vec3 shootPosition, @NotNull Vec3 shootDirection, @NotNull GunData data, double spread, boolean zoom, @Nullable UUID uuid) {
        this.shoot(null, level, shootPosition, shootDirection, data, spread, zoom, uuid);
    }

    public void shoot(@NotNull GunData data, @NotNull Entity shooter, double spread, boolean zoom, UUID uuid) {
        Level level = shooter.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)level;
            this.shoot(shooter, server, new Vec3(shooter.m_20185_(), shooter.m_20188_(), shooter.m_20189_()), shooter.m_20154_(), data, spread, zoom, uuid);
        }
    }

    public void shoot(@Nullable Entity shooter, @NotNull ServerLevel level, @NotNull Vec3 shootPosition, @NotNull Vec3 shootDirection, @NotNull GunData data, double spread, boolean zoom, @Nullable UUID uuid) {
        if (!data.canShoot(shooter)) {
            return;
        }
        data.item.beforeShoot(shooter, level, shootPosition, shootDirection, data, spread, zoom);
        int projectileAmount = data.get(GunProp.PROJECTILE_AMOUNT);
        for (int index0 = 0; index0 < projectileAmount; ++index0) {
            if (this.shootBullet(shooter, level, shootPosition, shootDirection, data, spread, zoom, uuid)) continue;
            return;
        }
        if (data.fireMode.get() == FireMode.BURST) {
            int amount = data.burstAmount.get();
            data.burstAmount.set(amount == 0 ? data.get(GunProp.BURST_AMOUNT) - 1 : Math.max(0, amount - 1));
        }
        data.heat.set(Mth.m_14008_((double)(data.heat.get() + data.get(GunProp.HEAT_PER_SHOOT)), (double)0.0, (double)100.0));
        if (data.heat.get() >= 100.0 && !data.overHeat.get()) {
            data.overHeat.set(true);
            if (shooter instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)shooter;
                SoundTool.playLocalSound(serverPlayer, (SoundEvent)ModSounds.MINIGUN_OVERHEAT.get(), 2.0f, 1.0f);
            }
        }
        this.playFireSounds(data, shooter, zoom);
        data.item.afterShoot(shooter, level, shootPosition, shootDirection, data, spread, zoom, uuid);
    }

    public void playFireSounds(GunData data, @Nullable Entity shooter, boolean zoom) {
        SoundEvent soundVeryFar;
        SoundEvent soundFar;
        if (shooter == null) {
            return;
        }
        ItemStack stack = data.stack;
        String origin = stack.m_41720_().m_5524_();
        String name = origin.substring(origin.lastIndexOf(".") + 1);
        float pitch = data.heat.get() <= 75.0 ? 1.0f : (float)(1.0 - 0.02 * Math.abs(75.0 - data.heat.get()));
        Perk perk = data.perk.get(Perk.Type.AMMO);
        if (perk == ModPerks.BEAST_BULLET.get()) {
            shooter.m_5496_((SoundEvent)ModSounds.HENG.get(), 4.0f, pitch);
        }
        float soundRadius = data.get(GunProp.SOUND_RADIUS).floatValue();
        int barrelType = data.attachment.get(AttachmentType.BARREL);
        SoundEvent sound3p = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(Mod.loc(name + (barrelType == 2 ? "_fire_3p_s" : "_fire_3p")));
        if (sound3p != null) {
            shooter.m_5496_(sound3p, soundRadius * 0.4f, pitch);
        }
        if ((soundFar = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(Mod.loc(name + (barrelType == 2 ? "_far_s" : "_far")))) != null) {
            shooter.m_5496_(soundFar, soundRadius * 0.7f, pitch);
        }
        if ((soundVeryFar = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(Mod.loc(name + (barrelType == 2 ? "_veryfar_s" : "_veryfar")))) != null) {
            shooter.m_5496_(soundVeryFar, soundRadius, pitch);
        }
    }

    public void onFireKeyPress(GunData data, Player player, boolean zoom) {
        if (data.reload.prepareTimer.get() == 0 && data.reloading() && data.hasEnoughAmmoToShoot((Entity)player)) {
            data.forceStop.set(true);
        }
    }

    public void onFireKeyRelease(GunData data, Player player, double power, boolean zoom) {
    }

    public static double perkDamage(Perk perk) {
        if (perk instanceof AmmoPerk) {
            AmmoPerk ammoPerk = (AmmoPerk)perk;
            return ammoPerk.damageRate;
        }
        return 1.0;
    }

    public boolean shootBullet(@Nullable Entity shooter, @NotNull ServerLevel level, @NotNull Vec3 shootPosition, @NotNull Vec3 shootDirection, @NotNull GunData data, double spread, boolean zoom, @Nullable UUID uuid) {
        ItemStack stack = data.stack;
        Double headshot = data.get(GunProp.HEADSHOT);
        Double damage = data.get(GunProp.DAMAGE);
        Double velocity = data.get(GunProp.VELOCITY);
        Double bypassArmorRate = data.get(GunProp.BYPASSES_ARMOR);
        if (VectorTool.isInLiquid((Level)level, shootPosition)) {
            velocity = 2.0 + (double)0.05f * velocity;
        }
        Double finalVelocity = velocity;
        ProjectileInfo projectileInfo = data.get(GunProp.PROJECTILE);
        String projectileType = projectileInfo.type;
        if (projectileType.trim().toLowerCase(Locale.ROOT).equals("empty")) {
            return true;
        }
        AtomicReference entityHolder = new AtomicReference();
        EntityType.m_20632_((String)projectileType).ifPresent(entityType -> {
            Entity entity = entityType.m_20615_((Level)level);
            if (entity == null) {
                Mod.LOGGER.warn("Failed to create projectile entity {}", (Object)projectileType);
                return;
            }
            if (entity instanceof Projectile) {
                Projectile projectileEntity = (Projectile)entity;
                projectileEntity.m_5602_(shooter);
            }
            if (entity instanceof ProjectileEntity) {
                ProjectileEntity projectile = (ProjectileEntity)entity;
                projectile.shooter(shooter).damage(damage.floatValue()).headShot(headshot.floatValue()).zoom(zoom).bypassArmorRate(bypassArmorRate.floatValue()).setGunItemId(stack).velocity(finalVelocity.floatValue());
            }
            if (entity instanceof CustomDamageProjectile) {
                CustomDamageProjectile customDamageProjectile = (CustomDamageProjectile)entity;
                customDamageProjectile.setDamage(damage.floatValue());
            }
            if (entity instanceof CustomGravityEntity) {
                CustomGravityEntity customGravityEntity = (CustomGravityEntity)entity;
                if (!data.get(GunProp.GRAVITY).isNaN()) {
                    customGravityEntity.setGravity(data.get(GunProp.GRAVITY).floatValue());
                }
            }
            if (entity instanceof ExplosiveProjectile) {
                ExplosiveProjectile explosive = (ExplosiveProjectile)entity;
                explosive.setExplosionDamage(data.get(GunProp.EXPLOSION_DAMAGE).floatValue());
                explosive.setExplosionRadius(data.get(GunProp.EXPLOSION_RADIUS).floatValue());
            }
            if (projectileInfo.data != null) {
                CompoundTag tag = LaunchableEntityTool.getModifiedTag(projectileInfo, new ShootData(shooter != null ? shooter.m_20148_() : null, damage, data.get(GunProp.EXPLOSION_DAMAGE), data.get(GunProp.EXPLOSION_RADIUS), data.get(GunProp.SPREAD)));
                if (tag != null) {
                    entity.m_20258_(tag);
                }
            } else if (LaunchableEntityTool.launchableEntitiesData.containsKey(projectileType)) {
                ProjectileInfo newInfo = new ProjectileInfo();
                newInfo.data = LaunchableEntityTool.launchableEntitiesData.get((Object)projectileType).data;
                newInfo.type = projectileType;
                CompoundTag tag = LaunchableEntityTool.getModifiedTag(newInfo, new ShootData(shooter != null ? shooter.m_20148_() : null, damage, data.get(GunProp.EXPLOSION_DAMAGE), data.get(GunProp.EXPLOSION_RADIUS), data.get(GunProp.SPREAD)));
                if (tag != null) {
                    entity.m_20258_(tag);
                }
            }
            entityHolder.set(entity);
        });
        Entity entity = (Entity)entityHolder.get();
        if (entity == null) {
            Mod.LOGGER.warn("Failed to create projectile entity {}", (Object)projectileType);
            return false;
        }
        for (Perk.Type type : Perk.Type.values()) {
            PerkInstance instance = data.perk.getInstance(type);
            if (instance == null) continue;
            instance.perk().modifyProjectile(data, instance, entity);
        }
        entity.m_6034_(shootPosition.f_82479_ - 0.1 * shootDirection.f_82479_, shootPosition.f_82480_ - 0.1 - 0.1 * shootDirection.f_82480_, shootPosition.f_82481_ + -0.1 * shootDirection.f_82481_);
        double x = shootDirection.f_82479_;
        double y = shootDirection.f_82480_ + (double)0.001f;
        double z = shootDirection.f_82481_;
        if (uuid != null && zoom && shooter != null && !shooter.m_6144_()) {
            Entity target = EntityFindUtil.findEntity((Level)level, String.valueOf(uuid));
            GunData gunData = GunData.from(stack);
            short intelligentChipLevel = gunData.perk.getLevel(ModPerks.INTELLIGENT_CHIP);
            if (intelligentChipLevel > 0 && target != null) {
                Vec3 targetVec = target.m_146892_();
                Vec3 playerVec = shooter.m_146892_();
                boolean hasGravity = gunData.perk.getLevel(ModPerks.MICRO_MISSILE) <= 0;
                Vec3 toVec = RangeTool.calculateFiringSolution(playerVec, targetVec, Vec3.f_82478_, data.get(GunProp.VELOCITY), hasGravity ? 0.03 : 0.0);
                x = toVec.f_82479_;
                y = toVec.f_82480_;
                z = toVec.f_82481_;
            }
        }
        if (entity instanceof Projectile) {
            Projectile projectile = (Projectile)entity;
            projectile.m_6686_(x, y, z, velocity.floatValue(), (float)spread);
        } else {
            RandomSource random = RandomSource.m_216327_();
            Vec3 vec3 = new Vec3(x, y, z).m_82541_().m_82520_(random.m_216328_(0.0, 0.0172275 * spread), random.m_216328_(0.0, 0.0172275 * spread), random.m_216328_(0.0, 0.0172275 * spread)).m_82490_(velocity.doubleValue());
            entity.m_20256_(vec3);
            entity.f_19812_ = true;
            double d0 = vec3.m_165924_();
            entity.m_146922_((float)(Mth.m_14136_((double)vec3.f_82479_, (double)vec3.f_82481_) * 180.0 / 3.1415927410125732));
            entity.m_146926_((float)(Mth.m_14136_((double)vec3.f_82480_, (double)d0) * 180.0 / 3.1415927410125732));
            entity.f_19859_ = entity.m_146908_();
            entity.f_19860_ = entity.m_146909_();
        }
        level.m_7967_(entity);
        return true;
    }

    public void initializeClient(@NotNull Consumer<IClientItemExtensions> consumer) {
        super.initializeClient(consumer);
        consumer.accept(this.getClientExtensions());
    }

    public boolean canEditAttachments(GunData data) {
        return data.ammoConsumers.size() > 1;
    }

    public void onChangeSlot(ItemStack stack, Player player) {
    }

    @OnlyIn(value=Dist.CLIENT)
    public IClientItemExtensions getClientExtensions() {
        return new IClientItemExtensions(){
            private final BlockEntityWithoutLevelRenderer renderer;
            {
                this.renderer = (BlockEntityWithoutLevelRenderer)GunItem.this.getRenderer().get();
            }

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                return this.renderer;
            }

            public HumanoidModel.ArmPose getArmPose(LivingEntity entityLiving, InteractionHand hand, ItemStack stack) {
                return PoseTool.pose(entityLiving, hand, stack);
            }
        };
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    @Nullable
    public Screen getItemScreen(ItemStack stack, Player player, InteractionHand hand) {
        if (ClientEventHandler.canOpenEditScreen(stack, hand) && stack.m_41720_() instanceof GunItem && this.canEditAttachments(GunData.from(stack))) {
            return new WeaponEditScreen(stack);
        }
        return null;
    }
}

