/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.item;

import com.atsuishio.superbwarfare.Mod;
import com.atsuishio.superbwarfare.config.server.MiscConfig;
import com.atsuishio.superbwarfare.entity.DPSGeneratorEntity;
import com.atsuishio.superbwarfare.entity.TargetEntity;
import com.atsuishio.superbwarfare.entity.mixin.BeastEntityKiller;
import com.atsuishio.superbwarfare.init.ModDamageTypes;
import com.atsuishio.superbwarfare.init.ModSounds;
import com.atsuishio.superbwarfare.network.message.receive.ClientIndicatorMessage;
import com.atsuishio.superbwarfare.network.message.receive.LivingGunKillMessage;
import com.atsuishio.superbwarfare.tools.RarityTool;
import com.atsuishio.superbwarfare.tools.TraceTool;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSoundPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Beast
extends SwordItem {
    public Beast() {
        super((Tier)Tiers.NETHERITE, 0, 0.0f, new Item.Properties().m_41487_(1).m_41497_(RarityTool.LEGENDARY).setNoRepair().m_41503_(114514));
    }

    public boolean isDamageable(ItemStack stack) {
        return false;
    }

    @ParametersAreNonnullByDefault
    public boolean m_7579_(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        Beast.beastKill((Entity)attacker, (Entity)target);
        return true;
    }

    public static void beastKill(@Nullable Entity attacker, @NotNull Entity target) {
        if (target.m_9236_().f_46443_) {
            return;
        }
        if (target instanceof TargetEntity) {
            target.m_6469_(ModDamageTypes.causeBeastDamage(target.m_9236_().m_9598_(), attacker, attacker), 114514.195f);
            return;
        }
        if (target instanceof DPSGeneratorEntity) {
            DPSGeneratorEntity generator = (DPSGeneratorEntity)target;
            generator.m_6469_(ModDamageTypes.causeBeastDamage(generator.m_9236_().m_9598_(), attacker, attacker), 114514.195f);
            generator.beastCharge();
            return;
        }
        if (attacker instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)attacker;
            Mod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> player), (Object)new ClientIndicatorMessage(1, 5));
            Holder holder = Holder.m_205709_((Object)((SoundEvent)ModSounds.INDICATION.get()));
            player.f_8906_.m_9829_((Packet)new ClientboundSoundPacket(holder, SoundSource.PLAYERS, player.m_20185_(), player.m_20186_(), player.m_20189_(), 1.0f, 1.0f, player.m_9236_().f_46441_.m_188505_()));
            AABB box = target.m_20191_();
            ((ServerLevel)attacker.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123798_, target.m_20185_(), target.m_20186_() + 0.5, target.m_20189_(), 1000, box.m_82362_() / 2.5, box.m_82376_() / 3.0, box.m_82385_() / 2.5, 0.0);
            if (((Boolean)MiscConfig.SEND_KILL_FEEDBACK.get()).booleanValue()) {
                Mod.PACKET_HANDLER.send(PacketDistributor.ALL.noArg(), (Object)new LivingGunKillMessage(player.m_19879_(), target.m_19879_(), false, ModDamageTypes.BEAST));
            }
        }
        if (target instanceof ServerPlayer) {
            ServerPlayer victim = (ServerPlayer)target;
            victim.m_21153_(0.0f);
            victim.m_9236_().m_6907_().forEach(p -> p.m_213846_((Component)Component.m_237110_((String)"death.attack.beast_gun", (Object[])new Object[]{victim.m_5446_(), attacker != null ? attacker.m_5446_() : ""})));
        } else {
            if (target instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)target;
                BeastEntityKiller.getInstance(living).sbw$kill();
                living.m_21153_(0.0f);
            }
            target.m_9236_().m_7605_(target, (byte)60);
            target.f_146795_ = Entity.RemovalReason.KILLED;
            target.m_20197_().forEach(Entity::m_8127_);
            target.m_8127_();
            target.f_146801_.m_142472_(Entity.RemovalReason.KILLED);
            target.invalidateCaps();
            target.m_146850_(GameEvent.f_223707_);
        }
        target.m_9236_().m_245803_(target, new BlockPos((int)target.m_20185_(), (int)target.m_20186_(), (int)target.m_20189_()), (SoundEvent)ModSounds.OUCH.get(), SoundSource.PLAYERS, 2.0f, 1.0f);
    }

    @ParametersAreNonnullByDefault
    @NotNull
    public AABB getSweepHitBox(ItemStack stack, Player player, Entity target) {
        return super.getSweepHitBox(stack, player, target).m_82400_(3.0);
    }

    public boolean m_41386_(@NotNull DamageSource source) {
        return false;
    }

    public boolean m_8120_(@NotNull ItemStack stack) {
        return false;
    }

    public boolean onEntitySwing(ItemStack stack, LivingEntity entity) {
        Entity target = TraceTool.findMeleeEntity((Entity)entity, 51.4);
        if (target != null) {
            Beast.beastKill((Entity)entity, target);
        }
        return super.onEntitySwing(stack, entity);
    }

    @ParametersAreNonnullByDefault
    public boolean onLeftClickEntity(ItemStack stack, Player player, Entity entity) {
        Beast.beastKill((Entity)player, entity);
        return super.onLeftClickEntity(stack, player, entity);
    }

    @ParametersAreNonnullByDefault
    public boolean canDisableShield(ItemStack stack, ItemStack shield, LivingEntity entity, LivingEntity attacker) {
        return true;
    }

    @ParametersAreNonnullByDefault
    public void m_7373_(ItemStack pStack, @Nullable Level pLevel, List<Component> pTooltipComponents, TooltipFlag pIsAdvanced) {
        pTooltipComponents.add((Component)Component.m_237115_((String)"des.superbwarfare.beast").m_130948_(Style.f_131099_.m_178520_(10840149)));
    }
}

