/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.event;

import com.atsuishio.superbwarfare.Mod;
import com.atsuishio.superbwarfare.api.event.PreKillEvent;
import com.atsuishio.superbwarfare.capability.LaserCapability;
import com.atsuishio.superbwarfare.capability.ModCapabilities;
import com.atsuishio.superbwarfare.capability.player.PlayerVariable;
import com.atsuishio.superbwarfare.config.common.GameplayConfig;
import com.atsuishio.superbwarfare.config.server.MiscConfig;
import com.atsuishio.superbwarfare.config.server.VehicleConfig;
import com.atsuishio.superbwarfare.data.gun.GunData;
import com.atsuishio.superbwarfare.data.gun.GunProp;
import com.atsuishio.superbwarfare.data.gun.value.ReloadState;
import com.atsuishio.superbwarfare.entity.TargetEntity;
import com.atsuishio.superbwarfare.entity.mixin.ICustomKnockback;
import com.atsuishio.superbwarfare.entity.vehicle.base.ArmedVehicleEntity;
import com.atsuishio.superbwarfare.entity.vehicle.base.AutoAimable;
import com.atsuishio.superbwarfare.entity.vehicle.base.ContainerMobileVehicleEntity;
import com.atsuishio.superbwarfare.entity.vehicle.base.VehicleEntity;
import com.atsuishio.superbwarfare.init.ModAttributes;
import com.atsuishio.superbwarfare.init.ModDamageTypes;
import com.atsuishio.superbwarfare.init.ModItems;
import com.atsuishio.superbwarfare.init.ModPerks;
import com.atsuishio.superbwarfare.init.ModSounds;
import com.atsuishio.superbwarfare.init.ModTags;
import com.atsuishio.superbwarfare.item.gun.GunItem;
import com.atsuishio.superbwarfare.network.message.receive.ClientIndicatorMessage;
import com.atsuishio.superbwarfare.network.message.receive.DrawClientMessage;
import com.atsuishio.superbwarfare.network.message.receive.LivingGunKillMessage;
import com.atsuishio.superbwarfare.perk.Perk;
import com.atsuishio.superbwarfare.perk.PerkInstance;
import com.atsuishio.superbwarfare.tools.Ammo;
import com.atsuishio.superbwarfare.tools.DamageTypeTool;
import com.atsuishio.superbwarfare.tools.FormatTool;
import com.atsuishio.superbwarfare.tools.GunsTool;
import com.atsuishio.superbwarfare.tools.InventoryTool;
import com.atsuishio.superbwarfare.tools.SoundTool;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Stream;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundStopSoundPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.HopperBlockEntity;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingChangeTargetEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingEquipmentChangeEvent;
import net.minecraftforge.event.entity.living.LivingExperienceDropEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.LivingKnockBackEvent;
import net.minecraftforge.event.entity.living.MobEffectEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.PacketDistributor;

@Mod.EventBusSubscriber
public class LivingEventHandler {
    @SubscribeEvent
    public static void onLivingChangeTargetEvent(LivingChangeTargetEvent event) {
        Mob mob;
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Mob && (livingEntity = (mob = (Mob)livingEntity).m_20202_()) instanceof VehicleEntity) {
            VehicleEntity vehicle = (VehicleEntity)livingEntity;
            if (mob == vehicle.m_146895_()) {
                if (event.getNewTarget() != null) {
                    vehicle.m_20088_().m_135381_(VehicleEntity.AI_TURRET_TARGET_UUID, (Object)event.getNewTarget().m_20149_());
                } else {
                    vehicle.m_20088_().m_135381_(VehicleEntity.AI_TURRET_TARGET_UUID, (Object)"undefined");
                }
            }
            if (mob == vehicle.getNthEntity(1)) {
                if (event.getNewTarget() != null) {
                    vehicle.m_20088_().m_135381_(VehicleEntity.AI_PASSENGER_WEAPON_TARGET_UUID, (Object)event.getNewTarget().m_20149_());
                } else {
                    vehicle.m_20088_().m_135381_(VehicleEntity.AI_PASSENGER_WEAPON_TARGET_UUID, (Object)"undefined");
                }
            }
        }
    }

    @SubscribeEvent
    public static void onEntityAttacked(LivingAttackEvent event) {
        Entity entity;
        if (!event.getSource().m_276093_(ModDamageTypes.VEHICLE_EXPLOSION) && (entity = event.getEntity().m_20202_()) instanceof VehicleEntity) {
            ArmedVehicleEntity iArmedVehicle;
            VehicleEntity vehicle = (VehicleEntity)entity;
            Entity entity2 = event.getEntity().m_20202_();
            if (entity2 instanceof ArmedVehicleEntity && (iArmedVehicle = (ArmedVehicleEntity)entity2).getVehicleEntity().isEnclosed((Entity)event.getEntity())) {
                if (!event.getSource().m_269533_(ModTags.DamageTypes.VEHICLE_NOT_ABSORB)) {
                    vehicle.m_6469_(event.getSource(), event.getAmount());
                }
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void onEntityHurt(LivingHurtEvent event) {
        if (event == null || event.getEntity() == null) {
            return;
        }
        LivingEventHandler.handleVehicleHurt(event);
        LivingEventHandler.handleGunPerksWhenHurt(event);
        LivingEventHandler.renderDamageIndicator(event);
        LivingEventHandler.reduceDamage(event);
        LivingEventHandler.giveExpToWeapon(event);
        LivingEventHandler.handleGunLevels(event);
    }

    @SubscribeEvent
    public static void onEntityDeath(LivingDeathEvent event) {
        if (event == null || event.getEntity() == null) {
            return;
        }
        LivingEventHandler.killIndication(event);
        LivingEventHandler.handleGunPerksWhenDeath(event);
        LivingEventHandler.handlePlayerKillEntity(event);
        LivingEventHandler.giveKillExpToWeapon(event);
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            LivingEventHandler.handlePlayerBeamReset(player);
        }
    }

    private static void handleVehicleHurt(LivingHurtEvent event) {
        Entity vehicle = event.getEntity().m_20202_();
        if (vehicle instanceof VehicleEntity && vehicle instanceof ArmedVehicleEntity) {
            ArmedVehicleEntity iArmedVehicle = (ArmedVehicleEntity)vehicle;
            DamageSource source = event.getSource();
            if (source.m_269533_(ModTags.DamageTypes.VEHICLE_IGNORE)) {
                return;
            }
            if (iArmedVehicle.getVehicleEntity().isEnclosed((Entity)event.getEntity())) {
                if (!source.m_276093_(ModDamageTypes.VEHICLE_EXPLOSION)) {
                    event.setCanceled(true);
                }
            } else {
                if (!source.m_269533_(ModTags.DamageTypes.VEHICLE_NOT_ABSORB)) {
                    vehicle.m_6469_(event.getSource(), 0.7f * event.getAmount());
                }
                event.setAmount(0.3f * event.getAmount());
            }
        }
    }

    private static void reduceDamage(LivingHurtEvent event) {
        ItemStack armor;
        ItemStack stack;
        double amount;
        DamageSource source = event.getSource();
        LivingEntity entity = event.getEntity();
        if (entity == null) {
            return;
        }
        Entity sourceEntity = source.m_7639_();
        if (sourceEntity == null) {
            return;
        }
        if (sourceEntity.m_9236_().f_46443_) {
            return;
        }
        double damage = amount = (double)event.getAmount();
        if (sourceEntity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)sourceEntity;
            v0 = living.m_21205_();
        } else {
            v0 = stack = ItemStack.f_41583_;
        }
        if (DamageTypeTool.isGunDamage(source) && stack.m_41720_() instanceof GunItem) {
            GunData data = GunData.from(stack);
            double distance = entity.m_20182_().m_82554_(sourceEntity.m_20182_());
            damage = LivingEventHandler.reduceDamageByDistance(amount, distance, data.getDamageReduceRate(), data.getDamageReduceMinDistance());
        }
        if ((armor = entity.m_6844_(EquipmentSlot.CHEST)) != ItemStack.f_41583_ && armor.m_41783_() != null && armor.m_41783_().m_128441_("ArmorPlate")) {
            double armorValue = armor.m_41784_().m_128459_("ArmorPlate");
            armor.m_41784_().m_128347_("ArmorPlate", Math.max(armorValue - damage, 0.0));
            damage = Math.max(damage - armorValue, 0.0);
        }
        if (source.m_269533_(ModTags.DamageTypes.PROJECTILE) || source.m_276093_(DamageTypes.f_268534_)) {
            damage *= 1.0 - 0.8 * Mth.m_14008_((double)entity.m_21133_((Attribute)ModAttributes.BULLET_RESISTANCE.get()), (double)0.0, (double)1.0);
        }
        if (source.m_269533_(ModTags.DamageTypes.PROJECTILE_ABSOLUTE)) {
            damage *= 1.0 - 0.2 * Mth.m_14008_((double)entity.m_21133_((Attribute)ModAttributes.BULLET_RESISTANCE.get()), (double)0.0, (double)1.0);
        }
        if (source.m_276093_(ModDamageTypes.PROJECTILE_EXPLOSION) || source.m_276093_(ModDamageTypes.MINE) || source.m_276093_(ModDamageTypes.PROJECTILE_HIT) || source.m_276093_(ModDamageTypes.CUSTOM_EXPLOSION) || source.m_276093_(DamageTypes.f_268565_) || source.m_276093_(DamageTypes.f_268448_)) {
            damage *= 1.0 - 0.3 * Mth.m_14008_((double)entity.m_21133_((Attribute)ModAttributes.BULLET_RESISTANCE.get()), (double)0.0, (double)1.0);
        }
        event.setAmount((float)damage);
        if (entity instanceof TargetEntity && sourceEntity instanceof Player) {
            Player player = (Player)sourceEntity;
            if (event.getSource().m_276093_(ModDamageTypes.BEAST)) {
                damage = Double.POSITIVE_INFINITY;
            }
            player.m_5661_((Component)Component.m_237110_((String)"tips.superbwarfare.target.damage", (Object[])new Object[]{FormatTool.format2D(damage), FormatTool.format1D(entity.m_20182_().m_82554_(sourceEntity.m_20182_()), "m")}), false);
        }
    }

    private static double reduceDamageByDistance(double amount, double distance, double rate, double minDistance) {
        return amount / (1.0 + rate * Math.max(0.0, distance - minDistance));
    }

    private static void giveExpToWeapon(LivingHurtEvent event) {
        DamageSource source = event.getSource();
        if (source == null) {
            return;
        }
        Entity sourceEntity = source.m_7639_();
        if (!(sourceEntity instanceof Player)) {
            return;
        }
        Player player = (Player)sourceEntity;
        ItemStack stack = player.m_21205_();
        if (!(stack.m_41720_() instanceof GunItem)) {
            return;
        }
        if (event.getEntity().m_6095_().m_204039_(ModTags.EntityTypes.NO_EXPERIENCE)) {
            return;
        }
        GunData data = GunData.from(stack);
        double amount = Math.min(0.125 * (double)event.getAmount(), (double)event.getEntity().m_21233_());
        if (source.m_276093_(ModDamageTypes.PROJECTILE_EXPLOSION) && (stack.m_204117_(ModTags.Items.LAUNCHER) || GunData.from((ItemStack)stack).perk.getLevel(ModPerks.HE_BULLET) > 0)) {
            data.exp.set(data.exp.get() + amount);
        }
        if (!DamageTypeTool.isGunDamage(source)) {
            return;
        }
        data.exp.set(data.exp.get() + amount);
    }

    private static void giveKillExpToWeapon(LivingDeathEvent event) {
        DamageSource source = event.getSource();
        if (source == null) {
            return;
        }
        Entity sourceEntity = source.m_7639_();
        if (!(sourceEntity instanceof Player)) {
            return;
        }
        Player player = (Player)sourceEntity;
        ItemStack stack = player.m_21205_();
        if (!(stack.m_41720_() instanceof GunItem)) {
            return;
        }
        if (event.getEntity().m_6095_().m_204039_(ModTags.EntityTypes.NO_EXPERIENCE)) {
            return;
        }
        GunData data = GunData.from(stack);
        double amount = 20.0f + 2.0f * event.getEntity().m_21233_();
        if (source.m_276093_(ModDamageTypes.PROJECTILE_EXPLOSION) && (stack.m_204117_(ModTags.Items.LAUNCHER) || GunData.from((ItemStack)stack).perk.getLevel(ModPerks.HE_BULLET) > 0)) {
            data.exp.set(data.exp.get() + amount);
        }
        if (DamageTypeTool.isGunDamage(source)) {
            data.exp.set(data.exp.get() + amount);
        }
        int level = data.level.get();
        double exp = data.exp.get();
        double upgradeExpNeeded = 20.0 * Math.pow(level, 2.0) + (double)(160 * level) + 20.0;
        while (exp >= upgradeExpNeeded) {
            level = data.level.get() + 1;
            upgradeExpNeeded = 20.0 * Math.pow(level, 2.0) + (double)(160 * level) + 20.0;
            data.exp.set(exp -= upgradeExpNeeded);
            data.level.set(level);
            data.upgradePoint.set(data.upgradePoint.get() + 0.5);
        }
    }

    private static void handleGunLevels(LivingHurtEvent event) {
        DamageSource source = event.getSource();
        if (source == null) {
            return;
        }
        Entity sourceEntity = source.m_7639_();
        if (!(sourceEntity instanceof Player)) {
            return;
        }
        Player player = (Player)sourceEntity;
        ItemStack stack = player.m_21205_();
        if (!(stack.m_41720_() instanceof GunItem)) {
            return;
        }
        if (event.getEntity().m_6095_().m_204039_(ModTags.EntityTypes.NO_EXPERIENCE)) {
            return;
        }
        GunData data = GunData.from(stack);
        int level = data.level.get();
        double exp = data.exp.get();
        double upgradeExpNeeded = 20.0 * Math.pow(level, 2.0) + (double)(160 * level) + 20.0;
        while (exp >= upgradeExpNeeded) {
            level = data.level.get() + 1;
            upgradeExpNeeded = 20.0 * Math.pow(level, 2.0) + (double)(160 * level) + 20.0;
            data.exp.set(exp -= upgradeExpNeeded);
            data.level.set(level);
            data.upgradePoint.set(data.upgradePoint.get() + 0.5);
        }
    }

    private static void killIndication(LivingDeathEvent event) {
        if (!((Boolean)MiscConfig.SEND_KILL_FEEDBACK.get()).booleanValue()) {
            return;
        }
        DamageSource source = event.getSource();
        Entity sourceEntity = source.m_7639_();
        if (sourceEntity == null) {
            return;
        }
        if (!((Boolean)GameplayConfig.GLOBAL_INDICATION.get()).booleanValue() && !DamageTypeTool.isModDamage(source)) {
            return;
        }
        if (!sourceEntity.m_9236_().m_5776_() && sourceEntity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)sourceEntity;
            if (MinecraftForge.EVENT_BUS.post((Event)new PreKillEvent.Indicator((LivingEntity)player, source, event.getEntity()))) {
                return;
            }
            SoundTool.playLocalSound(player, (SoundEvent)ModSounds.TARGET_DOWN.get(), 3.0f, 1.0f);
            Mod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> player), (Object)new ClientIndicatorMessage(2, 8));
        }
    }

    private static void renderDamageIndicator(LivingHurtEvent event) {
        if (event == null || event.getEntity() == null) {
            return;
        }
        DamageSource damagesource = event.getSource();
        Entity sourceEntity = damagesource.m_7639_();
        if (sourceEntity == null) {
            return;
        }
        if (sourceEntity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)sourceEntity;
            if (damagesource.m_276093_(DamageTypes.f_268565_) || damagesource.m_276093_(DamageTypes.f_268448_) || damagesource.m_276093_(ModDamageTypes.MINE) || damagesource.m_276093_(ModDamageTypes.PROJECTILE_EXPLOSION)) {
                SoundTool.playLocalSound(player, (SoundEvent)ModSounds.INDICATION.get(), 1.0f, 1.0f);
                Mod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> player), (Object)new ClientIndicatorMessage(0, 5));
            }
        }
    }

    @SubscribeEvent
    public static void handleChangeSlot(LivingEquipmentChangeEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (event.getSlot() == EquipmentSlot.MAINHAND) {
                if (player.m_9236_().f_46443_) {
                    return;
                }
                ItemStack oldStack = event.getFrom();
                ItemStack newStack = event.getTo();
                player.getCapability(ModCapabilities.LASER_CAPABILITY).ifPresent(LaserCapability.ILaserCapability::stop);
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    if (newStack.m_41720_() instanceof GunItem) {
                        LivingEventHandler.checkCopyGuns(newStack, player);
                    }
                    if (newStack.m_41720_() != oldStack.m_41720_() || newStack.m_41783_() == null || oldStack.m_41783_() == null || newStack.m_41720_() instanceof GunItem && !GunData.from(newStack).initialized() || oldStack.m_41720_() instanceof GunItem && !GunData.from(newStack).initialized() || newStack.m_41720_() instanceof GunItem && oldStack.m_41720_() instanceof GunItem && !Objects.equals(GunsTool.getGunUUID(newStack), GunsTool.getGunUUID(oldStack))) {
                        Perk.Type[] typeArray = oldStack.m_41720_();
                        if (typeArray instanceof GunItem) {
                            GunItem oldGun = (GunItem)typeArray;
                            LivingEventHandler.stopGunReloadSound(serverPlayer, oldGun);
                            GunData oldData = GunData.from(oldStack);
                            if (oldData.get(GunProp.BOLT_ACTION_TIME) > 0) {
                                oldData.bolt.actionTimer.reset();
                            }
                            oldData.reload.setTime(0);
                            oldData.reload.setState(ReloadState.NOT_RELOADING);
                            if (oldData.get(GunProp.ITERATIVE_TIME) != 0) {
                                oldData.stopped.set(false);
                                oldData.forceStop.set(false);
                                oldData.reload.setStage(0);
                                oldData.reload.prepareTimer.reset();
                                oldData.reload.prepareLoadTimer.reset();
                                oldData.reload.iterativeLoadTimer.reset();
                                oldData.reload.finishTimer.reset();
                            }
                            if (oldStack.m_150930_((Item)ModItems.SENTINEL.get())) {
                                oldData.charge.timer.reset();
                            }
                            oldGun.onChangeSlot(oldStack, player);
                        }
                        if (newStack.m_41720_() instanceof GunItem) {
                            GunData newData = GunData.from(newStack);
                            if (newData.get(GunProp.BOLT_ACTION_TIME) > 0) {
                                newData.bolt.actionTimer.reset();
                            }
                            newData.reload.setState(ReloadState.NOT_RELOADING);
                            newData.reload.reloadTimer.reset();
                            if (newData.get(GunProp.ITERATIVE_TIME) != 0) {
                                newData.forceStop.set(false);
                                newData.stopped.set(false);
                                newData.reload.setStage(0);
                                newData.reload.prepareTimer.reset();
                                newData.reload.prepareLoadTimer.reset();
                                newData.reload.iterativeLoadTimer.reset();
                                newData.reload.finishTimer.reset();
                            }
                            if (newStack.m_150930_((Item)ModItems.SENTINEL.get())) {
                                newData.charge.timer.reset();
                            }
                            for (Perk.Type type : Perk.Type.values()) {
                                PerkInstance instance = newData.perk.getInstance(type);
                                if (instance == null) continue;
                                instance.perk().onChangeSlot(newData, instance, (Entity)player);
                            }
                            if (player.m_9236_() instanceof ServerLevel) {
                                Mod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new DrawClientMessage(true));
                            }
                        }
                    }
                }
            }
        }
    }

    private static void checkCopyGuns(ItemStack stack, Player player) {
        GunData data = GunData.from(stack);
        if (!data.initialized()) {
            return;
        }
        if (data.data == null) {
            return;
        }
        UUID uuid = data.data.m_128342_("UUID");
        for (ItemStack item : player.m_150109_().f_35974_) {
            if (item.equals(stack) || !(item.m_41720_() instanceof GunItem)) continue;
            GunData itemData = GunData.from(item);
            CompoundTag dataTag = itemData.data;
            if (dataTag == null || !dataTag.m_128403_("UUID") || !dataTag.m_128342_("UUID").equals(uuid)) continue;
            data.data.m_128362_("UUID", UUID.randomUUID());
            return;
        }
    }

    private static void stopGunReloadSound(ServerPlayer player, GunItem gun) {
        gun.getReloadSound().forEach(sound -> player.f_8906_.m_9829_((Packet)new ClientboundStopSoundPacket(sound.m_11660_(), SoundSource.PLAYERS)));
    }

    private static void handlePlayerKillEntity(LivingDeathEvent event) {
        Projectile projectile;
        Entity entity;
        LivingEntity entity2 = event.getEntity();
        DamageSource source = event.getSource();
        ResourceKey damageTypeResourceKey = source.m_269150_().m_203543_().isPresent() ? (ResourceKey)source.m_269150_().m_203543_().get() : DamageTypes.f_268433_;
        LivingEntity attacker = null;
        Entity entity3 = source.m_7639_();
        if (entity3 instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity3;
            if (living instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)living;
                attacker = player;
            } else {
                attacker = living;
            }
        }
        if ((entity = source.m_7640_()) instanceof Projectile && (entity = (projectile = (Projectile)entity).m_19749_()) instanceof LivingEntity) {
            OwnableEntity ownableEntity;
            LivingEntity living = (LivingEntity)entity;
            if (living instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)living;
                attacker = player;
            } else if (living instanceof OwnableEntity && (ownableEntity = (OwnableEntity)living).m_269323_() instanceof ServerPlayer) {
                attacker = living;
            }
        }
        if (MinecraftForge.EVENT_BUS.post((Event)new PreKillEvent.SendKillMessage(attacker, source, entity2))) {
            return;
        }
        if (attacker != null && ((Boolean)MiscConfig.SEND_KILL_FEEDBACK.get()).booleanValue()) {
            if (DamageTypeTool.isHeadshotDamage(source)) {
                Mod.PACKET_HANDLER.send(PacketDistributor.ALL.noArg(), (Object)new LivingGunKillMessage(attacker.m_19879_(), entity2.m_19879_(), true, (ResourceKey<DamageType>)damageTypeResourceKey));
            } else {
                Mod.PACKET_HANDLER.send(PacketDistributor.ALL.noArg(), (Object)new LivingGunKillMessage(attacker.m_19879_(), entity2.m_19879_(), false, (ResourceKey<DamageType>)damageTypeResourceKey));
            }
        }
    }

    private static void handleGunPerksWhenHurt(LivingHurtEvent event) {
        Projectile projectile;
        Entity entity;
        DamageSource source = event.getSource();
        if (!DamageTypeTool.isGunDamage(source)) {
            return;
        }
        LivingEntity attacker = null;
        Entity entity2 = source.m_7639_();
        if (entity2 instanceof LivingEntity) {
            LivingEntity living;
            attacker = living = (LivingEntity)entity2;
        }
        if ((entity = source.m_7640_()) instanceof Projectile && (entity = (projectile = (Projectile)entity).m_19749_()) instanceof LivingEntity) {
            LivingEntity living;
            attacker = living = (LivingEntity)entity;
        }
        if (attacker == null) {
            return;
        }
        ItemStack stack = attacker.m_21205_();
        if (!(stack.m_41720_() instanceof GunItem)) {
            return;
        }
        float damage = event.getAmount();
        GunData data = GunData.from(stack);
        for (Perk.Type type : Perk.Type.values()) {
            PerkInstance instance = data.perk.getInstance(type);
            if (instance == null) continue;
            damage = instance.perk().getModifiedDamage(damage, data, instance, (Entity)event.getEntity(), source);
            instance.perk().onHurtEntity(damage, data, instance, (Entity)event.getEntity(), source);
        }
        event.setAmount(damage);
    }

    private static void handleGunPerksWhenDeath(LivingDeathEvent event) {
        Projectile projectile;
        Perk.Type[] typeArray;
        DamageSource source = event.getSource();
        if (!DamageTypeTool.isGunDamage(source)) {
            return;
        }
        LivingEntity attacker = null;
        Entity entity = source.m_7639_();
        if (entity instanceof LivingEntity) {
            LivingEntity living;
            attacker = living = (LivingEntity)entity;
        }
        if ((typeArray = source.m_7640_()) instanceof Projectile && (typeArray = (projectile = (Projectile)typeArray).m_19749_()) instanceof LivingEntity) {
            LivingEntity living;
            attacker = living = (LivingEntity)typeArray;
        }
        if (attacker == null) {
            return;
        }
        ItemStack stack = attacker.m_21205_();
        if (!(stack.m_41720_() instanceof GunItem)) {
            return;
        }
        GunData data = GunData.from(stack);
        for (Perk.Type type : Perk.Type.values()) {
            PerkInstance instance = data.perk.getInstance(type);
            if (instance == null) continue;
            instance.perk().onKill(data, instance, (Entity)event.getEntity(), source);
        }
    }

    @SubscribeEvent
    public static void onPickup(EntityItemPickupEvent event) {
        if (!((Boolean)VehicleConfig.VEHICLE_ITEM_PICKUP.get()).booleanValue()) {
            return;
        }
        Entity entity = event.getEntity().m_20202_();
        if (entity instanceof ContainerMobileVehicleEntity) {
            ContainerMobileVehicleEntity containerMobileVehicleEntity = (ContainerMobileVehicleEntity)entity;
            ItemEntity pickUp = event.getItem();
            if (!containerMobileVehicleEntity.m_9236_().f_46443_) {
                HopperBlockEntity.m_59331_((Container)containerMobileVehicleEntity, (ItemEntity)pickUp);
            }
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onLivingDrops(LivingDropsEvent event) {
        DamageSource source;
        Ammo[] ammoArray;
        Player player;
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player && !(player = (Player)livingEntity).m_9236_().m_6106_().m_5470_().m_46207_(GameRules.f_46133_)) {
            boolean drop;
            PlayerVariable cap = (PlayerVariable)player.getCapability(ModCapabilities.PLAYER_VARIABLE).orElse((Object)new PlayerVariable());
            cap.watch();
            boolean bl = drop = Stream.of(Ammo.values()).mapToInt(type -> type.get(cap)).sum() > 0;
            if (drop) {
                ItemStack stack = new ItemStack((ItemLike)ModItems.AMMO_BOX.get());
                ammoArray = Ammo.values();
                int n = ammoArray.length;
                for (int i = 0; i < n; ++i) {
                    Ammo type2 = ammoArray[i];
                    type2.set(stack, type2.get(cap));
                    type2.set(cap, 0);
                }
                stack.m_41784_().m_128379_("All", true);
                stack.m_41784_().m_128379_("IsDrop", true);
                cap.sync((Entity)player);
                event.getDrops().add(new ItemEntity(player.m_9236_(), player.m_20185_(), player.m_20186_() + 1.0, player.m_20189_(), stack));
            }
        }
        if ((source = event.getSource()) == null) {
            return;
        }
        Entity sourceEntity = source.m_7639_();
        if (!(sourceEntity instanceof Player)) {
            return;
        }
        Player player2 = (Player)sourceEntity;
        if (((Boolean)VehicleConfig.COLLECT_DROPS_BY_CRASHING.get()).booleanValue() && (ammoArray = player2.m_20202_()) instanceof ContainerMobileVehicleEntity) {
            ContainerMobileVehicleEntity containerMobileVehicleEntity = (ContainerMobileVehicleEntity)ammoArray;
            if (source.m_276093_(ModDamageTypes.VEHICLE_STRIKE)) {
                Collection drops = event.getDrops();
                ArrayList removed = new ArrayList();
                drops.forEach(itemEntity -> {
                    ItemStack stack = itemEntity.m_32055_();
                    InventoryTool.insertItem(containerMobileVehicleEntity.m_213659_(), stack);
                    if (stack.m_41613_() <= 0) {
                        player2.m_36176_(stack, false);
                        removed.add(itemEntity);
                    }
                });
                drops.removeAll(removed);
            }
        }
    }

    @SubscribeEvent
    public static void onLivingExperienceDrop(LivingExperienceDropEvent event) {
        Player player = event.getAttackingPlayer();
        if (player == null) {
            return;
        }
        if (player.m_20202_() instanceof ArmedVehicleEntity) {
            player.m_6756_(event.getDroppedExperience());
            event.setCanceled(true);
        }
    }

    public static void handlePlayerBeamReset(Player player) {
        player.getCapability(ModCapabilities.LASER_CAPABILITY).ifPresent(LaserCapability.ILaserCapability::end);
    }

    @SubscribeEvent
    public static void onKnockback(LivingKnockBackEvent event) {
        ICustomKnockback knockback = ICustomKnockback.getInstance(event.getEntity());
        if (knockback.superbWarfare$getKnockbackStrength() >= 0.0) {
            event.setStrength((float)knockback.superbWarfare$getKnockbackStrength());
        }
    }

    @SubscribeEvent
    public static void onEntityFall(LivingFallEvent event) {
        LivingEntity living = event.getEntity();
        if (living.m_20202_() instanceof VehicleEntity) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onPreSendKillMessage(PreKillEvent.SendKillMessage event) {
        if (event.getSource().m_7640_() instanceof AutoAimable && !(event.getTarget() instanceof Player)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onPreIndicator(PreKillEvent.Indicator event) {
        if (event.getSource().m_7640_() instanceof AutoAimable && !(event.getTarget() instanceof Player)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onEffectApply(MobEffectEvent.Applicable event) {
        VehicleEntity vehicle;
        Entity entity;
        if (event.getEffectInstance().m_19544_().m_19483_() == MobEffectCategory.HARMFUL && (entity = event.getEntity().m_20202_()) instanceof VehicleEntity && (vehicle = (VehicleEntity)entity).isEnclosed(vehicle.getSeatIndex((Entity)event.getEntity()))) {
            event.setResult(Event.Result.DENY);
        }
    }
}

