/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.event;

import com.atsuishio.superbwarfare.Mod;
import com.atsuishio.superbwarfare.client.MouseMovementHandler;
import com.atsuishio.superbwarfare.config.client.ControlConfig;
import com.atsuishio.superbwarfare.data.gun.GunData;
import com.atsuishio.superbwarfare.entity.vehicle.DroneEntity;
import com.atsuishio.superbwarfare.entity.vehicle.base.AirEntity;
import com.atsuishio.superbwarfare.entity.vehicle.base.VehicleEntity;
import com.atsuishio.superbwarfare.entity.vehicle.base.WeaponVehicleEntity;
import com.atsuishio.superbwarfare.event.ClientEventHandler;
import com.atsuishio.superbwarfare.init.ModItems;
import com.atsuishio.superbwarfare.init.ModMobEffects;
import com.atsuishio.superbwarfare.item.gun.GunItem;
import com.atsuishio.superbwarfare.network.message.send.MouseMoveMessage;
import com.atsuishio.superbwarfare.tools.EntityFindUtil;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec2;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ViewportEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class ClientMouseHandler {
    public static Vec2 posO = new Vec2(0.0f, 0.0f);
    public static Vec2 posN = new Vec2(0.0f, 0.0f);
    public static double lerpSpeedX = 0.0;
    public static double lerpSpeedY = 0.0;
    public static double speedX = 0.0;
    public static double speedY = 0.0;
    public static double freeCameraPitch = 0.0;
    public static double freeCameraYaw = 0.0;
    public static double custom3pDistance = 0.0;
    public static double custom3pDistanceLerp = 0.0;

    private static boolean notInGame() {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ == null) {
            return true;
        }
        if (mc.m_91265_() != null) {
            return true;
        }
        if (mc.f_91080_ != null) {
            return true;
        }
        if (!mc.f_91067_.m_91600_()) {
            return true;
        }
        return !mc.m_91302_();
    }

    @SubscribeEvent
    public static void handleClientTick(TickEvent.ClientTickEvent event) {
        VehicleEntity vehicle;
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        if (event.phase == TickEvent.Phase.START) {
            return;
        }
        if (ClientMouseHandler.notInGame()) {
            speedX = 0.0;
            speedY = 0.0;
            lerpSpeedX = 0.0;
            lerpSpeedY = 0.0;
        }
        posO = posN;
        posN = MouseMovementHandler.getMousePos();
        ItemStack stack = player.m_21205_();
        if (stack.m_150930_((Item)ModItems.MONITOR.get()) && stack.m_41784_().m_128471_("Using") && stack.m_41784_().m_128471_("Linked")) {
            DroneEntity drone = EntityFindUtil.findDrone(player.m_9236_(), stack.m_41784_().m_128461_("LinkedDrone"));
            if (drone != null) {
                if (ClientMouseHandler.notInGame()) {
                    Mod.PACKET_HANDLER.sendToServer((Object)new MouseMoveMessage(0.0, 0.0));
                    return;
                }
                speedX = drone.getMouseSensitivity() / ClientEventHandler.droneFovLerp * (double)(ClientMouseHandler.posN.f_82470_ - ClientMouseHandler.posO.f_82470_);
                speedY = drone.getMouseSensitivity() / ClientEventHandler.droneFovLerp * (double)(ClientMouseHandler.posN.f_82471_ - ClientMouseHandler.posO.f_82471_);
                lerpSpeedX = Mth.m_14139_((double)drone.getMouseSpeedX(), (double)lerpSpeedX, (double)speedX);
                lerpSpeedY = Mth.m_14139_((double)drone.getMouseSpeedY(), (double)lerpSpeedY, (double)speedY);
                Mod.PACKET_HANDLER.sendToServer((Object)new MouseMoveMessage(lerpSpeedX, lerpSpeedY));
            }
            return;
        }
        Entity entity = player.m_20202_();
        if (entity instanceof VehicleEntity && player == (vehicle = (VehicleEntity)entity).m_146895_()) {
            if (ClientMouseHandler.notInGame()) {
                Mod.PACKET_HANDLER.sendToServer((Object)new MouseMoveMessage(0.0, 0.0));
                return;
            }
            int y = 1;
            if (vehicle instanceof AirEntity && ((Boolean)ControlConfig.INVERT_AIRCRAFT_CONTROL.get()).booleanValue()) {
                y = -1;
            }
            speedX = vehicle.getMouseSensitivity() * (double)(ClientMouseHandler.posN.f_82470_ - ClientMouseHandler.posO.f_82470_);
            speedY = (double)y * vehicle.getMouseSensitivity() * (double)(ClientMouseHandler.posN.f_82471_ - ClientMouseHandler.posO.f_82471_);
            lerpSpeedX = Mth.m_14139_((double)vehicle.getMouseSpeedX(), (double)lerpSpeedX, (double)speedX);
            lerpSpeedY = Mth.m_14139_((double)vehicle.getMouseSpeedY(), (double)lerpSpeedY, (double)speedY);
            double i = 0.0;
            if (vehicle.getRoll() < 0.0f) {
                i = 1.0;
            } else if (vehicle.getRoll() > 0.0f) {
                i = -1.0;
            }
            if (Mth.m_14154_((float)vehicle.getRoll()) > 90.0f) {
                i *= (double)(1.0f - (Mth.m_14154_((float)vehicle.getRoll()) - 90.0f) / 90.0f);
            }
            if (!ClientEventHandler.isFreeCam((Player)player)) {
                if (Minecraft.m_91087_().f_91066_.m_92176_() == CameraType.FIRST_PERSON) {
                    Mod.PACKET_HANDLER.sendToServer((Object)new MouseMoveMessage((double)(1.0f - Mth.m_14154_((float)vehicle.getRoll()) / 90.0f) * lerpSpeedX + (double)(Mth.m_14154_((float)vehicle.getRoll()) / 90.0f) * lerpSpeedY * i, (double)(1.0f - Mth.m_14154_((float)vehicle.getRoll()) / 90.0f) * lerpSpeedY + (double)(Mth.m_14154_((float)vehicle.getRoll()) / 90.0f) * lerpSpeedX * (double)(vehicle.getRoll() < 0.0f ? -1 : 1)));
                } else {
                    Mod.PACKET_HANDLER.sendToServer((Object)new MouseMoveMessage(lerpSpeedX, lerpSpeedY));
                }
            } else {
                Mod.PACKET_HANDLER.sendToServer((Object)new MouseMoveMessage(0.0, 0.0));
            }
        }
    }

    @SubscribeEvent
    public static void handleClientTick(ViewportEvent.ComputeCameraAngles event) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        if (ClientMouseHandler.notInGame()) {
            freeCameraYaw = 0.0;
            freeCameraPitch = 0.0;
            return;
        }
        float times = Minecraft.m_91087_().m_91297_();
        freeCameraYaw -= (double)(0.4f * times) * lerpSpeedX;
        freeCameraPitch += (double)(0.3f * times) * lerpSpeedY;
        if (!ClientEventHandler.isFreeCam((Player)player)) {
            freeCameraYaw = Mth.m_14139_((double)(0.6 * (double)times), (double)freeCameraYaw, (double)0.0);
            freeCameraPitch = Mth.m_14139_((double)(0.6 * (double)times), (double)freeCameraPitch, (double)0.0);
        }
        while (freeCameraYaw > 180.0) {
            freeCameraYaw -= 360.0;
        }
        while (freeCameraYaw <= -180.0) {
            freeCameraYaw += 360.0;
        }
        while (freeCameraPitch > 180.0) {
            freeCameraPitch -= 360.0;
        }
        while (freeCameraPitch <= -180.0) {
            freeCameraPitch += 360.0;
        }
        custom3pDistanceLerp = Mth.m_14139_((double)times, (double)custom3pDistanceLerp, (double)custom3pDistance);
    }

    public static int invertY() {
        VehicleEntity vehicle;
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        if (player == null) {
            return 1;
        }
        Entity entity = player.m_20202_();
        if (entity instanceof VehicleEntity && (vehicle = (VehicleEntity)entity) instanceof AirEntity && vehicle.m_146895_() == player) {
            return (Boolean)ControlConfig.INVERT_AIRCRAFT_CONTROL.get() != false ? -1 : 1;
        }
        return 1;
    }

    public static double changeSensitivity(double original) {
        WeaponVehicleEntity weaponVehicle;
        VehicleEntity vehicle;
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        if (player == null) {
            return original;
        }
        if (player.m_21023_((MobEffect)ModMobEffects.SHOCK.get()) && !player.m_5833_()) {
            return 0.0;
        }
        ItemStack stack = mc.f_91074_.m_21205_();
        if (stack.m_150930_((Item)ModItems.MONITOR.get()) && stack.m_41784_().m_128471_("Using") && stack.m_41784_().m_128471_("Linked")) {
            return 0.0;
        }
        if (ClientEventHandler.isFreeCam((Player)player)) {
            return 0.0;
        }
        if (player.m_6117_() && player.m_21211_().m_150930_((Item)ModItems.ARTILLERY_INDICATOR.get()) && mc.f_91066_.m_92176_() == CameraType.FIRST_PERSON) {
            return original / Math.max(1.0 + 0.2 * ClientEventHandler.artilleryIndicatorZoom, 0.1);
        }
        Entity entity = player.m_20202_();
        if (entity instanceof VehicleEntity && (vehicle = (VehicleEntity)entity) instanceof WeaponVehicleEntity && (weaponVehicle = (WeaponVehicleEntity)((Object)vehicle)).banHand((LivingEntity)player)) {
            return vehicle.getSensitivity(original, ClientEventHandler.zoomVehicle, vehicle.getSeatIndex((Entity)player), vehicle.m_20096_());
        }
        if (stack.m_41720_() instanceof GunItem) {
            GunData data = GunData.from(stack);
            float customSens = data.sensitivity.get();
            if (!player.m_21205_().m_41619_() && mc.f_91066_.m_92176_() == CameraType.FIRST_PERSON) {
                return original / Math.max(1.0 + 0.2 * (data.zoom() - 0.3 * (double)customSens) * ClientEventHandler.zoomTime, 0.1) * (double)((float)((Integer)ControlConfig.MOUSE_SENSITIVITY.get()).intValue() / 100.0f);
            }
        }
        return original;
    }
}

