/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.entity.vehicle.base;

import com.atsuishio.superbwarfare.config.server.VehicleConfig;
import com.atsuishio.superbwarfare.entity.OBBEntity;
import com.atsuishio.superbwarfare.entity.TargetEntity;
import com.atsuishio.superbwarfare.entity.projectile.FlareDecoyEntity;
import com.atsuishio.superbwarfare.entity.projectile.SmokeDecoyEntity;
import com.atsuishio.superbwarfare.entity.vehicle.DroneEntity;
import com.atsuishio.superbwarfare.entity.vehicle.base.ControllableVehicle;
import com.atsuishio.superbwarfare.entity.vehicle.base.HelicopterEntity;
import com.atsuishio.superbwarfare.entity.vehicle.base.VehicleEntity;
import com.atsuishio.superbwarfare.init.ModBlocks;
import com.atsuishio.superbwarfare.init.ModDamageTypes;
import com.atsuishio.superbwarfare.init.ModMobEffects;
import com.atsuishio.superbwarfare.init.ModSounds;
import com.atsuishio.superbwarfare.init.ModTags;
import com.atsuishio.superbwarfare.tools.DamageHandler;
import com.atsuishio.superbwarfare.tools.EntityFindUtil;
import com.atsuishio.superbwarfare.tools.OBB;
import com.atsuishio.superbwarfare.tools.ParticleTool;
import com.mojang.math.Axis;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.StreamSupport;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.entity.vehicle.Minecart;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector4f;

public abstract class MobileVehicleEntity
extends VehicleEntity
implements ControllableVehicle {
    public static Consumer<MobileVehicleEntity> trackSound = vehicle -> {};
    public static Consumer<MobileVehicleEntity> engineSound = vehicle -> {};
    public static Consumer<MobileVehicleEntity> swimSound = vehicle -> {};
    public static final EntityDataAccessor<Integer> CANNON_RECOIL_TIME = SynchedEntityData.m_135353_(MobileVehicleEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Float> POWER = SynchedEntityData.m_135353_(MobileVehicleEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    public static final EntityDataAccessor<Float> YAW = SynchedEntityData.m_135353_(MobileVehicleEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    public static final EntityDataAccessor<Integer> FIRE_ANIM = SynchedEntityData.m_135353_(MobileVehicleEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> COAX_HEAT = SynchedEntityData.m_135353_(MobileVehicleEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> AMMO = SynchedEntityData.m_135353_(MobileVehicleEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> DECOY_COUNT = SynchedEntityData.m_135353_(MobileVehicleEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> GEAR_ROT = SynchedEntityData.m_135353_(MobileVehicleEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Boolean> GEAR_UP = SynchedEntityData.m_135353_(MobileVehicleEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> LANDING_INPUT_DOWN = SynchedEntityData.m_135353_(MobileVehicleEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Float> PLANE_BREAK = SynchedEntityData.m_135353_(MobileVehicleEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private Vec3 previousVelocity = Vec3.f_82478_;
    public double acceleration;
    public int decoyReloadCoolDown;
    public boolean leftInputDown;
    public boolean rightInputDown;
    public boolean forwardInputDown;
    public boolean backInputDown;
    public boolean upInputDown;
    public boolean downInputDown;
    public boolean decoyInputDown;
    public boolean fireInputDown;
    public boolean sprintInputDown;
    public double lastTickSpeed;
    public double lastTickVerticalSpeed;
    public int collisionCoolDown;
    private boolean wasEngineRunning = false;
    public float rudderRot;
    public float rudderRotO;
    public float leftWheelRot;
    public float rightWheelRot;
    public float leftWheelRotO;
    public float rightWheelRotO;
    public float leftTrackO;
    public float rightTrackO;
    public float leftTrack;
    public float rightTrack;
    public float rotorRot;
    public float rotorRotO;
    public float propellerRot;
    public float propellerRotO;
    public double recoilShake;
    public double recoilShakeO;
    public boolean cannotFireCoax;
    public int reloadCoolDown;
    public double velocityO;
    public double velocity;
    public float flap1LRot;
    public float flap1LRotO;
    public float flap1RRot;
    public float flap1RRotO;
    public float flap1L2Rot;
    public float flap1L2RotO;
    public float flap1R2Rot;
    public float flap1R2RotO;
    public float flap2LRot;
    public float flap2LRotO;
    public float flap2RRot;
    public float flap2RRotO;
    public float flap3Rot;
    public float flap3RotO;
    public float gearRotO;
    public static boolean IGNORE_ENTITY_GROUND_CHECK_STEPPING = false;

    public MobileVehicleEntity(EntityType<?> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    @Override
    public void processInput(short keys) {
        this.leftInputDown = (keys & 1) > 0;
        this.rightInputDown = (keys & 2) > 0;
        this.forwardInputDown = (keys & 4) > 0;
        this.backInputDown = (keys & 8) > 0;
        this.f_19804_.m_135381_(LANDING_INPUT_DOWN, (Object)((keys & 8) > 0 ? 1 : 0));
        this.upInputDown = (keys & 0x10) > 0;
        this.downInputDown = (keys & 0x20) > 0;
        this.decoyInputDown = (keys & 0x40) > 0;
        this.fireInputDown = (keys & 0x80) > 0;
        this.sprintInputDown = (keys & 0x100) > 0;
    }

    public void m_6123_(Player pPlayer) {
        if (pPlayer.m_6047_() && !this.m_9236_().f_46443_ && pPlayer.m_20186_() < this.m_20186_() + (double)this.m_20206_() && pPlayer.m_20186_() + (double)pPlayer.m_20206_() > this.m_20186_()) {
            double entitySize = pPlayer.m_20205_() * pPlayer.m_20206_();
            double thisSize = this.m_20205_() * this.m_20206_();
            double f = org.joml.Math.min((double)(entitySize / thisSize), (double)2.0);
            double f1 = org.joml.Math.min((double)(thisSize / entitySize), (double)4.0);
            this.m_20256_(this.m_20184_().m_82549_(new Vec3(pPlayer.m_20182_().m_82505_(this.m_20182_()).m_252839_()).m_82490_(0.15 * f * pPlayer.m_20184_().m_82553_())));
            pPlayer.m_20256_(pPlayer.m_20184_().m_82549_(new Vec3(this.m_20182_().m_82505_(pPlayer.m_20182_()).m_252839_()).m_82490_(0.1 * f1 * pPlayer.m_20184_().m_82553_())));
        }
    }

    @Override
    public void m_6075_() {
        if (!this.wasEngineRunning && this.engineRunning() && this.m_9236_().m_5776_()) {
            engineSound.accept(this);
            swimSound.accept(this);
            if (this.hasTracks()) {
                trackSound.accept(this);
            }
        }
        this.wasEngineRunning = this.engineRunning();
        this.turretYRotO = this.getTurretYRot();
        this.turretXRotO = this.getTurretXRot();
        this.gunYRotO = this.getGunYRot();
        this.gunXRotO = this.getGunXRot();
        this.leftWheelRotO = this.getLeftWheelRot();
        this.rightWheelRotO = this.getRightWheelRot();
        this.leftTrackO = this.getLeftTrack();
        this.rightTrackO = this.getRightTrack();
        this.rotorRotO = this.getRotorRot();
        this.rudderRotO = this.getRudderRot();
        this.propellerRotO = this.getPropellerRot();
        this.recoilShakeO = this.getRecoilShake();
        this.velocityO = this.getVelocity();
        this.lastTickSpeed = new Vec3(this.m_20184_().f_82479_, this.m_20184_().f_82480_ + 0.06, this.m_20184_().f_82481_).m_82553_();
        this.lastTickVerticalSpeed = this.m_20184_().f_82480_ + 0.06;
        if (this.collisionCoolDown > 0) {
            --this.collisionCoolDown;
        }
        this.flap1LRotO = this.getFlap1LRot();
        this.flap1RRotO = this.getFlap1RRot();
        this.flap1L2RotO = this.getFlap1L2Rot();
        this.flap1R2RotO = this.getFlap1R2Rot();
        this.flap2LRotO = this.getFlap2LRot();
        this.flap2RRotO = this.getFlap2RRot();
        this.flap3RotO = this.getFlap3Rot();
        this.gearRotO = ((Integer)this.f_19804_.m_135370_(GEAR_ROT)).intValue();
        super.m_6075_();
        Vec3 currentVelocity = this.m_20184_();
        Vec3 accelerationVec = currentVelocity.m_82546_(this.previousVelocity).m_82490_(20.0);
        this.acceleration = accelerationVec.m_82553_() * 20.0;
        this.previousVelocity = currentVelocity;
        double direct = (90.0 - MobileVehicleEntity.calculateAngle(this.m_20184_(), this.m_20252_(1.0f))) / 90.0;
        this.setVelocity(Mth.m_14139_((double)0.4, (double)this.getVelocity(), (double)(this.m_20184_().m_165924_() * direct * 20.0)));
        float deltaT = Math.abs(this.getTurretYRot() - this.turretYRotO);
        while (this.getTurretYRot() > 180.0f) {
            this.setTurretYRot(this.getTurretYRot() - 360.0f);
            this.turretYRotO = this.getTurretYRot() - deltaT;
        }
        while (this.getTurretYRot() <= -180.0f) {
            this.setTurretYRot(this.getTurretYRot() + 360.0f);
            this.turretYRotO = deltaT + this.getTurretYRot();
        }
        if ((Integer)this.f_19804_.m_135370_(COAX_HEAT) > 0) {
            this.f_19804_.m_135381_(COAX_HEAT, (Object)((Integer)this.f_19804_.m_135370_(COAX_HEAT) - 1));
        }
        if ((Integer)this.f_19804_.m_135370_(FIRE_ANIM) > 0) {
            this.f_19804_.m_135381_(FIRE_ANIM, (Object)((Integer)this.f_19804_.m_135370_(FIRE_ANIM) - 1));
        }
        if ((Integer)this.f_19804_.m_135370_(COAX_HEAT) < 40) {
            this.cannotFireCoax = false;
        }
        if (this.decoyReloadCoolDown > 0) {
            --this.decoyReloadCoolDown;
        }
        if ((Integer)this.f_19804_.m_135370_(COAX_HEAT) > 100) {
            this.cannotFireCoax = true;
            this.m_9236_().m_5594_(null, this.m_20097_(), (SoundEvent)ModSounds.MINIGUN_OVERHEAT.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
        }
        if ((Integer)this.f_19804_.m_135370_(CANNON_RECOIL_TIME) > 0) {
            this.f_19804_.m_135381_(CANNON_RECOIL_TIME, (Object)((Integer)this.f_19804_.m_135370_(CANNON_RECOIL_TIME) - 1));
        }
        this.setRecoilShake(Math.pow(((Integer)this.f_19804_.m_135370_(CANNON_RECOIL_TIME)).intValue(), 4.0) * 7.0E-7 * Math.sin(0.6283185307179586 * ((double)((Integer)this.f_19804_.m_135370_(CANNON_RECOIL_TIME)).intValue() - 2.5)));
        this.preventStacking();
        this.crushEntities(this.m_20184_());
        this.m_20256_(this.m_20184_().m_82520_(0.0, -0.06, 0.0));
        this.m_6478_(MoverType.SELF, this.m_20184_());
        this.collideSoftBlock();
        this.moveOnDragonTeeth();
        this.m_6210_();
    }

    public void releaseSmokeDecoy(Vec3 vec3) {
        if (this.decoyInputDown) {
            if ((Integer)this.f_19804_.m_135370_(DECOY_COUNT) > 0 && this.m_9236_() instanceof ServerLevel) {
                Entity passenger = this.m_146895_();
                for (int i = 0; i < 8; ++i) {
                    SmokeDecoyEntity smokeDecoyEntity = new SmokeDecoyEntity((LivingEntity)passenger, this.m_9236_());
                    smokeDecoyEntity.m_6034_(this.m_20185_(), this.m_20186_() + (double)this.m_20206_(), this.m_20189_());
                    smokeDecoyEntity.decoyShoot(this, vec3.m_82524_((-78.75f + 22.5f * (float)i) * ((float)Math.PI / 180)), 4.0f, 8.0f);
                    this.m_9236_().m_7967_((Entity)smokeDecoyEntity);
                }
                this.m_9236_().m_6269_(null, (Entity)this, (SoundEvent)ModSounds.DECOY_FIRE.get(), this.m_5720_(), 1.0f, 1.0f);
                this.decoyReloadCoolDown = 500;
                this.m_20088_().m_135381_(DECOY_COUNT, (Object)((Integer)this.m_20088_().m_135370_(DECOY_COUNT) - 1));
            }
            this.decoyInputDown = false;
        }
        if ((Integer)this.f_19804_.m_135370_(DECOY_COUNT) < 1 && this.decoyReloadCoolDown == 0 && this.m_9236_() instanceof ServerLevel) {
            this.f_19804_.m_135381_(DECOY_COUNT, (Object)((Integer)this.f_19804_.m_135370_(DECOY_COUNT) + 1));
            this.m_9236_().m_6269_(null, (Entity)this, (SoundEvent)ModSounds.DECOY_RELOAD.get(), this.m_5720_(), 1.0f, 1.0f);
            this.decoyReloadCoolDown = 500;
        }
    }

    public void releaseDecoy() {
        if (this.decoyInputDown) {
            if ((Integer)this.f_19804_.m_135370_(DECOY_COUNT) > 0 && this.m_9236_() instanceof ServerLevel) {
                Entity passenger = this.m_146895_();
                for (int i = 0; i < 4; ++i) {
                    FlareDecoyEntity flareDecoyEntity = new FlareDecoyEntity((LivingEntity)passenger, this.m_9236_());
                    flareDecoyEntity.m_6034_(this.m_20185_() + this.m_20184_().f_82479_, this.m_20186_() + 0.5 + this.m_20184_().f_82480_, this.m_20189_() + this.m_20184_().f_82481_);
                    flareDecoyEntity.decoyShoot(this, this.m_20252_(1.0f).m_82524_((float)(45 + 90 * i) * ((float)Math.PI / 180)), 0.8f, 8.0f);
                    this.m_9236_().m_7967_((Entity)flareDecoyEntity);
                }
                this.m_9236_().m_6269_(null, (Entity)this, (SoundEvent)ModSounds.DECOY_FIRE.get(), this.m_5720_(), 2.0f, 1.0f);
                if ((Integer)this.m_20088_().m_135370_(DECOY_COUNT) == 4) {
                    this.decoyReloadCoolDown = 300;
                }
                this.m_20088_().m_135381_(DECOY_COUNT, (Object)((Integer)this.m_20088_().m_135370_(DECOY_COUNT) - 1));
            }
            this.decoyInputDown = false;
        }
        if ((Integer)this.f_19804_.m_135370_(DECOY_COUNT) < 4 && this.decoyReloadCoolDown == 0 && this.m_9236_() instanceof ServerLevel) {
            this.f_19804_.m_135381_(DECOY_COUNT, (Object)((Integer)this.f_19804_.m_135370_(DECOY_COUNT) + 1));
            this.m_9236_().m_6269_(null, (Entity)this, (SoundEvent)ModSounds.DECOY_RELOAD.get(), this.m_5720_(), 1.0f, 1.0f);
            this.decoyReloadCoolDown = 300;
        }
    }

    public void inertiaRotate(float multiple) {
        float angleX = 0.0f;
        float diffX = (float)(this.getAcceleration() * (double)multiple - (double)angleX);
        this.m_146926_(this.m_146909_() - 0.5f * diffX);
    }

    public static List<Entity> getPlayer(Level level) {
        return StreamSupport.stream(EntityFindUtil.getEntities(level).m_142273_().spliterator(), false).filter(e -> e instanceof Player).toList();
    }

    public void terrainCompact(float w, float l) {
        if (this.m_20096_()) {
            Matrix4f transform = this.getWheelsTransform(1.0f);
            Vector4f positionLF = this.transformPosition(transform, w / 2.0f, 0.0f, l / 2.0f);
            Vector4f positionRF = this.transformPosition(transform, -w / 2.0f, 0.0f, l / 2.0f);
            Vector4f positionLB = this.transformPosition(transform, w / 2.0f, 0.0f, -l / 2.0f);
            Vector4f positionRB = this.transformPosition(transform, -w / 2.0f, 0.0f, -l / 2.0f);
            Vec3 p1 = new Vec3((double)positionLF.x, (double)positionLF.y, (double)positionLF.z);
            Vec3 p2 = new Vec3((double)positionRF.x, (double)positionRF.y, (double)positionRF.z);
            Vec3 p3 = new Vec3((double)positionLB.x, (double)positionLB.y, (double)positionLB.z);
            Vec3 p4 = new Vec3((double)positionRB.x, (double)positionRB.y, (double)positionRB.z);
            float p1y = (float)this.traceBlockY(p1, 3.0);
            float p2y = (float)this.traceBlockY(p2, 3.0);
            float p3y = (float)this.traceBlockY(p3, 3.0);
            float p4y = (float)this.traceBlockY(p4, 3.0);
            p1 = new Vec3((double)positionLF.x, (double)p1y, (double)positionLF.z);
            p2 = new Vec3((double)positionRF.x, (double)p2y, (double)positionRF.z);
            p3 = new Vec3((double)positionLB.x, (double)p3y, (double)positionLB.z);
            p4 = new Vec3((double)positionRB.x, (double)p4y, (double)positionRB.z);
            Vec3 v0 = p3.m_82505_(p1);
            Vec3 v1 = p4.m_82505_(p2);
            Vec3 v2 = p1.m_82505_(p2);
            Vec3 v3 = p3.m_82505_(p4);
            double x1 = MobileVehicleEntity.getXRotFromVector(v0);
            double x2 = MobileVehicleEntity.getXRotFromVector(v1);
            double z1 = MobileVehicleEntity.getXRotFromVector(v2);
            double z2 = MobileVehicleEntity.getXRotFromVector(v3);
            float diffX = org.joml.Math.clamp((float)-15.0f, (float)15.0f, (float)Mth.m_14177_((float)((float)(-(x1 + x2)) - this.m_146909_())));
            this.m_146926_(Mth.m_14036_((float)(this.m_146909_() + 0.15f * diffX), (float)-45.0f, (float)45.0f));
            float diffZ = org.joml.Math.clamp((float)-15.0f, (float)15.0f, (float)Mth.m_14177_((float)((float)(-(z1 + z2)) - this.getRoll())));
            this.setZRot(Mth.m_14036_((float)(this.getRoll() + 0.15f * diffZ), (float)-45.0f, (float)45.0f));
        } else if (this.m_20069_()) {
            this.m_146926_(this.m_146909_() * 0.9f);
            this.setZRot(this.getRoll() * 0.9f);
        }
    }

    public float[] terrainCompactTrackValue(float w, float l) {
        Matrix4f transform = this.getWheelsTransform(1.0f);
        Vector4f positionLF = this.transformPosition(transform, w / 2.0f, 0.0f, l / 2.0f);
        Vector4f positionRF = this.transformPosition(transform, -w / 2.0f, 0.0f, l / 2.0f);
        Vector4f positionLB = this.transformPosition(transform, w / 2.0f, 0.0f, -l / 2.0f);
        Vector4f positionRB = this.transformPosition(transform, -w / 2.0f, 0.0f, -l / 2.0f);
        Vec3 p1 = new Vec3((double)positionLF.x, (double)positionLF.y, (double)positionLF.z);
        Vec3 p2 = new Vec3((double)positionRF.x, (double)positionRF.y, (double)positionRF.z);
        Vec3 p3 = new Vec3((double)positionLB.x, (double)positionLB.y, (double)positionLB.z);
        Vec3 p4 = new Vec3((double)positionRB.x, (double)positionRB.y, (double)positionRB.z);
        float p1y = (float)this.traceBlockY(p1, 3.0);
        float p2y = (float)this.traceBlockY(p2, 3.0);
        float p3y = (float)this.traceBlockY(p3, 3.0);
        float p4y = (float)this.traceBlockY(p4, 3.0);
        p1 = new Vec3((double)positionLF.x, (double)p1y, (double)positionLF.z);
        p2 = new Vec3((double)positionRF.x, (double)p2y, (double)positionRF.z);
        p3 = new Vec3((double)positionLB.x, (double)p3y, (double)positionLB.z);
        p4 = new Vec3((double)positionRB.x, (double)p4y, (double)positionRB.z);
        Vec3 v0 = p3.m_82505_(p1);
        Vec3 v1 = p4.m_82505_(p2);
        Vec3 v2 = p1.m_82505_(p2);
        Vec3 v3 = p3.m_82505_(p4);
        double x1 = MobileVehicleEntity.getXRotFromVector(v0);
        double x2 = MobileVehicleEntity.getXRotFromVector(v1);
        double z1 = MobileVehicleEntity.getXRotFromVector(v2);
        double z2 = MobileVehicleEntity.getXRotFromVector(v3);
        float x = org.joml.Math.clamp((float)-15.0f, (float)15.0f, (float)Mth.m_14177_((float)((float)(-(x1 + x2)) - this.m_146909_())));
        float z = org.joml.Math.clamp((float)-15.0f, (float)15.0f, (float)Mth.m_14177_((float)((float)(-(z1 + z2)) - this.getRoll())));
        return new float[]{x, z};
    }

    public Matrix4f getWheelsTransform(float ticks) {
        Matrix4f transform = new Matrix4f();
        transform.translate((float)Mth.m_14139_((double)ticks, (double)this.f_19854_, (double)this.m_20185_()), (float)Mth.m_14139_((double)ticks, (double)this.f_19855_, (double)this.m_20186_()), (float)Mth.m_14139_((double)ticks, (double)this.f_19856_, (double)this.m_20189_()));
        transform.rotate((Quaternionfc)Axis.f_252436_.m_252977_(-Mth.m_14179_((float)ticks, (float)this.f_19859_, (float)this.m_146908_())));
        return transform;
    }

    public double traceBlockY(Vec3 pos, double maxLength) {
        BlockHitResult res = this.m_9236_().m_45547_(new ClipContext(pos, pos.m_82520_(0.0, -maxLength, 0.0), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this));
        BlockState state = this.m_9236_().m_8055_(BlockPos.m_274446_((Position)pos));
        VoxelShape shape = state.m_60812_((BlockGetter)this.m_9236_(), BlockPos.m_274446_((Position)pos));
        double targetY = !shape.m_83281_() ? pos.f_82480_ + shape.m_83297_(Direction.Axis.Y) : (res.m_6662_() == HitResult.Type.BLOCK && this.m_9236_().m_45772_(new AABB(pos, pos)) ? res.m_82450_().f_82480_ : pos.f_82480_ - maxLength);
        double diffY = targetY - pos.f_82480_;
        return pos.f_82480_ + 0.5 * diffY;
    }

    public void moveOnDragonTeeth() {
        BlockState state;
        AABB aabb = this.m_20191_();
        AABB aabb1 = new AABB(aabb.f_82288_, aabb.f_82289_ - 1.0E-6, aabb.f_82290_, aabb.f_82291_, aabb.f_82289_, aabb.f_82293_);
        Optional optional = this.m_9236_().m_285750_((Entity)this, aabb1);
        if (optional.isPresent() && (state = this.m_9236_().m_8055_((BlockPos)optional.get())).m_60713_((Block)ModBlocks.DRAGON_TEETH.get())) {
            this.f_19804_.m_135381_(POWER, (Object)Float.valueOf(((Float)this.f_19804_.m_135370_(POWER)).floatValue() * 0.8f));
            this.m_20256_(this.m_20184_().m_82542_(-0.1, 0.0, -0.1));
        }
    }

    public void collideSoftBlock() {
        if (!((Boolean)VehicleConfig.COLLISION_DESTROY_SOFT_BLOCKS.get()).booleanValue()) {
            return;
        }
        AABB aabb = this.m_20191_().m_82377_(0.25, 1.0, 0.25).m_82363_(0.0, 0.5, 1.0).m_82383_(this.m_20184_().m_82490_(1.2));
        BlockPos.m_121921_((AABB)aabb).forEach(pos -> {
            BlockState blockstate = this.m_9236_().m_8055_(pos);
            if (blockstate.m_204336_(ModTags.Blocks.SOFT_COLLISION)) {
                this.m_9236_().m_46961_(pos, true);
            }
        });
    }

    public void collideNormalBlock() {
        if (!((Boolean)VehicleConfig.COLLISION_DESTROY_NORMAL_BLOCKS.get()).booleanValue()) {
            return;
        }
        AABB aabb = this.m_20191_().m_82377_(0.25, 1.0, 0.25).m_82363_(0.0, 0.5, 1.0).m_82383_(this.m_20184_().m_82490_(1.2));
        BlockPos.m_121921_((AABB)aabb).forEach(pos -> {
            BlockState blockstate = this.m_9236_().m_8055_(pos);
            if (blockstate.m_204336_(ModTags.Blocks.NORMAL_COLLISION)) {
                this.m_9236_().m_46961_(pos, true);
            }
        });
    }

    public void collideHardBlock() {
        if (!((Boolean)VehicleConfig.COLLISION_DESTROY_HARD_BLOCKS.get()).booleanValue()) {
            return;
        }
        AABB aabb = this.m_20191_().m_82377_(0.25, 1.0, 0.25).m_82363_(0.0, 0.5, 1.0).m_82383_(this.m_20184_().m_82490_(1.2));
        BlockPos.m_121921_((AABB)aabb).forEach(pos -> {
            BlockState blockstate = this.m_9236_().m_8055_(pos);
            if (blockstate.m_204336_(ModTags.Blocks.HARD_COLLISION)) {
                this.m_9236_().m_46961_(pos, true);
                this.m_20256_(this.m_20184_().m_82490_(0.95));
            }
        });
    }

    public void collideBlockBeastly() {
        if (!((Boolean)VehicleConfig.COLLISION_DESTROY_BLOCKS_BEASTLY.get()).booleanValue()) {
            return;
        }
        AABB aabb = this.m_20191_().m_82377_(0.25, 1.0, 0.25).m_82363_(0.0, 0.52, 1.0).m_82383_(this.m_20184_().m_82490_(1.2));
        BlockPos.m_121921_((AABB)aabb).forEach(pos -> {
            BlockState blockstate = this.m_9236_().m_8055_(pos);
            float hardness = blockstate.m_60734_().m_155943_();
            if (hardness > 0.0f && hardness <= 4.0f) {
                this.m_9236_().m_46961_(pos, true);
            }
        });
    }

    public boolean canCollideHardBlock() {
        return false;
    }

    public boolean canCollideBlockBeastly() {
        return false;
    }

    public void m_6478_(@NotNull MoverType movementType, @NotNull Vec3 movement) {
        if (!this.m_9236_().m_5776_()) {
            IGNORE_ENTITY_GROUND_CHECK_STEPPING = true;
        }
        if (this.m_9236_() instanceof ServerLevel && this.canCollideBlockBeastly()) {
            this.collideBlockBeastly();
        }
        super.m_6478_(movementType, movement);
        if (this.f_19862_) {
            this.collideNormalBlock();
            if (this.canCollideHardBlock()) {
                this.collideHardBlock();
            }
        }
        if (this.lastTickSpeed < 0.3 || this.collisionCoolDown > 0 || this instanceof DroneEntity) {
            return;
        }
        Entity driver = EntityFindUtil.findEntity(this.m_9236_(), (String)this.f_19804_.m_135370_(LAST_DRIVER_UUID));
        if (this.f_19863_) {
            if (this instanceof HelicopterEntity) {
                this.m_6469_(ModDamageTypes.causeVehicleStrikeDamage(this.m_9236_().m_9598_(), this, driver == null ? this : driver), (float)(60.0 * ((this.lastTickSpeed - 0.3) * (this.lastTickSpeed - 0.3))));
                this.bounceVertical(Direction.m_122366_((double)this.m_20184_().m_7096_(), (double)this.m_20184_().m_7098_(), (double)this.m_20184_().m_7094_()).m_122424_());
            } else if ((double)Mth.m_14154_((float)((float)this.lastTickVerticalSpeed)) > 0.4) {
                this.m_6469_(ModDamageTypes.causeVehicleStrikeDamage(this.m_9236_().m_9598_(), this, driver == null ? this : driver), (float)(96.0 * (((double)Mth.m_14154_((float)((float)this.lastTickVerticalSpeed)) - 0.4) * (this.lastTickSpeed - 0.3) * (this.lastTickSpeed - 0.3))));
                if (!this.m_9236_().f_46443_) {
                    this.m_9236_().m_6269_(null, (Entity)this, (SoundEvent)ModSounds.VEHICLE_STRIKE.get(), this.m_5720_(), 1.0f, 1.0f);
                }
                this.bounceVertical(Direction.m_122366_((double)this.m_20184_().m_7096_(), (double)this.m_20184_().m_7098_(), (double)this.m_20184_().m_7094_()).m_122424_());
            }
        }
        if (this.f_19862_) {
            this.m_6469_(ModDamageTypes.causeVehicleStrikeDamage(this.m_9236_().m_9598_(), this, driver == null ? this : driver), (float)(126.0 * ((this.lastTickSpeed - 0.4) * (this.lastTickSpeed - 0.4))));
            this.bounceHorizontal(Direction.m_122366_((double)this.m_20184_().m_7096_(), (double)this.m_20184_().m_7098_(), (double)this.m_20184_().m_7094_()).m_122424_());
            if (!this.m_9236_().f_46443_) {
                this.m_9236_().m_6269_(null, (Entity)this, (SoundEvent)ModSounds.VEHICLE_STRIKE.get(), this.m_5720_(), 1.0f, 1.0f);
            }
            this.collisionCoolDown = 4;
            this.crash = true;
            this.f_19804_.m_135381_(POWER, (Object)Float.valueOf(0.8f * ((Float)this.f_19804_.m_135370_(POWER)).floatValue()));
        }
    }

    public void bounceHorizontal(Direction direction) {
        switch (direction.m_122434_()) {
            case X: {
                this.m_20256_(this.m_20184_().m_82542_(0.8, 0.99, 0.99));
                break;
            }
            case Z: {
                this.m_20256_(this.m_20184_().m_82542_(0.99, 0.99, 0.8));
            }
        }
    }

    public void bounceVertical(Direction direction) {
        if (!this.m_9236_().f_46443_) {
            this.m_9236_().m_6269_(null, (Entity)this, (SoundEvent)ModSounds.VEHICLE_STRIKE.get(), this.m_5720_(), 1.0f, 1.0f);
        }
        this.collisionCoolDown = 4;
        this.crash = true;
        if (direction.m_122434_() == Direction.Axis.Y) {
            this.m_20256_(this.m_20184_().m_82542_(0.9, -0.8, 0.9));
        }
    }

    public void preventStacking() {
        List entities = this.m_9236_().m_142425_(EntityTypeTest.m_156916_(VehicleEntity.class), this.m_20191_(), entity -> entity != this && entity != this.m_146895_() && entity.m_20202_() == null);
        for (VehicleEntity entity2 : entities) {
            Vec3 toVec = this.m_20182_().m_82549_(new Vec3(1.0, 1.0, 1.0).m_82490_((double)(this.f_19796_.m_188501_() * 0.01f + 1.0f))).m_82505_(entity2.m_20182_());
            Vec3 velAdd = toVec.m_82541_().m_82490_(org.joml.Math.max((double)((double)(this.m_20205_() + 2.0f) - this.m_20182_().m_82554_(entity2.m_20182_())), (double)0.0) * 0.002);
            double entitySize = entity2.m_20205_() * entity2.m_20206_();
            double thisSize = this.m_20205_() * this.m_20206_();
            double f = org.joml.Math.min((double)(entitySize / thisSize), (double)2.0);
            double f1 = org.joml.Math.min((double)(thisSize / entitySize), (double)2.0);
            this.pushNew(-f * velAdd.f_82479_, -f * velAdd.f_82480_, -f * velAdd.f_82481_);
            entity2.m_5997_(f1 * velAdd.f_82479_, f1 * velAdd.f_82480_, f1 * velAdd.f_82481_);
        }
    }

    public void pushNew(double pX, double pY, double pZ) {
        this.m_20256_(this.m_20184_().m_82520_(pX, pY, pZ));
    }

    public void crushEntities(Vec3 velocity) {
        if (this.m_9236_() instanceof ServerLevel) {
            List<Entity> entities;
            if (!this.canCrushEntities()) {
                return;
            }
            if (this.m_213877_()) {
                return;
            }
            MobileVehicleEntity mobileVehicleEntity = this;
            if (mobileVehicleEntity instanceof OBBEntity) {
                OBBEntity obbEntity = (OBBEntity)((Object)mobileVehicleEntity);
                frontBox = this.m_20191_().m_82383_(velocity).m_82400_(4.0);
                entities = this.m_9236_().m_142425_(EntityTypeTest.m_156916_(Entity.class), frontBox, entity -> entity != this && entity != this.m_146895_() && entity.m_20202_() == null).stream().filter(entity -> {
                    if (entity.m_6084_() && this.isInObb(obbEntity, (Entity)entity, velocity)) {
                        Player player;
                        LivingEntity living;
                        ResourceLocation type = ForgeRegistries.ENTITY_TYPES.getKey((Object)entity.m_6095_());
                        if (type == null) {
                            return false;
                        }
                        return entity instanceof VehicleEntity || entity instanceof Boat || entity instanceof Minecart || entity instanceof LivingEntity && (!((living = (LivingEntity)entity) instanceof Player) || !(player = (Player)living).m_5833_()) || ((List)VehicleConfig.COLLISION_ENTITY_WHITELIST.get()).contains(type.toString());
                    }
                    return false;
                }).toList();
            } else {
                frontBox = this.m_20191_().m_82383_(velocity);
                entities = this.m_9236_().m_142425_(EntityTypeTest.m_156916_(Entity.class), frontBox, entity -> entity != this && entity != this.m_146895_() && entity.m_20202_() == null).stream().filter(entity -> {
                    if (entity.m_6084_()) {
                        Player player;
                        LivingEntity living;
                        ResourceLocation type = ForgeRegistries.ENTITY_TYPES.getKey((Object)entity.m_6095_());
                        if (type == null) {
                            return false;
                        }
                        return entity instanceof VehicleEntity || entity instanceof Boat || entity instanceof Minecart || entity instanceof LivingEntity && (!((living = (LivingEntity)entity) instanceof Player) || !(player = (Player)living).m_5833_()) || ((List)VehicleConfig.COLLISION_ENTITY_WHITELIST.get()).contains(type.toString());
                    }
                    return false;
                }).toList();
            }
            for (Entity entity2 : entities) {
                double f1;
                double f;
                LivingEntity living;
                double entitySize = entity2.m_20191_().m_82309_();
                double thisSize = this.m_20191_().m_82309_();
                if (entity2 instanceof LivingEntity && (living = (LivingEntity)entity2).m_21023_((MobEffect)ModMobEffects.STRIKE_PROTECTION.get())) {
                    return;
                }
                if (entity2 instanceof VehicleEntity) {
                    VehicleEntity vehicle = (VehicleEntity)entity2;
                    f = Mth.m_14008_((double)(vehicle.getMass() / this.getMass()), (double)0.25, (double)4.0);
                    f1 = Mth.m_14008_((double)(this.getMass() / vehicle.getMass()), (double)0.25, (double)4.0);
                } else {
                    f = Mth.m_14008_((double)(entitySize / thisSize), (double)0.25, (double)4.0);
                    f1 = Mth.m_14008_((double)(thisSize / entitySize), (double)0.25, (double)4.0);
                }
                float v = (float)velocity.m_82526_(this.m_20182_().m_82505_(entity2.m_20182_()));
                Vec3 velAdd = this.m_20182_().m_82505_(entity2.m_20182_()).m_82541_().m_82490_(0.1 * (double)v);
                if ((double)Mth.m_14154_((float)v) > 0.3) {
                    if (!this.m_9236_().f_46443_) {
                        this.m_9236_().m_6269_(null, (Entity)this, (SoundEvent)ModSounds.VEHICLE_STRIKE.get(), this.m_5720_(), 1.0f, 1.0f);
                    }
                    if (entity2 instanceof LivingEntity) {
                        DamageHandler.doDamage(entity2, ModDamageTypes.causeVehicleStrikeDamage(this.m_9236_().m_9598_(), this, this.m_146895_() == null ? this : this.m_146895_()), (float)(f1 * 5.0 * ((double)Mth.m_14154_((float)v) - 0.3) * ((double)Mth.m_14154_((float)v) - 0.3)));
                    } else {
                        entity2.m_6469_(ModDamageTypes.causeVehicleStrikeDamage(this.m_9236_().m_9598_(), this, this.m_146895_() == null ? this : this.m_146895_()), (float)(f1 * 2.0 * ((double)Mth.m_14154_((float)v) - 0.3) * ((double)Mth.m_14154_((float)v) - 0.3)));
                    }
                    if (entity2 instanceof VehicleEntity) {
                        this.m_6469_(ModDamageTypes.causeVehicleStrikeDamage(this.m_9236_().m_9598_(), entity2, entity2.m_146895_() == null ? entity2 : entity2.m_146895_()), (float)(f * ((double)Mth.m_14154_((float)v) - 0.3) * ((double)Mth.m_14154_((float)v) - 0.3)));
                    }
                    if (!(entity2 instanceof TargetEntity)) {
                        this.pushNew((double)-0.3f * f * velAdd.f_82479_, (double)-0.3f * f * velAdd.f_82480_, (double)-0.3f * f * velAdd.f_82481_);
                    }
                    if (entity2 instanceof MobileVehicleEntity) {
                        MobileVehicleEntity mobileVehicle = (MobileVehicleEntity)entity2;
                        mobileVehicle.pushNew(f1 * velAdd.f_82479_, f1 * velAdd.f_82480_, f1 * velAdd.f_82481_);
                        continue;
                    }
                    entity2.m_5997_(f1 * velAdd.f_82479_, f1 * velAdd.f_82480_, f1 * velAdd.f_82481_);
                    continue;
                }
                entity2.m_5997_(0.3 * f1 * velAdd.f_82479_, 0.3 * f1 * velAdd.f_82480_, 0.3 * f1 * velAdd.f_82481_);
            }
        }
    }

    public boolean isInObb(OBBEntity obbEntity, Entity entity, Vec3 velocity) {
        List<OBB> obbList = obbEntity.getOBBs();
        for (OBB obb : obbList) {
            obb = obb.move(velocity);
            if (entity instanceof OBBEntity) {
                OBBEntity obbEntity2 = (OBBEntity)entity;
                List<OBB> obbList2 = obbEntity2.getOBBs();
                Iterator<OBB> iterator = obbList2.iterator();
                if (!iterator.hasNext()) continue;
                OBB obb2 = iterator.next();
                return OBB.isColliding(obb, obb2);
            }
            return OBB.isColliding(obb, entity.m_20191_());
        }
        return false;
    }

    public Vector3f getForwardDirection() {
        return new Vector3f(Mth.m_14031_((float)(-this.m_146908_() * ((float)Math.PI / 180))), 0.0f, Mth.m_14089_((float)(this.m_146908_() * ((float)Math.PI / 180)))).normalize();
    }

    public Vector3f getRightDirection() {
        return new Vector3f(Mth.m_14089_((float)(-this.m_146908_() * ((float)Math.PI / 180))), 0.0f, Mth.m_14031_((float)(this.m_146908_() * ((float)Math.PI / 180)))).normalize();
    }

    public SoundEvent getEngineSound() {
        return SoundEvents.f_271165_;
    }

    public float getEngineSoundVolume() {
        return (float)Mth.m_14139_((double)Mth.m_14008_((double)this.m_20184_().m_82553_(), (double)0.0, (double)0.5), (double)0.0, (double)0.7f);
    }

    public double getVelocity() {
        return this.velocity;
    }

    public void setVelocity(double pV) {
        this.velocity = pV;
    }

    public double getAcceleration() {
        return this.getVelocity() - this.velocityO;
    }

    public float getRudderRot() {
        return this.rudderRot;
    }

    public void setRudderRot(float pRudderRot) {
        this.rudderRot = pRudderRot;
    }

    public float getLeftWheelRot() {
        return this.leftWheelRot;
    }

    public void setLeftWheelRot(float pLeftWheelRot) {
        this.leftWheelRot = pLeftWheelRot;
    }

    public float getRightWheelRot() {
        return this.rightWheelRot;
    }

    public void setRightWheelRot(float pRightWheelRot) {
        this.rightWheelRot = pRightWheelRot;
    }

    public float getLeftTrack() {
        return this.leftTrack;
    }

    public void setLeftTrack(float pLeftTrack) {
        this.leftTrack = pLeftTrack;
    }

    public float getRightTrack() {
        return this.rightTrack;
    }

    public void setRightTrack(float pRightTrack) {
        this.rightTrack = pRightTrack;
    }

    public float getRotorRot() {
        return this.rotorRot;
    }

    public void setRotorRot(float pRotorRot) {
        this.rotorRot = pRotorRot;
    }

    public float getPropellerRot() {
        return this.propellerRot;
    }

    public void setPropellerRot(float pPropellerRot) {
        this.propellerRot = pPropellerRot;
    }

    public double getRecoilShake() {
        return this.recoilShake;
    }

    public void setRecoilShake(double pRecoilShake) {
        this.recoilShake = pRecoilShake;
    }

    public float getFlap1LRot() {
        return this.flap1LRot;
    }

    public void setFlap1L2Rot(float pFlap1L2Rot) {
        this.flap1L2Rot = pFlap1L2Rot;
    }

    public float getFlap1R2Rot() {
        return this.flap1R2Rot;
    }

    public void setFlap1R2Rot(float pFlap1R2Rot) {
        this.flap1R2Rot = pFlap1R2Rot;
    }

    public float getFlap1L2Rot() {
        return this.flap1L2Rot;
    }

    public void setFlap1LRot(float pFlap1LRot) {
        this.flap1LRot = pFlap1LRot;
    }

    public float getFlap1RRot() {
        return this.flap1RRot;
    }

    public void setFlap1RRot(float pFlap1RRot) {
        this.flap1RRot = pFlap1RRot;
    }

    public float getFlap2LRot() {
        return this.flap2LRot;
    }

    public void setFlap2LRot(float pFlap2LRot) {
        this.flap2LRot = pFlap2LRot;
    }

    public float getFlap2RRot() {
        return this.flap2RRot;
    }

    public void setFlap2RRot(float pFlap2RRot) {
        this.flap2RRot = pFlap2RRot;
    }

    public float getFlap3Rot() {
        return this.flap3Rot;
    }

    public void setFlap3Rot(float pFlap3Rot) {
        this.flap3Rot = pFlap3Rot;
    }

    public boolean hasDecoy() {
        return false;
    }

    public boolean engineRunning() {
        return org.joml.Math.abs((float)((Float)this.f_19804_.m_135370_(POWER)).floatValue()) > 0.0f;
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(CANNON_RECOIL_TIME, (Object)0);
        this.f_19804_.m_135372_(POWER, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(YAW, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(AMMO, (Object)0);
        this.f_19804_.m_135372_(FIRE_ANIM, (Object)0);
        this.f_19804_.m_135372_(COAX_HEAT, (Object)0);
        this.f_19804_.m_135372_(DECOY_COUNT, (Object)0);
        this.f_19804_.m_135372_(GEAR_ROT, (Object)0);
        this.f_19804_.m_135372_(GEAR_UP, (Object)false);
        this.f_19804_.m_135372_(LANDING_INPUT_DOWN, (Object)false);
        this.f_19804_.m_135372_(PLANE_BREAK, (Object)Float.valueOf(0.0f));
    }

    @Override
    protected void m_7378_(@NotNull CompoundTag compound) {
        super.m_7378_(compound);
        this.f_19804_.m_135381_(POWER, (Object)Float.valueOf(compound.m_128457_("Power")));
        this.f_19804_.m_135381_(DECOY_COUNT, (Object)compound.m_128451_("DecoyCount"));
        this.f_19804_.m_135381_(GEAR_ROT, (Object)compound.m_128451_("GearRot"));
        this.f_19804_.m_135381_(GEAR_UP, (Object)compound.m_128471_("GearUp"));
    }

    @Override
    public void m_7380_(@NotNull CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128350_("Power", ((Float)this.f_19804_.m_135370_(POWER)).floatValue());
        compound.m_128405_("DecoyCount", ((Integer)this.f_19804_.m_135370_(DECOY_COUNT)).intValue());
        compound.m_128405_("GearRot", ((Integer)this.f_19804_.m_135370_(GEAR_ROT)).intValue());
        compound.m_128379_("GearUp", ((Boolean)this.f_19804_.m_135370_(GEAR_UP)).booleanValue());
    }

    public boolean hasTracks() {
        return false;
    }

    public boolean canCrushEntities() {
        return true;
    }

    @Override
    public boolean hasEnergyStorage() {
        return true;
    }

    public void trackEngine(boolean amphibious, double buoyancy, int EnergyConsume, double wheelRotSpeed, double wheelDifferential, double trackSpeed, double trackDifferential, float maxPower, float minPower, float powerAdd, float powerReduce, float steeringSpeed) {
        int i;
        if (amphibious) {
            double fluidFloat = buoyancy * MobileVehicleEntity.getSubmergedHeight(this);
            this.m_20256_(this.m_20184_().m_82520_(0.0, fluidFloat, 0.0));
        }
        if (this.m_20096_()) {
            float f0 = 0.54f + 0.25f * Mth.m_14154_((float)(90.0f - (float)MobileVehicleEntity.calculateAngle(this.m_20184_(), this.m_20252_(1.0f)))) / 90.0f;
            this.m_20256_(this.m_20184_().m_82549_(this.m_20252_(1.0f).m_82541_().m_82490_(0.05 * this.m_20184_().m_82526_(this.m_20252_(1.0f)))));
            this.m_20256_(this.m_20184_().m_82542_((double)f0, 0.99, (double)f0));
        } else {
            this.m_20256_(this.m_20184_().m_82542_(0.99, 0.99, 0.99));
        }
        if (this.m_20069_()) {
            float f1 = (float)((double)0.7f - (double)0.04f * org.joml.Math.min((double)MobileVehicleEntity.getSubmergedHeight(this), (double)this.m_20206_()) + (double)(0.08f * Mth.m_14154_((float)(90.0f - (float)MobileVehicleEntity.calculateAngle(this.m_20184_(), this.m_20252_(1.0f)))) / 90.0f));
            this.m_20256_(this.m_20184_().m_82549_(this.m_20252_(1.0f).m_82541_().m_82490_(0.04 * this.m_20184_().m_82526_(this.m_20252_(1.0f)))));
            this.m_20256_(this.m_20184_().m_82542_((double)f1, 0.85, (double)f1));
            Level level = this.m_9236_();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                if (this.m_20184_().m_82556_() > 0.01) {
                    ParticleTool.sendParticle(serverLevel, ParticleTypes.f_123796_, this.m_20185_() + 0.5 * this.m_20184_().f_82479_, this.m_20186_() + MobileVehicleEntity.getSubmergedHeight(this) - 0.2, this.m_20189_() + 0.5 * this.m_20184_().f_82481_, (int)(2.0 + 4.0 * this.m_20184_().m_82553_()), 0.65, 0.0, 0.65, 0.0, true);
                    ParticleTool.sendParticle(serverLevel, ParticleTypes.f_123774_, this.m_20185_() + 0.5 * this.m_20184_().f_82479_, this.m_20186_() + MobileVehicleEntity.getSubmergedHeight(this) - 0.2, this.m_20189_() + 0.5 * this.m_20184_().f_82481_, (int)(2.0 + 10.0 * this.m_20184_().m_82553_()), 0.65, 0.0, 0.65, 0.0, true);
                }
            }
        }
        Entity passenger0 = this.m_146895_();
        if (this.getEnergy() <= 0) {
            return;
        }
        if (passenger0 == null) {
            this.leftInputDown = false;
            this.rightInputDown = false;
            this.forwardInputDown = false;
            this.backInputDown = false;
            this.f_19804_.m_135381_(POWER, (Object)Float.valueOf(0.0f));
        }
        if (this.forwardInputDown) {
            this.f_19804_.m_135381_(POWER, (Object)Float.valueOf(org.joml.Math.min((float)(((Float)this.f_19804_.m_135370_(POWER)).floatValue() + (((Float)this.f_19804_.m_135370_(POWER)).floatValue() < 0.0f ? powerAdd * 1.667f : powerAdd) * (1.0f + this.m_146909_() / 55.0f)), (float)maxPower)));
        }
        if (this.backInputDown) {
            this.f_19804_.m_135381_(POWER, (Object)Float.valueOf(org.joml.Math.max((float)(((Float)this.f_19804_.m_135370_(POWER)).floatValue() - (((Float)this.f_19804_.m_135370_(POWER)).floatValue() > 0.0f ? powerReduce * 1.667f : powerReduce) * (1.0f - this.m_146909_() / 55.0f)), (float)minPower)));
            if (this.rightInputDown) {
                this.f_19804_.m_135381_(DELTA_ROT, (Object)Float.valueOf(((Float)this.f_19804_.m_135370_(DELTA_ROT)).floatValue() + steeringSpeed));
            } else if (this.leftInputDown) {
                this.f_19804_.m_135381_(DELTA_ROT, (Object)Float.valueOf(((Float)this.f_19804_.m_135370_(DELTA_ROT)).floatValue() - steeringSpeed));
            }
        } else if (this.rightInputDown) {
            this.f_19804_.m_135381_(DELTA_ROT, (Object)Float.valueOf(((Float)this.f_19804_.m_135370_(DELTA_ROT)).floatValue() - steeringSpeed));
        } else if (this.leftInputDown) {
            this.f_19804_.m_135381_(DELTA_ROT, (Object)Float.valueOf(((Float)this.f_19804_.m_135370_(DELTA_ROT)).floatValue() + steeringSpeed));
        }
        if (this.forwardInputDown || this.backInputDown) {
            this.consumeEnergy(EnergyConsume);
        }
        this.f_19804_.m_135381_(POWER, (Object)Float.valueOf(((Float)this.f_19804_.m_135370_(POWER)).floatValue() * (this.upInputDown ? 0.5f : (this.rightInputDown || this.leftInputDown ? 0.947f : 0.96f))));
        this.f_19804_.m_135381_(DELTA_ROT, (Object)Float.valueOf(((Float)this.f_19804_.m_135370_(DELTA_ROT)).floatValue() * (float)org.joml.Math.max((double)((double)0.76f - (double)0.1f * this.m_20184_().m_165924_()), (double)0.3)));
        double s0 = this.m_20184_().m_82526_(this.m_20252_(1.0f));
        this.setLeftWheelRot((float)((double)this.getLeftWheelRot() - wheelRotSpeed * s0 + Mth.m_14008_((double)(wheelDifferential * (double)((Float)this.f_19804_.m_135370_(DELTA_ROT)).floatValue()), (double)-5.0, (double)5.0)));
        this.setRightWheelRot((float)((double)this.getRightWheelRot() - wheelRotSpeed * s0 - Mth.m_14008_((double)(wheelDifferential * (double)((Float)this.f_19804_.m_135370_(DELTA_ROT)).floatValue()), (double)-5.0, (double)5.0)));
        this.setLeftTrack((float)((double)this.getLeftTrack() - trackSpeed * Math.PI * s0 + Mth.m_14008_((double)(trackDifferential * Math.PI * (double)((Float)this.f_19804_.m_135370_(DELTA_ROT)).floatValue()), (double)-5.0, (double)5.0)));
        this.setRightTrack((float)((double)this.getRightTrack() - trackSpeed * Math.PI * s0 - Mth.m_14008_((double)(trackDifferential * Math.PI * (double)((Float)this.f_19804_.m_135370_(DELTA_ROT)).floatValue()), (double)-5.0, (double)5.0)));
        if (((Boolean)this.f_19804_.m_135370_(L_WHEEL_DAMAGED)).booleanValue() && ((Boolean)this.f_19804_.m_135370_(R_WHEEL_DAMAGED)).booleanValue()) {
            this.f_19804_.m_135381_(POWER, (Object)Float.valueOf(((Float)this.f_19804_.m_135370_(POWER)).floatValue() * 0.93f));
            i = 0;
        } else if (((Boolean)this.f_19804_.m_135370_(L_WHEEL_DAMAGED)).booleanValue()) {
            this.f_19804_.m_135381_(POWER, (Object)Float.valueOf(((Float)this.f_19804_.m_135370_(POWER)).floatValue() * 0.975f));
            i = 3;
        } else if (((Boolean)this.f_19804_.m_135370_(R_WHEEL_DAMAGED)).booleanValue()) {
            this.f_19804_.m_135381_(POWER, (Object)Float.valueOf(((Float)this.f_19804_.m_135370_(POWER)).floatValue() * 0.975f));
            i = -3;
        } else {
            i = 0;
        }
        if (((Boolean)this.f_19804_.m_135370_(ENGINE1_DAMAGED)).booleanValue()) {
            this.f_19804_.m_135381_(POWER, (Object)Float.valueOf(((Float)this.f_19804_.m_135370_(POWER)).floatValue() * 0.85f));
        }
        this.m_146922_((float)((double)this.m_146908_() - (this.m_20069_() && !this.m_20096_() ? 2.5 : 6.0) * (double)((Float)this.f_19804_.m_135370_(DELTA_ROT)).floatValue() - (double)i * s0));
        if (this.m_20069_() || this.m_20096_()) {
            this.m_20256_(this.m_20184_().m_82549_(this.m_20252_(1.0f).m_82490_((double)((!this.m_20069_() && !this.m_20096_() ? 0.13f : (this.m_20069_() && !this.m_20096_() ? 2.0f : 2.4f)) * ((Float)this.f_19804_.m_135370_(POWER)).floatValue()))));
        }
    }

    public void wheelEngine(boolean amphibious, double buoyancy, int EnergyConsume, double wheelRotSpeed, double wheelDifferential, float maxPower, float minPower, float powerAdd, float powerReduce, float steeringSpeed) {
        int i;
        if (amphibious) {
            double fluidFloat = buoyancy * MobileVehicleEntity.getSubmergedHeight(this);
            this.m_20256_(this.m_20184_().m_82520_(0.0, fluidFloat, 0.0));
        }
        if (this.m_20096_()) {
            float f0 = 0.54f + 0.25f * Mth.m_14154_((float)(90.0f - (float)MobileVehicleEntity.calculateAngle(this.m_20184_(), this.m_20252_(1.0f)))) / 90.0f;
            this.m_20256_(this.m_20184_().m_82549_(this.m_20252_(1.0f).m_82541_().m_82490_(0.05 * this.m_20184_().m_82526_(this.m_20252_(1.0f)))));
            this.m_20256_(this.m_20184_().m_82542_((double)f0, 0.99, (double)f0));
        } else if (this.m_20069_()) {
            float f1 = 0.74f + 0.09f * Mth.m_14154_((float)(90.0f - (float)MobileVehicleEntity.calculateAngle(this.m_20184_(), this.m_20252_(1.0f)))) / 90.0f;
            this.m_20256_(this.m_20184_().m_82549_(this.m_20252_(1.0f).m_82541_().m_82490_(0.04 * this.m_20184_().m_82526_(this.m_20252_(1.0f)))));
            this.m_20256_(this.m_20184_().m_82542_((double)f1, 0.85, (double)f1));
        } else {
            this.m_20256_(this.m_20184_().m_82542_(0.99, 0.99, 0.99));
        }
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (this.m_20069_() && this.m_20184_().m_82553_() > 0.1) {
                ParticleTool.sendParticle(serverLevel, ParticleTypes.f_123796_, this.m_20185_() + 0.5 * this.m_20184_().f_82479_, this.m_20186_() + MobileVehicleEntity.getSubmergedHeight(this) - 0.2, this.m_20189_() + 0.5 * this.m_20184_().f_82481_, (int)(2.0 + 4.0 * this.m_20184_().m_82553_()), 0.65, 0.0, 0.65, 0.0, true);
                ParticleTool.sendParticle(serverLevel, ParticleTypes.f_123774_, this.m_20185_() + 0.5 * this.m_20184_().f_82479_, this.m_20186_() + MobileVehicleEntity.getSubmergedHeight(this) - 0.2, this.m_20189_() + 0.5 * this.m_20184_().f_82481_, (int)(2.0 + 10.0 * this.m_20184_().m_82553_()), 0.65, 0.0, 0.65, 0.0, true);
            }
        }
        Entity passenger0 = this.m_146895_();
        if (this.getEnergy() <= 0) {
            return;
        }
        if (passenger0 == null) {
            this.leftInputDown = false;
            this.rightInputDown = false;
            this.forwardInputDown = false;
            this.backInputDown = false;
            this.f_19804_.m_135381_(POWER, (Object)Float.valueOf(0.0f));
        }
        if (this.forwardInputDown) {
            this.f_19804_.m_135381_(POWER, (Object)Float.valueOf(org.joml.Math.min((float)(((Float)this.f_19804_.m_135370_(POWER)).floatValue() + (((Float)this.f_19804_.m_135370_(POWER)).floatValue() < 0.0f ? powerAdd * 2.0f : powerAdd) * (1.0f + this.m_146909_() / 55.0f)), (float)maxPower)));
        }
        if (this.backInputDown) {
            this.f_19804_.m_135381_(POWER, (Object)Float.valueOf(org.joml.Math.max((float)(((Float)this.f_19804_.m_135370_(POWER)).floatValue() - (((Float)this.f_19804_.m_135370_(POWER)).floatValue() > 0.0f ? powerReduce * 2.0f : powerReduce) * (1.0f - this.m_146909_() / 55.0f)), (float)minPower)));
        }
        if (this.rightInputDown) {
            this.f_19804_.m_135381_(DELTA_ROT, (Object)Float.valueOf(((Float)this.f_19804_.m_135370_(DELTA_ROT)).floatValue() + steeringSpeed));
        } else if (this.leftInputDown) {
            this.f_19804_.m_135381_(DELTA_ROT, (Object)Float.valueOf(((Float)this.f_19804_.m_135370_(DELTA_ROT)).floatValue() - steeringSpeed));
        }
        if (this.forwardInputDown || this.backInputDown) {
            this.consumeEnergy(EnergyConsume);
        }
        this.f_19804_.m_135381_(POWER, (Object)Float.valueOf(((Float)this.f_19804_.m_135370_(POWER)).floatValue() * (this.upInputDown ? 0.5f : (this.rightInputDown || this.leftInputDown ? 0.977f : 0.99f))));
        this.f_19804_.m_135381_(DELTA_ROT, (Object)Float.valueOf(((Float)this.f_19804_.m_135370_(DELTA_ROT)).floatValue() * (float)org.joml.Math.max((double)((double)0.76f - (double)0.1f * this.m_20184_().m_165924_()), (double)0.3)));
        double s0 = this.m_20184_().m_82526_(this.m_20252_(1.0f));
        this.setLeftWheelRot((float)((double)this.getLeftWheelRot() - wheelRotSpeed * s0 + Mth.m_14008_((double)(wheelDifferential * (double)((Float)this.f_19804_.m_135370_(DELTA_ROT)).floatValue()), (double)-5.0, (double)5.0)));
        this.setRightWheelRot((float)((double)this.getRightWheelRot() - wheelRotSpeed * s0 - Mth.m_14008_((double)(wheelDifferential * (double)((Float)this.f_19804_.m_135370_(DELTA_ROT)).floatValue()), (double)-5.0, (double)5.0)));
        this.setRudderRot(Mth.m_14036_((float)(this.getRudderRot() - ((Float)this.f_19804_.m_135370_(DELTA_ROT)).floatValue()), (float)-0.8f, (float)0.8f) * 0.75f);
        if (((Boolean)this.f_19804_.m_135370_(L_WHEEL_DAMAGED)).booleanValue() && ((Boolean)this.f_19804_.m_135370_(R_WHEEL_DAMAGED)).booleanValue()) {
            this.f_19804_.m_135381_(POWER, (Object)Float.valueOf(((Float)this.f_19804_.m_135370_(POWER)).floatValue() * 0.93f));
            i = 0;
        } else if (((Boolean)this.f_19804_.m_135370_(L_WHEEL_DAMAGED)).booleanValue()) {
            this.f_19804_.m_135381_(POWER, (Object)Float.valueOf(((Float)this.f_19804_.m_135370_(POWER)).floatValue() * 0.975f));
            i = 3;
        } else if (((Boolean)this.f_19804_.m_135370_(R_WHEEL_DAMAGED)).booleanValue()) {
            this.f_19804_.m_135381_(POWER, (Object)Float.valueOf(((Float)this.f_19804_.m_135370_(POWER)).floatValue() * 0.975f));
            i = -3;
        } else {
            i = 0;
        }
        if (((Boolean)this.f_19804_.m_135370_(ENGINE1_DAMAGED)).booleanValue()) {
            this.f_19804_.m_135381_(POWER, (Object)Float.valueOf(((Float)this.f_19804_.m_135370_(POWER)).floatValue() * 0.875f));
        }
        this.m_146922_((float)((double)this.m_146908_() - org.joml.Math.max((double)((double)(this.m_20069_() && !this.m_20096_() ? 5 : 10) * this.m_20184_().m_165924_()), (double)0.0) * (double)this.getRudderRot() * (double)(((Float)this.f_19804_.m_135370_(POWER)).floatValue() > 0.0f ? 1 : -1) - (double)i * s0));
        if (this.m_20069_() || this.m_20096_()) {
            this.m_20256_(this.m_20184_().m_82549_(this.m_20252_(1.0f).m_82490_((double)((!this.m_20069_() && !this.m_20096_() ? 0.05f : (this.m_20069_() && !this.m_20096_() ? 0.3f : 1.0f)) * ((Float)this.f_19804_.m_135370_(POWER)).floatValue()))));
        }
    }

    public Vec3 findNearestLandingPos(int radius) {
        Level world = this.m_9236_();
        BlockPos entityPos = this.m_20183_();
        ArrayList<BlockPos> landingBlocks = new ArrayList<BlockPos>();
        for (int x = -radius; x <= radius; ++x) {
            for (int z = -radius; z <= radius; ++z) {
                for (int y = -radius; y <= 0; ++y) {
                    BlockPos checkPos;
                    if (x * x + y * y + z * z > radius * radius || !world.m_8055_(checkPos = entityPos.m_7918_(x, y, z)).m_204336_(ModTags.Blocks.AUTO_LANDING)) continue;
                    landingBlocks.add(checkPos);
                }
            }
        }
        if (landingBlocks.isEmpty()) {
            return null;
        }
        landingBlocks.sort(Comparator.comparingDouble(pos -> this.m_20182_().m_82531_((double)pos.m_123341_() + 0.5, (double)(pos.m_123342_() + 1), (double)pos.m_123343_() + 0.5)));
        return ((BlockPos)landingBlocks.get(0)).m_252807_();
    }

    public void updateAutoLanding(Vec3 landingTarget) {
        Vec3 currentPos = this.m_20182_();
        Vec3 horizontalOffset = new Vec3(landingTarget.f_82479_ - currentPos.f_82479_, 0.0, landingTarget.f_82481_ - currentPos.f_82481_);
        this.m_20256_(this.m_20184_().m_82542_(0.98, 0.99, 0.98));
        double horizontalDistance = horizontalOffset.m_82553_();
        Vec3 horizontalDirection = horizontalDistance > 0.0 ? horizontalOffset.m_82541_() : Vec3.f_82478_;
        float positionTolerance = 0.1f;
        float tiltSmoothingFactor = 0.1f;
        if (horizontalDistance < (double)positionTolerance) {
            this.m_146926_(this.lerpAngle(this.m_146909_(), 0.0f, tiltSmoothingFactor));
            this.setZRot(this.lerpAngle(this.getRoll(), 0.0f, tiltSmoothingFactor));
            return;
        }
        float maxTiltAngle = 15.0f;
        float targetTilt = (float)org.joml.Math.min((double)maxTiltAngle, (double)(horizontalDistance * 2.0));
        float yawRad = org.joml.Math.toRadians((float)(-this.m_146908_()));
        Vec3 localDirection = new Vec3(horizontalDirection.f_82479_ * (double)org.joml.Math.cos((float)yawRad) - horizontalDirection.f_82481_ * (double)org.joml.Math.sin((float)yawRad), 0.0, horizontalDirection.f_82479_ * (double)org.joml.Math.sin((float)yawRad) + horizontalDirection.f_82481_ * (double)org.joml.Math.cos((float)yawRad));
        float targetXRot = (float)(-localDirection.f_82481_ * (double)targetTilt);
        float targetZRot = (float)(localDirection.f_82479_ * (double)targetTilt);
        this.m_146926_(this.lerpAngle(this.m_146909_(), -targetXRot, tiltSmoothingFactor));
        this.setZRot(this.lerpAngle(this.getRoll(), -targetZRot, tiltSmoothingFactor));
    }

    private float lerpAngle(float current, float target, float factor) {
        float diff;
        for (diff = target - current; diff < -180.0f; diff += 360.0f) {
        }
        while (diff > 180.0f) {
            diff -= 360.0f;
        }
        return current + diff * factor;
    }

    public int getHudColor() {
        return 0x66FF00;
    }
}

