/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.entity.vehicle;

import com.atsuishio.superbwarfare.Mod;
import com.atsuishio.superbwarfare.client.RenderHelper;
import com.atsuishio.superbwarfare.config.server.VehicleConfig;
import com.atsuishio.superbwarfare.entity.OBBEntity;
import com.atsuishio.superbwarfare.entity.projectile.CannonShellEntity;
import com.atsuishio.superbwarfare.entity.projectile.ProjectileEntity;
import com.atsuishio.superbwarfare.entity.projectile.SwarmDroneEntity;
import com.atsuishio.superbwarfare.entity.vehicle.base.ContainerMobileVehicleEntity;
import com.atsuishio.superbwarfare.entity.vehicle.base.LandArmorEntity;
import com.atsuishio.superbwarfare.entity.vehicle.base.ThirdPersonCameraPosition;
import com.atsuishio.superbwarfare.entity.vehicle.base.WeaponVehicleEntity;
import com.atsuishio.superbwarfare.entity.vehicle.damage.DamageModifier;
import com.atsuishio.superbwarfare.entity.vehicle.weapon.CannonShellWeapon;
import com.atsuishio.superbwarfare.entity.vehicle.weapon.ProjectileWeapon;
import com.atsuishio.superbwarfare.entity.vehicle.weapon.SwarmDroneWeapon;
import com.atsuishio.superbwarfare.entity.vehicle.weapon.VehicleWeapon;
import com.atsuishio.superbwarfare.event.ClientMouseHandler;
import com.atsuishio.superbwarfare.init.ModEntities;
import com.atsuishio.superbwarfare.init.ModItems;
import com.atsuishio.superbwarfare.init.ModSounds;
import com.atsuishio.superbwarfare.network.message.receive.ShakeClientMessage;
import com.atsuishio.superbwarfare.tools.Ammo;
import com.atsuishio.superbwarfare.tools.InventoryTool;
import com.atsuishio.superbwarfare.tools.MathTool;
import com.atsuishio.superbwarfare.tools.OBB;
import com.atsuishio.superbwarfare.tools.SeekTool;
import com.atsuishio.superbwarfare.tools.SoundTool;
import com.atsuishio.superbwarfare.tools.VectorTool;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.io.Serializable;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundStopSoundPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.PlayMessages;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Math;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class Yx100Entity
extends ContainerMobileVehicleEntity
implements GeoEntity,
LandArmorEntity,
WeaponVehicleEntity,
OBBEntity {
    public static final EntityDataAccessor<Integer> MG_AMMO = SynchedEntityData.m_135353_(Yx100Entity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<String> LOADED_SHELL = SynchedEntityData.m_135353_(Yx100Entity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    public static final EntityDataAccessor<Integer> SELECTED_AMMO_TYPE = SynchedEntityData.m_135353_(Yx100Entity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> GUN_FIRE_TIME = SynchedEntityData.m_135353_(Yx100Entity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> LOADED_DRONE = SynchedEntityData.m_135353_(Yx100Entity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    public int droneReloadCoolDown;
    public OBB obb = new OBB(this.m_20182_().m_252839_(), new Vector3f(2.375f, 0.71875f, 4.0f), new Quaternionf(), OBB.Part.BODY);
    public OBB obb2 = new OBB(this.m_20182_().m_252839_(), new Vector3f(2.375f, 0.59375f, 0.65625f), new Quaternionf(), OBB.Part.BODY);
    public OBB obb3 = new OBB(this.m_20182_().m_252839_(), new Vector3f(0.625f, 0.84375f, 3.875f), new Quaternionf(), OBB.Part.WHEEL_LEFT);
    public OBB obb4 = new OBB(this.m_20182_().m_252839_(), new Vector3f(0.625f, 0.84375f, 3.875f), new Quaternionf(), OBB.Part.WHEEL_RIGHT);
    public OBB obb5 = new OBB(this.m_20182_().m_252839_(), new Vector3f(2.0625f, 0.59375f, 0.625f), new Quaternionf(), OBB.Part.ENGINE1);
    public OBB obbTurret = new OBB(this.m_20182_().m_252839_(), new Vector3f(2.375f, 0.5625f, 2.1875f), new Quaternionf(), OBB.Part.TURRET);
    public OBB obbTurret2 = new OBB(this.m_20182_().m_252839_(), new Vector3f(1.625f, 0.40625f, 0.59375f), new Quaternionf(), OBB.Part.TURRET);

    public Yx100Entity(PlayMessages.SpawnEntity packet, Level world) {
        this((EntityType<Yx100Entity>)((EntityType)ModEntities.YX_100.get()), world);
    }

    public Yx100Entity(EntityType<Yx100Entity> type, Level world) {
        super(type, world);
    }

    @Override
    public VehicleWeapon[][] initWeapons() {
        return new VehicleWeapon[][]{{new CannonShellWeapon().hitDamage(((Integer)VehicleConfig.YX_100_AP_CANNON_DAMAGE.get()).intValue()).explosionRadius(((Double)VehicleConfig.YX_100_AP_CANNON_EXPLOSION_RADIUS.get()).floatValue()).explosionDamage(((Integer)VehicleConfig.YX_100_AP_CANNON_EXPLOSION_DAMAGE.get()).intValue()).fireProbability(0.0f).fireTime(0).durability(100).velocity(40.0f).gravity(0.1f).sound((SoundEvent)ModSounds.INTO_MISSILE.get()).ammo((Item)ModItems.AP_5_INCHES.get()).icon(Mod.loc("textures/screens/vehicle_weapon/ap_shell.png")).sound1p((SoundEvent)ModSounds.YX_100_FIRE_1P.get()).sound3p((SoundEvent)ModSounds.YX_100_FIRE_3P.get()).sound3pFar((SoundEvent)ModSounds.YX_100_FAR.get()).sound3pVeryFar((SoundEvent)ModSounds.YX_100_VERYFAR.get()).mainGun(true), new CannonShellWeapon().hitDamage(((Integer)VehicleConfig.YX_100_HE_CANNON_DAMAGE.get()).intValue()).explosionRadius(((Double)VehicleConfig.YX_100_HE_CANNON_EXPLOSION_RADIUS.get()).floatValue()).explosionDamage(((Integer)VehicleConfig.YX_100_HE_CANNON_EXPLOSION_DAMAGE.get()).intValue()).fireProbability(0.18f).fireTime(2).durability(1).velocity(25.0f).gravity(0.1f).sound((SoundEvent)ModSounds.INTO_CANNON.get()).ammo((Item)ModItems.HE_5_INCHES.get()).icon(Mod.loc("textures/screens/vehicle_weapon/he_shell.png")).sound1p((SoundEvent)ModSounds.YX_100_FIRE_1P.get()).sound3p((SoundEvent)ModSounds.YX_100_FIRE_3P.get()).sound3pFar((SoundEvent)ModSounds.YX_100_FAR.get()).sound3pVeryFar((SoundEvent)ModSounds.YX_100_VERYFAR.get()).mainGun(true), new CannonShellWeapon().hitDamage(((Integer)VehicleConfig.YX_100_HE_CANNON_DAMAGE.get()).intValue()).explosionRadius(((Double)VehicleConfig.YX_100_HE_CANNON_EXPLOSION_RADIUS.get()).floatValue()).explosionDamage(((Integer)VehicleConfig.YX_100_HE_CANNON_EXPLOSION_DAMAGE.get()).intValue()).fireProbability(0.18f).fireTime(2).durability(1).velocity(25.0f).gravity(0.1f).type(CannonShellEntity.Type.CM).spreadAmount(15).spreadTime(4).spreadAngle(5).sound((SoundEvent)ModSounds.INTO_CANNON.get()).ammo((Item)ModItems.CM_5_INCHES.get()).icon(Mod.loc("textures/screens/vehicle_weapon/cm_shell.png")).sound1p((SoundEvent)ModSounds.YX_100_FIRE_1P.get()).sound3p((SoundEvent)ModSounds.YX_100_FIRE_3P.get()).sound3pFar((SoundEvent)ModSounds.YX_100_FAR.get()).sound3pVeryFar((SoundEvent)ModSounds.YX_100_VERYFAR.get()).mainGun(true), new CannonShellWeapon().hitDamage(1000.0f).explosionRadius(((Double)VehicleConfig.YX_100_AP_CANNON_EXPLOSION_RADIUS.get()).floatValue()).explosionDamage(((Integer)VehicleConfig.YX_100_AP_CANNON_EXPLOSION_DAMAGE.get()).intValue()).velocity(30.0f).type(CannonShellEntity.Type.GRAPE).spreadAmount(40).spreadAngle(3).sound((SoundEvent)ModSounds.INTO_CANNON.get()).ammo((Item)ModItems.GS_5_INCHES.get()).icon(Mod.loc("textures/screens/vehicle_weapon/grape_shell.png")).sound1p((SoundEvent)ModSounds.YX_100_FIRE_1P.get()).sound3p((SoundEvent)ModSounds.YX_100_FIRE_3P.get()).sound3pFar((SoundEvent)ModSounds.YX_100_FAR.get()).sound3pVeryFar((SoundEvent)ModSounds.YX_100_VERYFAR.get()).mainGun(true), new ProjectileWeapon().damage(((Integer)VehicleConfig.HEAVY_MACHINE_GUN_DAMAGE.get()).intValue()).headShot(2.0f).zoom(false).bypassArmorRate(0.4f).ammo((Item)ModItems.HEAVY_AMMO.get()).sound((SoundEvent)ModSounds.INTO_CANNON.get()).icon(Mod.loc("textures/screens/vehicle_weapon/gun_12_7mm.png")).sound1p((SoundEvent)ModSounds.M_2_HB_FIRE_1P.get()).sound3p((SoundEvent)ModSounds.M_2_HB_FIRE_3P.get()).sound3pFar((SoundEvent)ModSounds.M_2_HB_FAR.get()).sound3pVeryFar((SoundEvent)ModSounds.M_2_HB_VERYFAR.get())}, {new ProjectileWeapon().damage(((Integer)VehicleConfig.HEAVY_MACHINE_GUN_DAMAGE.get()).intValue()).headShot(2.0f).zoom(false).bypassArmorRate(0.4f).ammo((Item)ModItems.HEAVY_AMMO.get()).icon(Mod.loc("textures/screens/vehicle_weapon/gun_12_7mm.png")).sound1p((SoundEvent)ModSounds.M_2_HB_FIRE_1P.get()).sound3p((SoundEvent)ModSounds.M_2_HB_FIRE_3P.get()).sound3pFar((SoundEvent)ModSounds.M_2_HB_FAR.get()).sound3pVeryFar((SoundEvent)ModSounds.M_2_HB_VERYFAR.get())}, {new SwarmDroneWeapon().explosionDamage(((Integer)VehicleConfig.YX_100_SWARM_EXPLOSION_DAMAGE.get()).intValue()).explosionRadius(((Double)VehicleConfig.YX_100_SWARM_EXPLOSION_RADIUS.get()).floatValue()).sound((SoundEvent)ModSounds.INTO_MISSILE.get())}};
    }

    @Override
    public ThirdPersonCameraPosition getThirdPersonCameraPosition(int index) {
        return switch (index) {
            case 0 -> new ThirdPersonCameraPosition(5.0 + ClientMouseHandler.custom3pDistanceLerp, 1.5, -0.8669625);
            case 1 -> new ThirdPersonCameraPosition(-1.0 + 0.5 * ClientMouseHandler.custom3pDistanceLerp, 0.5, 0.0);
            default -> null;
        };
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(MG_AMMO, (Object)0);
        this.f_19804_.m_135372_(LOADED_SHELL, (Object)"null");
        this.f_19804_.m_135372_(LOADED_DRONE, (Object)0);
        this.f_19804_.m_135372_(SELECTED_AMMO_TYPE, (Object)0);
        this.f_19804_.m_135372_(GUN_FIRE_TIME, (Object)0);
    }

    @Override
    public void m_7380_(@NotNull CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128359_("LoadedShell", (String)this.f_19804_.m_135370_(LOADED_SHELL));
        compound.m_128405_("LoadedDrone", ((Integer)this.f_19804_.m_135370_(LOADED_DRONE)).intValue());
        compound.m_128405_("SelectedAmmoType", ((Integer)this.f_19804_.m_135370_(SELECTED_AMMO_TYPE)).intValue());
        compound.m_128405_("WeaponType", this.getWeaponIndex(0));
        compound.m_128405_("PassengerWeaponType", this.getWeaponIndex(1));
        compound.m_128405_("ThirdPassengerWeaponType", this.getWeaponIndex(2));
    }

    @Override
    public void m_7378_(@NotNull CompoundTag compound) {
        super.m_7378_(compound);
        this.f_19804_.m_135381_(LOADED_SHELL, (Object)compound.m_128461_("LoadedShell"));
        this.f_19804_.m_135381_(LOADED_DRONE, (Object)compound.m_128451_("LoadedDrone"));
        this.f_19804_.m_135381_(SELECTED_AMMO_TYPE, (Object)compound.m_128451_("SelectedAmmoType"));
        this.setWeaponIndex(0, compound.m_128451_("WeaponType"));
        this.setWeaponIndex(1, compound.m_128451_("PassengerWeaponType"));
        this.setWeaponIndex(2, compound.m_128451_("ThirdPassengerWeaponType"));
    }

    @Override
    public DamageModifier getDamageModifier() {
        return super.getDamageModifier().custom((source, damage) -> Float.valueOf(this.getSourceAngle((DamageSource)source, 0.3f) * damage.floatValue()));
    }

    protected void m_7355_(@NotNull BlockPos pPos, @NotNull BlockState pState) {
        this.m_5496_((SoundEvent)ModSounds.WHEEL_STEP.get(), (float)(this.m_20184_().m_82553_() * 0.15), this.f_19796_.m_188501_() * 0.15f + 1.05f);
    }

    @Override
    public void m_6075_() {
        int rpm;
        Mob mob;
        Entity i2;
        Entity entity;
        super.m_6075_();
        this.updateOBB();
        if (this.getLeftTrack() < 0.0f) {
            this.setLeftTrack(80.0f);
        }
        if (this.getLeftTrack() > 80.0f) {
            this.setLeftTrack(0.0f);
        }
        if (this.getRightTrack() < 0.0f) {
            this.setRightTrack(80.0f);
        }
        if (this.getRightTrack() > 80.0f) {
            this.setRightTrack(0.0f);
        }
        if ((Integer)this.f_19804_.m_135370_(GUN_FIRE_TIME) > 0) {
            this.f_19804_.m_135381_(GUN_FIRE_TIME, (Object)((Integer)this.f_19804_.m_135370_(GUN_FIRE_TIME) - 1));
        }
        if (this.reloadCoolDown == 70 && (entity = this.m_146895_()) instanceof Player) {
            Player player = (Player)entity;
            SoundTool.playLocalSound(player, (SoundEvent)ModSounds.YX_100_RELOAD.get());
        }
        if (this.m_9236_() instanceof ServerLevel) {
            boolean hasCreativeAmmo = false;
            for (int i2 = 0; i2 < this.getMaxPassengers(); ++i2) {
                if (!InventoryTool.hasCreativeAmmoBox(this.getNthEntity(i2))) continue;
                hasCreativeAmmo = true;
            }
            if (this.reloadCoolDown > 0 && this.getWeapon((int)0).mainGun && (hasCreativeAmmo || this.m_18947_(this.getWeapon((int)0).ammo) > 0)) {
                --this.reloadCoolDown;
            }
            if (this.droneReloadCoolDown > 0) {
                --this.droneReloadCoolDown;
            }
            if ((this.hasItem((Item)ModItems.SWARM_DRONE.get()) || hasCreativeAmmo) && this.droneReloadCoolDown == 0 && (Integer)this.m_20088_().m_135370_(LOADED_DRONE) < 14) {
                this.f_19804_.m_135381_(LOADED_DRONE, (Object)((Integer)this.m_20088_().m_135370_(LOADED_DRONE) + 1));
                this.droneReloadCoolDown = 20;
                if (!hasCreativeAmmo) {
                    this.m_213659_().stream().filter(stack -> stack.m_150930_((Item)ModItems.SWARM_DRONE.get())).findFirst().ifPresent(stack -> stack.m_41774_(1));
                }
                this.m_9236_().m_6269_(null, (Entity)this, (SoundEvent)ModSounds.MISSILE_RELOAD.get(), this.m_5720_(), 1.0f, 1.0f);
            }
            this.handleAmmo();
        }
        if ((i2 = this.getNthEntity(2)) instanceof Mob && this.canShoot((LivingEntity)(mob = (Mob)i2)) && mob.m_5448_() != null && this.f_19797_ % (rpm = 20 / (this.mainGunRpm((LivingEntity)mob) / 60)) == 0) {
            this.vehicleShoot((LivingEntity)mob, 2);
        }
        this.lowHealthWarning();
        this.terrainCompact(4.375f, 6.3125f);
        this.inertiaRotate(1.2f);
        this.releaseSmokeDecoy(this.getTurretVector(1.0f));
        this.m_6210_();
    }

    @Override
    public float turretYSpeed() {
        return 5.0f;
    }

    @Override
    public float turretXSpeed() {
        return 5.0f;
    }

    @Override
    public float turretMinPitch() {
        return -10.0f;
    }

    @Override
    public float turretMaxPitch() {
        return 30.0f;
    }

    @Override
    public Vec3 getTurretShootPos(Entity entity, float ticks) {
        Vector4f worldPosition;
        if (entity == this.getNthEntity(0)) {
            Matrix4f transform = this.getBarrelTransform(ticks);
            worldPosition = this.getWeapon((int)0).mainGun ? this.transformPosition(transform, 0.0f, 0.0f, 0.0f) : this.transformPosition(transform, -0.12f, 0.15f, 0.0f);
        } else {
            Matrix4f transform = this.getGunTransform(1.0f);
            worldPosition = this.transformPosition(transform, 0.0f, -0.25f, 0.0f);
        }
        return new Vec3((double)worldPosition.x, (double)worldPosition.y, (double)worldPosition.z);
    }

    @Override
    public float projectileVelocity(Entity entity) {
        if (entity == this.getNthEntity(0)) {
            if (this.getWeapon((int)0).mainGun) {
                CannonShellWeapon cannonShell = (CannonShellWeapon)this.getWeapon(0);
                return cannonShell.velocity;
            }
            return 20.0f;
        }
        return 20.0f;
    }

    @Override
    public float projectileGravity(Entity entity) {
        if (this.getWeapon((int)0).mainGun && entity == this.getNthEntity(0)) {
            CannonShellWeapon cannonShell = (CannonShellWeapon)this.getWeapon(0);
            return cannonShell.gravity;
        }
        return 0.05f;
    }

    @Override
    public float passengerWeaponYSpeed() {
        return 15.0f;
    }

    @Override
    public float passengerWeaponXSpeed() {
        return 15.0f;
    }

    @Override
    public float passengerWeaponMinPitch() {
        return -10.0f;
    }

    @Override
    public float passengerWeaponMaxPitch() {
        return 60.0f;
    }

    @Override
    public Vec3 passengerWeaponShootPos(Entity entity, float ticks) {
        Matrix4f transform = this.getGunTransform(1.0f);
        Vector4f worldPosition = this.transformPosition(transform, 0.0f, -0.25f, 0.0f);
        return new Vec3((double)worldPosition.x, (double)worldPosition.y, (double)worldPosition.z);
    }

    @Override
    public boolean canCollideHardBlock() {
        return this.m_20184_().m_165924_() > 0.05 || (double)Mth.m_14154_((float)((Float)this.f_19804_.m_135370_(POWER)).floatValue()) > 0.1;
    }

    @Override
    public boolean canCollideBlockBeastly() {
        return this.m_20184_().m_165924_() > 0.3;
    }

    private void handleAmmo() {
        if (this.getWeapon((int)0).mainGun) {
            this.f_19804_.m_135381_(SELECTED_AMMO_TYPE, (Object)this.getWeaponIndex(0));
        }
        boolean hasCreativeAmmo = false;
        for (int i = 0; i < this.getMaxPassengers(); ++i) {
            if (!InventoryTool.hasCreativeAmmoBox(this.getNthEntity(i))) continue;
            hasCreativeAmmo = true;
        }
        if (hasCreativeAmmo) {
            this.f_19804_.m_135381_(AMMO, (Object)9999);
            this.f_19804_.m_135381_(MG_AMMO, (Object)9999);
        } else {
            this.f_19804_.m_135381_(AMMO, (Object)this.m_18947_(this.getWeapon((int)0).ammo));
            this.f_19804_.m_135381_(MG_AMMO, (Object)this.m_18947_(this.getWeapon((int)1).ammo));
        }
        if (((String)this.m_20088_().m_135370_(LOADED_SHELL)).equals("null") && this.reloadCoolDown <= 0 && (hasCreativeAmmo || this.hasItem(this.getWeapon((int)0).ammo))) {
            this.f_19804_.m_135381_(LOADED_SHELL, (Object)String.valueOf(ForgeRegistries.ITEMS.getKey((Object)this.getWeapon((int)0).ammo)));
            if (!hasCreativeAmmo) {
                this.consumeItem(this.getWeapon((int)0).ammo, 1);
            }
        }
    }

    @Override
    public void m_6478_(@NotNull MoverType movementType, @NotNull Vec3 movement) {
        super.m_6478_(movementType, movement);
        if (this.m_20069_() && this.f_19862_) {
            this.m_20256_(this.m_20184_().m_82520_(0.0, 0.07, 0.0));
        }
    }

    @Override
    public void vehicleShoot(LivingEntity living, int type) {
        boolean hasCreativeAmmo = false;
        for (int i = 0; i < this.getMaxPassengers() - 1; ++i) {
            if (!InventoryTool.hasCreativeAmmoBox(this.getNthEntity(i))) continue;
            hasCreativeAmmo = true;
        }
        if (type == 0) {
            if (this.reloadCoolDown == 0 && this.getWeapon((int)0).mainGun) {
                if (!this.canConsume((Integer)VehicleConfig.YX_100_SHOOT_COST.get()) && living instanceof Player) {
                    Player player = (Player)living;
                    player.m_5661_((Component)Component.m_237115_((String)"tips.superbwarfare.annihilator.energy_not_enough").m_130940_(ChatFormatting.RED), true);
                    return;
                }
                CannonShellWeapon cannonShell = (CannonShellWeapon)this.getWeapon(0);
                CannonShellEntity entityToSpawn = cannonShell.create(living);
                entityToSpawn.m_6034_(this.getTurretShootPos((Entity)living, (float)1.0f).f_82479_, this.getTurretShootPos((Entity)living, (float)1.0f).f_82480_, this.getTurretShootPos((Entity)living, (float)1.0f).f_82481_);
                entityToSpawn.m_6686_(this.getBarrelVector((float)1.0f).f_82479_, this.getBarrelVector((float)1.0f).f_82480_, this.getBarrelVector((float)1.0f).f_82481_, cannonShell.velocity, 0.02f);
                this.m_9236_().m_7967_((Entity)entityToSpawn);
                this.playShootSound3p(living, 0, 8, 16, 32, new Vec3(this.getTurretShootPos((Entity)living, (float)1.0f).f_82479_, this.getTurretShootPos((Entity)living, (float)1.0f).f_82480_, this.getTurretShootPos((Entity)living, (float)1.0f).f_82481_));
                this.f_19804_.m_135381_(CANNON_RECOIL_TIME, (Object)40);
                this.f_19804_.m_135381_(LOADED_SHELL, (Object)"null");
                this.consumeEnergy(10000);
                this.f_19804_.m_135381_(YAW, (Object)Float.valueOf(this.getTurretYRot()));
                this.reloadCoolDown = 80;
                Level level = this.m_9236_();
                if (level instanceof ServerLevel) {
                    ServerLevel server = (ServerLevel)level;
                    server.m_8767_((ParticleOptions)ParticleTypes.f_123777_, this.m_20185_() + 5.0 * this.getBarrelVector((float)1.0f).f_82479_, this.m_20186_() + 0.1, this.m_20189_() + 5.0 * this.getBarrelVector((float)1.0f).f_82481_, 300, 6.0, 0.02, 6.0, 0.005);
                    double x = this.getTurretShootPos((Entity)living, (float)1.0f).f_82479_ + 9.0 * this.getBarrelVector((float)1.0f).f_82479_;
                    double y = this.getTurretShootPos((Entity)living, (float)1.0f).f_82480_ + 9.0 * this.getBarrelVector((float)1.0f).f_82480_;
                    double z = this.getTurretShootPos((Entity)living, (float)1.0f).f_82481_ + 9.0 * this.getBarrelVector((float)1.0f).f_82481_;
                    server.m_8767_((ParticleOptions)ParticleTypes.f_123777_, x, y, z, 10, 0.4, 0.4, 0.4, 0.0075);
                    server.m_8767_((ParticleOptions)ParticleTypes.f_123796_, x, y, z, 10, 0.4, 0.4, 0.4, 0.0075);
                    int count = 6;
                    for (float i = 9.5f; i < 23.0f; i += 0.5f) {
                        server.m_8767_((ParticleOptions)ParticleTypes.f_123777_, this.getTurretShootPos((Entity)living, (float)1.0f).f_82479_ + (double)i * this.getBarrelVector((float)1.0f).f_82479_, this.getTurretShootPos((Entity)living, (float)1.0f).f_82480_ + (double)i * this.getBarrelVector((float)1.0f).f_82480_, this.getTurretShootPos((Entity)living, (float)1.0f).f_82481_ + (double)i * this.getBarrelVector((float)1.0f).f_82481_, Mth.m_14045_((int)count--, (int)1, (int)5), 0.15, 0.15, 0.15, 0.0025);
                    }
                    Matrix4f transform = this.getBarrelTransform(1.0f);
                    Vector4f worldPositionL = this.transformPosition(transform, -0.35f, 0.0f, 0.0f);
                    Vector4f worldPositionR = this.transformPosition(transform, 0.35f, 0.0f, 0.0f);
                    for (float i = 3.0f; i < 6.0f; i += 0.5f) {
                        server.m_8767_((ParticleOptions)ParticleTypes.f_123796_, (double)worldPositionL.x + (double)i * this.getBarrelVector((float)1.0f).f_82479_, (double)worldPositionL.y + (double)i * this.getBarrelVector((float)1.0f).f_82480_, (double)worldPositionL.z + (double)i * this.getBarrelVector((float)1.0f).f_82481_, 1, 0.025, 0.025, 0.025, 0.0015);
                        server.m_8767_((ParticleOptions)ParticleTypes.f_123796_, (double)worldPositionR.x + (double)i * this.getBarrelVector((float)1.0f).f_82479_, (double)worldPositionR.y + (double)i * this.getBarrelVector((float)1.0f).f_82480_, (double)worldPositionR.z + (double)i * this.getBarrelVector((float)1.0f).f_82481_, 1, 0.025, 0.025, 0.025, 0.0015);
                    }
                }
                ShakeClientMessage.sendToNearbyPlayers(this, 8.0, 10.0, 8.0, 60.0);
            } else if (this.getWeaponIndex(0) == 4) {
                if (this.cannotFireCoax) {
                    return;
                }
                if ((Integer)this.f_19804_.m_135370_(MG_AMMO) > 0 || hasCreativeAmmo) {
                    ProjectileEntity projectileRight = ((ProjectileWeapon)this.getWeapon(0)).create(living).setGunItemId(this.m_6095_().m_20675_() + ".1");
                    projectileRight.m_6034_(this.getTurretShootPos((Entity)living, (float)1.0f).f_82479_, this.getTurretShootPos((Entity)living, (float)1.0f).f_82480_, this.getTurretShootPos((Entity)living, (float)1.0f).f_82481_);
                    projectileRight.shoot(living, this.getBarrelVector((float)1.0f).f_82479_, this.getBarrelVector((float)1.0f).f_82480_, this.getBarrelVector((float)1.0f).f_82481_, 20.0f, 0.25f);
                    this.m_9236_().m_7967_((Entity)projectileRight);
                    this.f_19804_.m_135381_(COAX_HEAT, (Object)((Integer)this.f_19804_.m_135370_(COAX_HEAT) + 4));
                    this.f_19804_.m_135381_(FIRE_ANIM, (Object)2);
                    this.playShootSound3p(living, 0, 4, 12, 24, new Vec3(this.getTurretShootPos((Entity)living, (float)1.0f).f_82479_, this.getTurretShootPos((Entity)living, (float)1.0f).f_82480_, this.getTurretShootPos((Entity)living, (float)1.0f).f_82481_));
                    if (!hasCreativeAmmo) {
                        ItemStack ammoBox = this.m_213659_().stream().filter(stack -> {
                            if (stack.m_150930_((Item)ModItems.AMMO_BOX.get())) {
                                return Ammo.HEAVY.get((ItemStack)stack) > 0;
                            }
                            return false;
                        }).findFirst().orElse(ItemStack.f_41583_);
                        if (!ammoBox.m_41619_()) {
                            Ammo.HEAVY.add(ammoBox, -1);
                        } else {
                            this.m_213659_().stream().filter(stack -> stack.m_150930_((Item)ModItems.HEAVY_AMMO.get())).findFirst().ifPresent(stack -> stack.m_41774_(1));
                        }
                    }
                }
            }
        }
        if (type == 1) {
            if (!this.canShoot(living)) {
                return;
            }
            ProjectileWeapon projectile = (ProjectileWeapon)this.getWeapon(1);
            ProjectileEntity projectileEntity = projectile.create(living).setGunItemId(this.m_6095_().m_20675_() + ".2");
            projectileEntity.m_6034_(this.passengerWeaponShootPos((Entity)living, (float)1.0f).f_82479_, this.passengerWeaponShootPos((Entity)living, (float)1.0f).f_82480_, this.passengerWeaponShootPos((Entity)living, (float)1.0f).f_82481_);
            projectileEntity.m_6686_(this.getGunnerVector((float)1.0f).f_82479_, this.getGunnerVector((float)1.0f).f_82480_, this.getGunnerVector((float)1.0f).f_82481_, 20.0f, 0.3f);
            this.m_9236_().m_7967_((Entity)projectileEntity);
            this.playShootSound3p(living, 1, 4, 12, 24, new Vec3(this.passengerWeaponShootPos((Entity)living, (float)1.0f).f_82479_, this.passengerWeaponShootPos((Entity)living, (float)1.0f).f_82480_, this.passengerWeaponShootPos((Entity)living, (float)1.0f).f_82481_));
            this.f_19804_.m_135381_(GUN_FIRE_TIME, (Object)2);
            this.f_19804_.m_135381_(HEAT, (Object)((Integer)this.f_19804_.m_135370_(HEAT) + 4));
            ShakeClientMessage.sendToNearbyPlayers(this, 4.0, 6.0, 4.0, 6.0);
            if (hasCreativeAmmo) {
                return;
            }
            ItemStack ammoBox = this.m_213659_().stream().filter(stack -> {
                if (stack.m_150930_((Item)ModItems.AMMO_BOX.get())) {
                    return Ammo.HEAVY.get((ItemStack)stack) > 0;
                }
                return false;
            }).findFirst().orElse(ItemStack.f_41583_);
            if (!ammoBox.m_41619_()) {
                Ammo.HEAVY.add(ammoBox, -1);
            } else {
                this.consumeItem(this.getWeapon((int)1).ammo, 1);
            }
        }
        if (type == 2) {
            Mob mob;
            Matrix4f transformT = this.getTurretTransform(1.0f);
            Vector4f worldPosition = new Vector4f();
            int ammo = (Integer)this.m_20088_().m_135370_(LOADED_DRONE);
            if (ammo == 1) {
                worldPosition = this.transformPosition(transformT, -1.6290874f, 0.75536877f, -1.7661687f);
            }
            if (ammo == 2) {
                worldPosition = this.transformPosition(transformT, 1.6290874f, 0.75536877f, -1.7661687f);
            }
            if (ammo == 3) {
                worldPosition = this.transformPosition(transformT, -1.7822125f, 0.75536877f, -1.9193f);
            }
            if (ammo == 4) {
                worldPosition = this.transformPosition(transformT, 1.7822125f, 0.75536877f, -1.9193f);
            }
            if (ammo == 5) {
                worldPosition = this.transformPosition(transformT, -1.6290874f, 0.75536877f, -2.0724187f);
            }
            if (ammo == 6) {
                worldPosition = this.transformPosition(transformT, 1.6290874f, 0.75536877f, -2.0724187f);
            }
            if (ammo == 7) {
                worldPosition = this.transformPosition(transformT, -1.7822125f, 0.75536877f, -2.22555f);
            }
            if (ammo == 8) {
                worldPosition = this.transformPosition(transformT, 1.7822125f, 0.75536877f, -2.22555f);
            }
            if (ammo == 9) {
                worldPosition = this.transformPosition(transformT, -1.6290874f, 0.75536877f, -2.3786688f);
            }
            if (ammo == 10) {
                worldPosition = this.transformPosition(transformT, 1.6290874f, 0.75536877f, -2.3786688f);
            }
            if (ammo == 11) {
                worldPosition = this.transformPosition(transformT, -1.7822125f, 0.75536877f, -2.5318f);
            }
            if (ammo == 12) {
                worldPosition = this.transformPosition(transformT, 1.7822125f, 0.75536877f, -2.5318f);
            }
            if (ammo == 13) {
                worldPosition = this.transformPosition(transformT, -1.6290874f, 0.75536877f, -2.6849186f);
            }
            if (ammo == 14) {
                worldPosition = this.transformPosition(transformT, 1.6290874f, 0.75536877f, -2.6849186f);
            }
            Vec3 lookVec = living.m_20252_(1.0f);
            Entity lookingEntity = SeekTool.seekLivingEntity((Entity)living, this.m_9236_(), 384.0, 6.0);
            SwarmDroneEntity swarmDroneEntity = ((SwarmDroneWeapon)this.getWeapon(2)).create(living);
            Vector4f shootPosition1 = this.transformPosition(transformT, 0.0f, 0.0f, 0.0f);
            Vector4f shootPosition2 = this.transformPosition(transformT, 0.0f, 1.0f, 0.0f);
            Vec3 direct = new Vec3((double)shootPosition1.x, (double)shootPosition1.y, (double)shootPosition1.z).m_82505_(new Vec3((double)shootPosition2.x, (double)shootPosition2.y, (double)shootPosition2.z));
            swarmDroneEntity.m_6034_(worldPosition.x, worldPosition.y, worldPosition.z);
            swarmDroneEntity.m_6686_(direct.f_82479_, direct.f_82480_, direct.f_82481_, 1.2f, 10.0f);
            if (living instanceof Mob && (mob = (Mob)living).m_5448_() != null) {
                LivingEntity target = mob.m_5448_();
                if (target.m_20202_() != null) {
                    target = target.m_20202_();
                }
                swarmDroneEntity.setGuideType(0);
                swarmDroneEntity.setTargetUuid(target.m_20149_());
                swarmDroneEntity.setTargetVec(target.m_20191_().m_82399_());
            } else if (living instanceof Player) {
                SwarmDroneEntity swarmDrone;
                if (!(lookingEntity == null || lookingEntity instanceof SwarmDroneEntity && (swarmDrone = (SwarmDroneEntity)lookingEntity).m_19749_() == living)) {
                    swarmDroneEntity.setGuideType(0);
                    swarmDroneEntity.setTargetUuid(lookingEntity.m_20149_());
                    swarmDroneEntity.setTargetVec(lookingEntity.m_146892_());
                } else {
                    swarmDroneEntity.setGuideType(1);
                    BlockHitResult result = this.m_9236_().m_45547_(new ClipContext(living.m_146892_(), living.m_146892_().m_82549_(lookVec.m_82490_(384.0)), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this));
                    Vec3 hitPos = result.m_82450_();
                    swarmDroneEntity.setTargetVec(hitPos);
                }
            }
            living.m_9236_().m_7967_((Entity)swarmDroneEntity);
            this.m_9236_().m_5594_(null, BlockPos.m_274446_((Position)new Vec3((double)worldPosition.x, (double)worldPosition.y, (double)worldPosition.z)), (SoundEvent)ModSounds.DECOY_FIRE.get(), SoundSource.PLAYERS, 1.0f, this.f_19796_.m_188501_() * 0.05f + 1.0f);
            this.f_19804_.m_135381_(LOADED_DRONE, (Object)((Integer)this.m_20088_().m_135370_(LOADED_DRONE) - 1));
            this.droneReloadCoolDown = 100;
        }
    }

    @Override
    public void travel() {
        this.trackEngine(false, 0.0, (Integer)VehicleConfig.YX_100_ENERGY_COST.get(), 1.25, 0.75, 1.3, 0.6, 0.25f, -0.2f, 0.0026f, 0.002f, 0.1f);
    }

    @Override
    public SoundEvent getEngineSound() {
        return (SoundEvent)ModSounds.YX_100_ENGINE.get();
    }

    @Override
    public float getEngineSoundVolume() {
        return Math.max((float)Mth.m_14154_((float)((Float)this.f_19804_.m_135370_(POWER)).floatValue()), (float)Mth.m_14154_((float)(0.1f * ((Float)this.f_19804_.m_135370_(DELTA_ROT)).floatValue()))) * 2.5f;
    }

    public void m_19956_(@NotNull Entity passenger, @NotNull Entity.MoveFunction callback) {
        if (!this.m_20363_(passenger)) {
            return;
        }
        Matrix4f transform = this.getTurretTransform(1.0f);
        int i = this.getOrderedPassengers().indexOf(passenger);
        Vector4f worldPosition = switch (i) {
            case 0 -> this.transformPosition(transform, 0.6669625f, 0.07f, 0.4776875f);
            case 1 -> this.transformPosition(transform, -0.7580562f, 0.3f, -0.57275623f);
            case 2 -> this.transformPosition(transform, 0.86219376f, 0.07f, -0.5696875f);
            default -> throw new IllegalStateException("Unexpected value: " + i);
        };
        passenger.m_6034_((double)worldPosition.x, (double)worldPosition.y, (double)worldPosition.z);
        callback.m_20372_(passenger, (double)worldPosition.x, (double)worldPosition.y, (double)worldPosition.z);
        this.copyEntityData(passenger);
    }

    public void copyEntityData(Entity entity) {
        if (entity == this.getNthEntity(0)) {
            entity.m_5618_(this.getBarrelYRot(1.0f));
        }
    }

    @Override
    public Vec3 driverZoomPos(float ticks) {
        Matrix4f transform = this.getTurretTransform(ticks);
        Vector4f worldPosition = this.transformPosition(transform, 0.0f, 1.0f, 0.6076875f);
        return new Vec3((double)worldPosition.x, (double)worldPosition.y, (double)worldPosition.z);
    }

    @Override
    public int getMaxPassengers() {
        return 3;
    }

    @Override
    public Vec3 getBarrelVector(float pPartialTicks) {
        Matrix4f transform = this.getBarrelTransform(pPartialTicks);
        Vector4f rootPosition = this.transformPosition(transform, 0.0f, 0.0f, 0.0f);
        Vector4f targetPosition = this.transformPosition(transform, 0.0f, 0.0f, 1.0f);
        return new Vec3((double)rootPosition.x, (double)rootPosition.y, (double)rootPosition.z).m_82505_(new Vec3((double)targetPosition.x, (double)targetPosition.y, (double)targetPosition.z));
    }

    public Vec3 getTurretVector(float pPartialTicks) {
        Matrix4f transform = this.getTurretTransform(pPartialTicks);
        Vector4f rootPosition = this.transformPosition(transform, 0.0f, 0.0f, 0.0f);
        Vector4f targetPosition = this.transformPosition(transform, 0.0f, 0.0f, 1.0f);
        return new Vec3((double)rootPosition.x, (double)rootPosition.y, (double)rootPosition.z).m_82505_(new Vec3((double)targetPosition.x, (double)targetPosition.y, (double)targetPosition.z));
    }

    @Override
    public Vec3 getGunnerVector(float pPartialTicks) {
        Matrix4f transform = this.getGunnerBarrelTransform(pPartialTicks);
        Vector4f rootPosition = this.transformPosition(transform, 0.0f, 0.0f, 0.0f);
        Vector4f targetPosition = this.transformPosition(transform, 0.0f, 0.0f, 1.0f);
        return new Vec3((double)rootPosition.x, (double)rootPosition.y, (double)rootPosition.z).m_82505_(new Vec3((double)targetPosition.x, (double)targetPosition.y, (double)targetPosition.z));
    }

    public Matrix4f getBarrelTransform(float ticks) {
        Matrix4f transformT = this.getTurretTransform(ticks);
        Matrix4f transform = new Matrix4f();
        Vector4f worldPosition = this.transformPosition(transform, 0.0f, 0.56345f, 0.6477125f);
        transformT.translate(worldPosition.x, worldPosition.y, worldPosition.z);
        float a = this.getTurretYaw(ticks);
        float r = (Mth.m_14154_((float)a) - 90.0f) / 90.0f;
        float r2 = Mth.m_14154_((float)a) <= 90.0f ? a / 90.0f : (a < 0.0f ? -(180.0f + a) / 90.0f : (180.0f - a) / 90.0f);
        float x = Mth.m_14179_((float)ticks, (float)this.turretXRotO, (float)this.getTurretXRot());
        float xV = Mth.m_14179_((float)ticks, (float)this.f_19860_, (float)this.m_146909_());
        float z = Mth.m_14179_((float)ticks, (float)this.prevRoll, (float)this.getRoll());
        transformT.rotate((Quaternionfc)Axis.f_252529_.m_252977_(x + r * xV + r2 * z));
        return transformT;
    }

    @Override
    public Matrix4f getTurretTransform(float ticks) {
        Matrix4f transformV = this.getVehicleTransform(ticks);
        Matrix4f transform = new Matrix4f();
        Vector4f worldPosition = this.transformPosition(transform, 0.0f, 2.1059375f, -0.43125f);
        transformV.translate(worldPosition.x, worldPosition.y, worldPosition.z);
        transformV.rotate((Quaternionfc)Axis.f_252436_.m_252977_(Mth.m_14179_((float)ticks, (float)this.turretYRotO, (float)this.getTurretYRot())));
        return transformV;
    }

    public Matrix4f getGunTransform(float ticks) {
        Matrix4f transformT = this.getTurretTransform(ticks);
        Matrix4f transform = new Matrix4f();
        Vector4f worldPosition = this.transformPosition(transform, -0.7580562f, 1.1446375f, -0.57275623f);
        transformT.translate(worldPosition.x, worldPosition.y, worldPosition.z);
        transformT.rotate((Quaternionfc)Axis.f_252436_.m_252977_(Mth.m_14179_((float)ticks, (float)this.gunYRotO, (float)this.getGunYRot()) - Mth.m_14179_((float)ticks, (float)this.turretYRotO, (float)this.getTurretYRot())));
        return transformT;
    }

    public Matrix4f getGunnerBarrelTransform(float ticks) {
        Matrix4f transformG = this.getGunTransform(ticks);
        Matrix4f transform = new Matrix4f();
        Vector4f worldPosition = this.transformPosition(transform, 0.0f, 0.35984376f, 0.0551625f);
        transformG.translate(worldPosition.x, worldPosition.y, worldPosition.z);
        float a = this.getTurretYaw(ticks);
        float r = (Mth.m_14154_((float)a) - 90.0f) / 90.0f;
        float r2 = Mth.m_14154_((float)a) <= 90.0f ? a / 90.0f : (a < 0.0f ? -(180.0f + a) / 90.0f : (180.0f - a) / 90.0f);
        float x = Mth.m_14179_((float)ticks, (float)this.gunXRotO, (float)this.getGunXRot());
        float xV = Mth.m_14179_((float)ticks, (float)this.f_19860_, (float)this.m_146909_());
        float z = Mth.m_14179_((float)ticks, (float)this.prevRoll, (float)this.getRoll());
        transformG.rotate((Quaternionfc)Axis.f_252529_.m_252977_(x + r * xV + r2 * z));
        return transformG;
    }

    @Override
    public float rotateYOffset() {
        return 3.5f;
    }

    protected void clampRotation(Entity entity) {
        Minecraft mc = Minecraft.m_91087_();
        if (entity.m_9236_().f_46443_ && entity == this.m_146895_()) {
            float a = this.getTurretYaw(1.0f);
            float r = (Mth.m_14154_((float)a) - 90.0f) / 90.0f;
            float r2 = Mth.m_14154_((float)a) <= 90.0f ? a / 90.0f : (a < 0.0f ? -(180.0f + a) / 90.0f : (180.0f - a) / 90.0f);
            float min = -this.turretMaxPitch() - r * this.m_146909_() - r2 * this.getRoll();
            float max = -this.turretMinPitch() - r * this.m_146909_() - r2 * this.getRoll();
            float f = Mth.m_14177_((float)entity.m_146909_());
            float f1 = Mth.m_14036_((float)f, (float)min, (float)max);
            entity.f_19860_ += f1 - f;
            entity.m_146926_(entity.m_146909_() + f1 - f);
            if (mc.f_91066_.m_92176_() == CameraType.FIRST_PERSON) {
                float f2 = Mth.m_14177_((float)(entity.m_146908_() - this.getBarrelYRot(1.0f)));
                float f3 = Mth.m_14036_((float)f2, (float)-20.0f, (float)20.0f);
                entity.f_19859_ += f3 - f2;
                entity.m_146922_(entity.m_146908_() + f3 - f2);
                entity.m_5618_(this.getBarrelYRot(1.0f));
            }
        } else if (entity == this.getNthEntity(1)) {
            float a = this.getTurretYaw(1.0f);
            float r = (Mth.m_14154_((float)a) - 90.0f) / 90.0f;
            float r2 = Mth.m_14154_((float)a) <= 90.0f ? a / 90.0f : (a < 0.0f ? -(180.0f + a) / 90.0f : (180.0f - a) / 90.0f);
            float min = -this.passengerWeaponMaxPitch() - r * this.m_146909_() - r2 * this.getRoll();
            float max = -this.passengerWeaponMinPitch() - r * this.m_146909_() - r2 * this.getRoll();
            float f = Mth.m_14177_((float)entity.m_146909_());
            float f1 = Mth.m_14036_((float)f, (float)min, (float)max);
            entity.f_19860_ += f1 - f;
            entity.m_146926_(entity.m_146909_() + f1 - f);
            if (mc.f_91066_.m_92176_() == CameraType.FIRST_PERSON) {
                float f2 = Mth.m_14177_((float)(entity.m_146908_() - this.getGunYRot(1.0f)));
                float f3 = Mth.m_14036_((float)f2, (float)-150.0f, (float)150.0f);
                entity.f_19859_ += f3 - f2;
                entity.m_146922_(entity.m_146908_() + f3 - f2);
                entity.m_5618_(entity.m_146908_());
            }
        } else if (entity == this.getNthEntity(2)) {
            float a = this.getTurretYaw(1.0f);
            float r = (Mth.m_14154_((float)a) - 90.0f) / 90.0f;
            float r2 = Mth.m_14154_((float)a) <= 90.0f ? a / 90.0f : (a < 0.0f ? -(180.0f + a) / 90.0f : (180.0f - a) / 90.0f);
            float min = -90.0f - r * this.m_146909_() - r2 * this.getRoll();
            float max = 22.5f - r * this.m_146909_() - r2 * this.getRoll();
            float f = Mth.m_14177_((float)entity.m_146909_());
            float f1 = Mth.m_14036_((float)f, (float)min, (float)max);
            entity.f_19860_ += f1 - f;
            entity.m_146926_(entity.m_146909_() + f1 - f);
        }
    }

    public void m_7340_(@NotNull Entity entity) {
        this.clampRotation(entity);
    }

    @Override
    public int passengerSeatLocation(Entity entity) {
        return 1;
    }

    private PlayState cannonShootPredicate(AnimationState<Yx100Entity> event) {
        if ((Integer)this.f_19804_.m_135370_(CANNON_RECOIL_TIME) > 0) {
            return event.setAndContinue(RawAnimation.begin().thenPlayAndHold("animation.yx100.fire"));
        }
        return event.setAndContinue(RawAnimation.begin().thenLoop("animation.yx100.idle"));
    }

    private PlayState coaxShootPredicate(AnimationState<Yx100Entity> event) {
        if ((Integer)this.f_19804_.m_135370_(FIRE_ANIM) > 0) {
            return event.setAndContinue(RawAnimation.begin().thenPlayAndHold("animation.yx100.fire_coax"));
        }
        return event.setAndContinue(RawAnimation.begin().thenLoop("animation.yx100.idle_coax"));
    }

    private PlayState gunShootPredicate(AnimationState<Yx100Entity> event) {
        if ((Integer)this.f_19804_.m_135370_(GUN_FIRE_TIME) > 0) {
            return event.setAndContinue(RawAnimation.begin().thenPlayAndHold("animation.yx100.fire2"));
        }
        return event.setAndContinue(RawAnimation.begin().thenLoop("animation.yx100.idle2"));
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
        data.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "cannon", 0, this::cannonShootPredicate)});
        data.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "coax", 0, this::coaxShootPredicate)});
        data.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "gun", 0, this::gunShootPredicate)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    @Override
    public int mainGunRpm(LivingEntity living) {
        if (living == this.getNthEntity(0)) {
            if (this.getWeapon((int)0).mainGun) {
                return 15;
            }
            if (this.getWeaponIndex(0) == 4) {
                return 500;
            }
        }
        if (living == this.getNthEntity(1)) {
            return 500;
        }
        if (living == this.getNthEntity(2)) {
            return 600;
        }
        return 15;
    }

    @Override
    public boolean canShoot(LivingEntity living) {
        if (living == this.getNthEntity(0)) {
            if (this.getWeapon((int)0).mainGun) {
                return !((String)this.f_19804_.m_135370_(LOADED_SHELL)).equals("null") && this.getEnergy() > (Integer)VehicleConfig.YX_100_SHOOT_COST.get();
            }
            if (this.getWeaponIndex(0) == 4) {
                return ((Integer)this.f_19804_.m_135370_(MG_AMMO) > 0 || InventoryTool.hasCreativeAmmoBox((Entity)living)) && !this.cannotFireCoax;
            }
        }
        if (living == this.getNthEntity(1)) {
            return ((Integer)this.f_19804_.m_135370_(MG_AMMO) > 0 || InventoryTool.hasCreativeAmmoBox((Entity)living)) && !this.cannotFire;
        }
        if (living == this.getNthEntity(2)) {
            return (Integer)this.f_19804_.m_135370_(LOADED_DRONE) > 0;
        }
        return false;
    }

    @Override
    public int getAmmoCount(LivingEntity living) {
        if (living == this.getNthEntity(0)) {
            if (this.getWeapon((int)0).mainGun) {
                return ((String)this.f_19804_.m_135370_(LOADED_SHELL)).equals("null") ? 0 : 1;
            }
            if (this.getWeaponIndex(0) == 4) {
                return (Integer)this.f_19804_.m_135370_(MG_AMMO);
            }
        }
        if (living == this.getNthEntity(1)) {
            return (Integer)this.f_19804_.m_135370_(MG_AMMO);
        }
        if (living == this.getNthEntity(2)) {
            return (Integer)this.f_19804_.m_135370_(LOADED_DRONE);
        }
        return 0;
    }

    @Override
    public boolean banHand(LivingEntity entity) {
        if (entity == this.getNthEntity(0) || entity == this.getNthEntity(1)) {
            return true;
        }
        return entity == this.getNthEntity(2) && !entity.m_6144_();
    }

    @Override
    public boolean hidePassenger(int index) {
        return index == 0 || index == 1;
    }

    @Override
    public int zoomFov() {
        return 3;
    }

    @Override
    public boolean hasTracks() {
        return true;
    }

    @Override
    public int getWeaponHeat(LivingEntity living) {
        if (living == this.getNthEntity(0)) {
            return (Integer)this.f_19804_.m_135370_(COAX_HEAT);
        }
        if (living == this.getNthEntity(1)) {
            return (Integer)this.f_19804_.m_135370_(HEAT);
        }
        return 0;
    }

    @Override
    public void changeWeapon(int index, int value, boolean isScroll) {
        int typeIndex;
        if (index != 0) {
            return;
        }
        List weapons = this.getAvailableWeapons(index);
        if (weapons.isEmpty()) {
            return;
        }
        int count = weapons.size();
        int n = typeIndex = isScroll ? (value + this.getWeaponIndex(index) + count) % count : value;
        if (typeIndex == 0 || typeIndex == 1 || typeIndex == 2 || typeIndex == 3) {
            Player pPlayer;
            boolean hasCreativeAmmo = false;
            for (int i = 0; i < this.getMaxPassengers(); ++i) {
                Entity entity = this.getNthEntity(i);
                if (!(entity instanceof Player) || !InventoryTool.hasCreativeAmmoBox((Entity)(pPlayer = (Player)entity))) continue;
                hasCreativeAmmo = true;
            }
            if (typeIndex != (Integer)this.f_19804_.m_135370_(SELECTED_AMMO_TYPE)) {
                this.reloadCoolDown = 80;
                Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation((String)this.f_19804_.m_135370_(LOADED_SHELL)));
                if (item == null) {
                    return;
                }
                if (!((String)this.f_19804_.m_135370_(LOADED_SHELL)).equals("null") && !hasCreativeAmmo) {
                    this.insertItem(new ItemStack((ItemLike)item).m_41720_(), 1);
                }
                this.f_19804_.m_135381_(LOADED_SHELL, (Object)"null");
            }
            if ((pPlayer = this.m_146895_()) instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)pPlayer;
                ClientboundStopSoundPacket clientboundstopsoundpacket = new ClientboundStopSoundPacket(((SoundEvent)ModSounds.YX_100_RELOAD.get()).m_11660_(), SoundSource.PLAYERS);
                player.f_8906_.m_9829_((Packet)clientboundstopsoundpacket);
            }
        }
        WeaponVehicleEntity.super.changeWeapon(index, value, isScroll);
    }

    @Override
    public Vec3 getGunVec(float ticks) {
        return this.getGunnerVector(ticks);
    }

    @Override
    public ResourceLocation getVehicleIcon() {
        return Mod.loc("textures/vehicle_icon/yx_100_icon.png");
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void renderFirstPersonOverlay(GuiGraphics guiGraphics, PoseStack poseStack, Font font, Player player, int screenWidth, int screenHeight, float scale, int color) {
        float minWH = Math.min((int)screenWidth, (int)screenHeight);
        float scaledMinWH = Mth.m_14143_((float)(minWH * scale));
        float centerW = ((float)screenWidth - scaledMinWH) / 2.0f;
        float centerH = ((float)screenHeight - scaledMinWH) / 2.0f;
        RenderSystem.disableDepthTest();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.enableBlend();
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.getWeapon((int)0).mainGun) {
            RenderHelper.blit(poseStack, Mod.loc("textures/screens/land/tank_cannon_cross.png"), centerW, centerH, 0.0f, 0.0f, scaledMinWH, scaledMinWH, scaledMinWH, scaledMinWH, color);
        } else {
            RenderHelper.blit(poseStack, Mod.loc("textures/screens/land/lav_gun_cross.png"), centerW, centerH, 0.0f, 0.0f, scaledMinWH, scaledMinWH, scaledMinWH, scaledMinWH, color);
        }
        if (this.getWeaponIndex(0) == 0) {
            guiGraphics.m_280614_(font, (Component)Component.m_237113_((String)("AP SHELL  " + this.getAmmoCount((LivingEntity)player) + " " + (Serializable)(InventoryTool.hasCreativeAmmoBox((Entity)player) ? "\u221e" : (Serializable)this.m_20088_().m_135370_(AMMO)))), screenWidth / 2 - 33, screenHeight - 65, color, false);
        } else if (this.getWeaponIndex(0) == 1) {
            guiGraphics.m_280614_(font, (Component)Component.m_237113_((String)("HE SHELL  " + this.getAmmoCount((LivingEntity)player) + " " + (Serializable)(InventoryTool.hasCreativeAmmoBox((Entity)player) ? "\u221e" : (Serializable)this.m_20088_().m_135370_(AMMO)))), screenWidth / 2 - 33, screenHeight - 65, color, false);
        } else if (this.getWeaponIndex(0) == 2) {
            guiGraphics.m_280614_(font, (Component)Component.m_237113_((String)("CM SHELL  " + this.getAmmoCount((LivingEntity)player) + " " + (Serializable)(InventoryTool.hasCreativeAmmoBox((Entity)player) ? "\u221e" : (Serializable)this.m_20088_().m_135370_(AMMO)))), screenWidth / 2 - 33, screenHeight - 65, color, false);
        } else if (this.getWeaponIndex(0) == 3) {
            guiGraphics.m_280614_(font, (Component)Component.m_237113_((String)("GRAPESHOT " + this.getAmmoCount((LivingEntity)player) + " " + (Serializable)(InventoryTool.hasCreativeAmmoBox((Entity)player) ? "\u221e" : (Serializable)this.m_20088_().m_135370_(AMMO)))), screenWidth / 2 - 33, screenHeight - 65, color, false);
        } else if (this.getWeaponIndex(0) == 4) {
            int heat = (Integer)this.m_20088_().m_135370_(COAX_HEAT);
            guiGraphics.m_280614_(font, (Component)Component.m_237113_((String)(" 12.7MM HMG " + (Serializable)(InventoryTool.hasCreativeAmmoBox((Entity)player) ? "\u221e" : Integer.valueOf(this.getAmmoCount((LivingEntity)player))))), screenWidth / 2 - 33, screenHeight - 65, MathTool.getGradientColor(color, 0xFF0000, heat, 2), false);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void renderThirdPersonOverlay(GuiGraphics guiGraphics, Font font, Player player, int screenWidth, int screenHeight, float scale) {
        if (this.getWeaponIndex(0) == 0) {
            guiGraphics.m_280614_(font, (Component)Component.m_237113_((String)("AP SHELL " + this.getAmmoCount((LivingEntity)player) + " " + (Serializable)(InventoryTool.hasCreativeAmmoBox((Entity)player) ? "\u221e" : (Serializable)this.m_20088_().m_135370_(AMMO)))), 30, -9, -1, false);
        } else if (this.getWeaponIndex(0) == 1) {
            guiGraphics.m_280614_(font, (Component)Component.m_237113_((String)("HE SHELL " + this.getAmmoCount((LivingEntity)player) + " " + (Serializable)(InventoryTool.hasCreativeAmmoBox((Entity)player) ? "\u221e" : (Serializable)this.m_20088_().m_135370_(AMMO)))), 30, -9, -1, false);
        } else if (this.getWeaponIndex(0) == 2) {
            guiGraphics.m_280614_(font, (Component)Component.m_237113_((String)("CM SHELL " + this.getAmmoCount((LivingEntity)player) + " " + (Serializable)(InventoryTool.hasCreativeAmmoBox((Entity)player) ? "\u221e" : (Serializable)this.m_20088_().m_135370_(AMMO)))), 30, -9, -1, false);
        } else if (this.getWeaponIndex(0) == 3) {
            guiGraphics.m_280614_(font, (Component)Component.m_237113_((String)("GRAPESHOT" + this.getAmmoCount((LivingEntity)player) + " " + (Serializable)(InventoryTool.hasCreativeAmmoBox((Entity)player) ? "\u221e" : (Serializable)this.m_20088_().m_135370_(AMMO)))), 30, -9, -1, false);
        } else if (this.getWeaponIndex(0) == 4) {
            double heat2 = (float)((Integer)this.m_20088_().m_135370_(COAX_HEAT)).intValue() / 100.0f;
            guiGraphics.m_280614_(font, (Component)Component.m_237113_((String)("12.7MM HMG " + (Serializable)(InventoryTool.hasCreativeAmmoBox((Entity)player) ? "\u221e" : Integer.valueOf(this.getAmmoCount((LivingEntity)player))))), 30, -9, Mth.m_14169_((float)0.0f, (float)((float)heat2), (float)1.0f), false);
        }
    }

    @Override
    public boolean hasDecoy() {
        return true;
    }

    @Override
    public double getSensitivity(double original, boolean zoom, int seatIndex, boolean isOnGround) {
        if (seatIndex == 0) {
            return zoom ? 0.17 : (Minecraft.m_91087_().f_91066_.m_92176_().m_90612_() ? 0.22 : 0.35);
        }
        if (seatIndex == 1) {
            return zoom ? 0.25 : (Minecraft.m_91087_().f_91066_.m_92176_().m_90612_() ? 0.35 : 0.4);
        }
        return original;
    }

    @Override
    public boolean isEnclosed(int index) {
        return index != 2;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    @Nullable
    public Vec2 getCameraRotation(float partialTicks, Player player, boolean zoom, boolean isFirstPerson) {
        if (zoom || isFirstPerson) {
            if (this.getSeatIndex((Entity)player) == 0) {
                return new Vec2((float)(-Yx100Entity.getYRotFromVector(this.getBarrelVec(partialTicks))), (float)(-Yx100Entity.getXRotFromVector(this.getBarrelVec(partialTicks))));
            }
            if (this.getSeatIndex((Entity)player) == 1) {
                return new Vec2((float)(-Yx100Entity.getYRotFromVector(this.getGunnerVector(partialTicks))), (float)(-Yx100Entity.getXRotFromVector(this.getGunnerVector(partialTicks))));
            }
        }
        return super.getCameraRotation(partialTicks, player, false, false);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Vec3 getCameraPosition(float partialTicks, Player player, boolean zoom, boolean isFirstPerson) {
        if (zoom || isFirstPerson) {
            if (this.getSeatIndex((Entity)player) == 0) {
                if (zoom) {
                    return new Vec3(this.driverZoomPos((float)partialTicks).f_82479_, this.driverZoomPos((float)partialTicks).f_82480_, this.driverZoomPos((float)partialTicks).f_82481_);
                }
                return new Vec3(Mth.m_14139_((double)partialTicks, (double)player.f_19854_, (double)player.m_20185_()), Mth.m_14139_((double)partialTicks, (double)(player.f_19855_ + (double)player.m_20192_()), (double)player.m_20188_()), Mth.m_14139_((double)partialTicks, (double)player.f_19856_, (double)player.m_20189_()));
            }
            if (this.getSeatIndex((Entity)player) == 1) {
                return new Vec3(Mth.m_14139_((double)partialTicks, (double)player.f_19854_, (double)player.m_20185_()), Mth.m_14139_((double)partialTicks, (double)(player.f_19855_ + (double)player.m_20192_()), (double)player.m_20188_()), Mth.m_14139_((double)partialTicks, (double)player.f_19856_, (double)player.m_20189_()));
            }
        }
        return super.getCameraPosition(partialTicks, player, false, false);
    }

    @Override
    @Nullable
    public ResourceLocation getVehicleItemIcon() {
        return Mod.loc("textures/gui/vehicle/type/land.png");
    }

    @Override
    public float getTurretMaxHealth() {
        return 100.0f;
    }

    @Override
    public float getWheelMaxHealth() {
        return 100.0f;
    }

    @Override
    public float getEngineMaxHealth() {
        return 150.0f;
    }

    @Override
    public List<OBB> getOBBs() {
        return List.of(this.obb, this.obb2, this.obb3, this.obb4, this.obb5, this.obbTurret, this.obbTurret2);
    }

    @Override
    public void updateOBB() {
        Matrix4f transform = this.getVehicleTransform(1.0f);
        Vector4f worldPosition = this.transformPosition(transform, 0.0f, 1.40625f, -0.375f);
        this.obb.center().set((Vector3fc)new Vector3f(worldPosition.x, worldPosition.y, worldPosition.z));
        this.obb.setRotation(VectorTool.combineRotations(1.0f, this));
        Vector4f worldPosition2 = this.transformPosition(transform, 0.0f, 1.28125f, 4.28125f);
        this.obb2.center().set((Vector3fc)new Vector3f(worldPosition2.x, worldPosition2.y, worldPosition2.z));
        this.obb2.setRotation(VectorTool.combineRotations(1.0f, this));
        Vector4f worldPosition3 = this.transformPosition(transform, 1.8125f, 0.84375f, 0.0625f);
        this.obb3.center().set((Vector3fc)new Vector3f(worldPosition3.x, worldPosition3.y, worldPosition3.z));
        this.obb3.setRotation(VectorTool.combineRotations(1.0f, this));
        Vector4f worldPosition4 = this.transformPosition(transform, -1.8125f, 0.84375f, 0.0625f);
        this.obb4.center().set((Vector3fc)new Vector3f(worldPosition4.x, worldPosition4.y, worldPosition4.z));
        this.obb4.setRotation(VectorTool.combineRotations(1.0f, this));
        Vector4f worldPosition5 = this.transformPosition(transform, 0.0f, 1.65625f, -3.9375f);
        this.obb5.center().set((Vector3fc)new Vector3f(worldPosition5.x, worldPosition5.y, worldPosition5.z));
        this.obb5.setRotation(VectorTool.combineRotations(1.0f, this));
        Matrix4f transformT = this.getTurretTransform(1.0f);
        Vector4f worldPositionT = this.transformPosition(transformT, 0.0f, 0.5625f, -1.125f);
        this.obbTurret.center().set((Vector3fc)new Vector3f(worldPositionT.x, worldPositionT.y, worldPositionT.z));
        this.obbTurret.setRotation(VectorTool.combineRotationsTurret(1.0f, this));
        Vector4f worldPositionT2 = this.transformPosition(transformT, 0.0f, 0.40625f, 1.65625f);
        this.obbTurret2.center().set((Vector3fc)new Vector3f(worldPositionT2.x, worldPositionT2.y, worldPositionT2.z));
        this.obbTurret2.setRotation(VectorTool.combineRotationsTurret(1.0f, this));
    }

    @Override
    public int getHudColor() {
        return 65526;
    }

    @Override
    public boolean hasPassengerTurretWeapon() {
        return true;
    }
}

